package dressing.model;

import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;

import org.eclipse.emf.common.util.EList;
import org.frs.debitage.engine.core.evalutor.Equation;
import org.frs.debitage.engine.core.evalutor.GeometricEngineException;
import org.frs.debitage.engine.core.evalutor.GeomtericEngine;

import dressing.model.debitage.DelimeterGenericDebitage;
import dressing.model.debitage.GenericDebitageFormula;
import param.Axe;
import param.ImportedParams;
import param.MechanicPrivateParam;
import param.MechanicPublicParam;
import param.impl.DelimeterImpl;

public class Delimeter {

	transient protected PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
	transient private boolean notificationon=true;
	private String name;
	private DelimeterImpl delimeter;
	private Axe axe;
	double position=0.0d;
	Intervale xint;
	Intervale yint;
	Intervale zint;
	UUID id=null;
	Properties props=new Properties();

	public Delimeter(DelimeterImpl delimeter) {
		super();
		this.name=delimeter.getName();
		this.delimeter = delimeter;
		this.axe=this.delimeter.getAxis();
		this.position=this.delimeter.getPosition();
	}
	public Delimeter(String name, Axe axe, double position) {
		super();
		this.name = name;
		this.axe = axe;
		this.position = position;
	}
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public DelimeterImpl getDelimeter() {
		return delimeter;
	}
	public void setDelimeter(DelimeterImpl delimeter) {
		this.delimeter = delimeter;
	}
	public Axe getAxe() {
		return axe;
	}
	public void setAxe(Axe axe) {
		this.axe = axe;
	}
	public double getPosition() {
		return position;
	}
	public void setPosition(double position) {
		this.position = position;
	}
	public void updateDelimeter() {
		this.axe=this.delimeter.getAxis();
		this.position=this.delimeter.getPosition();
	}
	
	public UUID getId() {
		return id;
	}
	public void setId(UUID id) {
		this.id = id;
	}
	public Intervale getXint() {
		return xint;
	}
	public void setXint(Intervale xint) {
		this.xint = xint;
	}

	public Intervale getYint() {
		return yint;
	}
	public void setYint(Intervale yint) {
		this.yint = yint;
	}
	public Intervale getZint() {
		return zint;
	}
	public void setZint(Intervale zint) {
		this.zint = zint;
	}
	
	@Override
	public String toString() {
		return "Delimeter [name=" + name + ", axe=" + axe + ", position=" + position + ", id=" + id + "]";
	}
	/**
	 * cette methode est utilise pour le debiotage dynamique
	 * @param eList 
	 * @param publicparams 
	 * @param privateparams 
	 * @throws DesignException
	 * @throws GeometricEngineException 
	 */
	public void constructGenericDebitage(List<MechanicPrivateParam> privateparams, List<MechanicPublicParam> publicparams, Object emf,DesignObject3D parent) throws DesignException, GeometricEngineException
	{
		//faire passer tous les variables categoriques dans les proprotes de design object
		// avnat de lancer le calcul de debitage et passer la resolutions
		//
//		Date deb=new Date();
		
		ArrayList<Equation> equations = new ArrayList<Equation>();
		DelimeterGenericDebitage.createupdateDebitage(parent,this,privateparams,publicparams,emf,equations);
		evaluategeneric(equations);
		equations.clear();
//		System.err.println("*** create delimeter dibtage****"+(new Date().getTime()-deb.getTime()));
	}
	/**
	 * Cette methode est utilsie pour le debitage generique
	 * @throws GeometricEngineException
	 * @throws DesignException
	 */
	public void evaluategeneric(ArrayList<Equation> equations) throws GeometricEngineException, DesignException
	{
		if(equations!=null)
		{
//			GenericDebitageFormula.EVALUATE(equations);
			GeomtericEngine.getInstance().setEquations(equations);
			GeomtericEngine.getInstance().reset();
			updateproperties(equations);
		}
		else
		{
			throw new DesignException("Debitage object is null");
		}
	}
	protected void updateproperties(ArrayList<Equation> equations) throws GeometricEngineException
	{
		setNotificationon(false);
		Equation eq=null;
		try {
			if(equations!=null)
			{
				
				eq  = Equation.FIND_EQUATION("@this.position@", equations);
				if(eq!=null)
				{
					GeomtericEngine.getInstance().resolveEquation(eq);
					setPosition(eq.getEvaluation(null));
					this.delimeter.setPosition(getPosition());
//					System.err.println(this.name + " @this.position@ founded to update");
				}
				else
				{
					throw new GeometricEngineException(this.name + " @this.position@ not found to update");
				}
				
			}
		} catch (GeometricEngineException e) {
			// TODO: handle exception
			e.printStackTrace();
			throw e;
		}
		finally {
			setNotificationon(true);
		}
		
	}

	public void setNotificationon(boolean notificationon) {
		this.notificationon = notificationon;
	}
	public boolean isNotificationon() {
		return notificationon;
	}
	public Properties getProps() {
		return props;
	}
	public void setProps(Properties props) {
		this.props = props;
	}
	
	public Object put(Object key, Object value) {
//		Object oldvalue=this.getProperty((String) key);
//		firePropertyChange((String) key, oldvalue, value);
		return this.props.put(key, value);
	}
	
	
	public String getProperty(String key) {
		return this.props.getProperty(key);
	}
	
	public String getProperty(String key, String defaultValue) {
		return this.props.getProperty(key, defaultValue);
	}
	
	public synchronized boolean isEmpty() {
		return this.props.isEmpty();
	}
	
	public synchronized Enumeration<Object> keys() {
		return this.props.keys();
	}
	
	public synchronized Enumeration<Object> elements() {
		return this.props.elements();
	}
	
	public synchronized Object get(Object key) {
		return this.props.get(key);
	}
	
	public synchronized void clear() {
		this.props.clear();
	}
	
	public Set<Object> keySet() {
		return this.props.keySet();
	}
	
	public Collection<Object> values() {
		return this.props.values();
	}
	
	public synchronized Object getOrDefault(Object key, Object defaultValue) {
		return this.props.getOrDefault(key, defaultValue);
	}
	
	public synchronized boolean remove(Object key, Object value) {
		return this.props.remove(key, value);
	}
	
	public synchronized boolean replace(Object key, Object oldValue, Object newValue) {
		return this.props.replace(key, oldValue, newValue);
		
	}
	  
	public Set<Map.Entry<Object,Object>> entrySet() {
		return  this.props.entrySet();
	}
	  
	public synchronized boolean containsKey(Object key) {
		return  this.props.containsKey(key);
	}
}
