package dressing.ui.util;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.Window;
import org.eclipse.nebula.widgets.tablecombo.TableCombo;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.wb.swt.ResourceManager;

import dressing.config.persistence.ResourceManagers;
import dressing.model.ModelProvider;
import dressing.ui.MaterialListWindow;
import dressing.ui.components.TableComboViewerSearch;
import param.Material;
import param.MechanicDesignElment;

public class DesignELementMaterialComposite extends Composite {
	private DataBindingContext m_bindingContext;

	MechanicDesignElment element;
	MechanicDesignElment origin;

	boolean dirty=false;
	private Label lblName;
	private TableComboViewerSearch tableComboViewerMaterial;
	private TableCombo tableComboMaterial;
	private Button btnLibre;
	private Button btnFacade;
	private Button btnElement;
	private Button btnDos;
	private MaterialTypeInstanceComposite elementMaterialType;
	PropertyChangeListener dirtyListener=new PropertyChangeListener() {
		
		@Override
		public void propertyChange(PropertyChangeEvent evt) {
			// TODO Auto-generated method stub
			dirty=true;
		}
	};

	private Button btnList;
	
	public DesignELementMaterialComposite(Composite parent,MechanicDesignElment element, int style) {
		this(parent, style);
		setElement(element);
	}
	/**
	 * Create the composite.
	 * @param parent
	 * @param style
	 */
	
	public DesignELementMaterialComposite(Composite parent, int style) {
		super(parent, style);
		setLayout(new GridLayout(7, false));
		Label lblMaterial = new Label(this, SWT.NONE);
		lblMaterial.setText("Matériaux");
		tableComboViewerMaterial = new TableComboViewerSearch(this, SWT.NONE);
		tableComboMaterial = tableComboViewerMaterial.getTableCombo();
		tableComboMaterial.setEditable(true);
		tableComboMaterial.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		tableComboMaterial.defineColumns(StaticUiObjects.MaterialColumns);
		tableComboViewerMaterial.setContentProvider(ArrayContentProvider.getInstance());
		tableComboViewerMaterial.setLabelProvider(SingleImageItemLabelProvider.getInstance());
		List<Material> materials=new ArrayList<Material>();
		materials.addAll(ResourceManagers.getIntance().getMaterials());
		materials.sort(new Comparator<Material>() {
			@Override
			public int compare(Material o1, Material o2) {
				
				return o1.getName().compareTo(o2.getName());
			}
			
		});
		tableComboViewerMaterial.setInput(materials);
		tableComboViewerMaterial.addSelectionChangedListener(new ISelectionChangedListener() {
			
			@Override
			public void selectionChanged(SelectionChangedEvent event) {
				IStructuredSelection selection2 = tableComboViewerMaterial.getStructuredSelection();
				Object se2 = selection2.getFirstElement();
				if(se2!=null &&se2 instanceof Material ) {
					Material mat=(Material) se2;
					if(mat.isApplyTexture()&& mat.getImage()!=null && !mat.getImage().isEmpty()) {
						String imagePath = mat.getImage();
						if (ImageLoaderCache.isValidImagePath(imagePath)) {
							elementMaterialType.getTableComboViewerTexture().setSelection(new StructuredSelection(ModelProvider.getTexture(imagePath)), true);
						}
						
					}
				}
			}
		});
		btnList = new Button(this, SWT.CENTER);
		GridData gd_btnList = new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1);
		gd_btnList.widthHint = 30;
		gd_btnList.heightHint = 30;
		btnList.setLayoutData(gd_btnList);
		btnList.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				ListEditorWindow listWindow=new MaterialListWindow(getShell(), null);
				listWindow.create();
				listWindow.setSelect(true);
				int ret=listWindow.open();
				List<Material> materials=new ArrayList<Material>();
				materials.addAll(ResourceManagers.getIntance().getMaterials());
				materials.sort(new Comparator<Material>() {
					@Override
					public int compare(Material o1, Material o2) {
						
						return o1.getName().compareTo(o2.getName());
					}
					
				});
				tableComboViewerMaterial.setInput(materials);
				tableComboViewerMaterial.setInput(ResourceManagers.getIntance().getMaterials());
				tableComboViewerMaterial.refresh();
				if(ret==Window.OK) {
					tableComboViewerMaterial.setSelection(new StructuredSelection(listWindow.getSelection()), true);
				}
			}
		});
		btnList.setImage(ResourceManager.getPluginImage("Dressing", "icons/list24.png"));
		btnLibre = new Button(this, SWT.RADIO);
		btnLibre.setText("Libre");
		
		btnFacade = new Button(this, SWT.RADIO);
		btnFacade.setText("Façade");
		
		btnElement = new Button(this, SWT.RADIO);
		btnElement.setText("Élément");
		
		btnDos = new Button(this, SWT.RADIO);
		btnDos.setText("Dos");
		
		Label lblMaterialType = new Label(this, SWT.NONE);
		lblMaterialType.setText("Type Matériaux");
		
		elementMaterialType = new MaterialTypeInstanceComposite(this,SWT.NONE);
		elementMaterialType.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 6, 1));
		elementMaterialType.setSize(elementMaterialType.computeSize(SWT.DEFAULT, SWT.DEFAULT));
		setTabList(new Control[]{tableComboMaterial, btnLibre, btnFacade, btnElement, btnDos, elementMaterialType});
		if(this.element!=null) {
			m_bindingContext = initDataBindings();
		}

	}

	public Label getLblName() {
		return lblName;
	}
	public void setLblName(Label lblName) {
		this.lblName = lblName;
	}
	public MechanicDesignElment getElement() {
		return element;
	}

	public MaterialTypeInstanceComposite getElementMaterialType() {
		return elementMaterialType;
	}
	public void setElementMaterialType(MaterialTypeInstanceComposite elementMaterialType) {
		this.elementMaterialType = elementMaterialType;
	}
	public void setElement(MechanicDesignElment element) {
		if(this.element!=null) {
			this.element.removePropertyChangeListener(dirtyListener);
		}
		if(element!=null) {
			this.element = EcoreUtil.copy(element);
			this.origin=element;
			this.element.addPropertyChangeListener(dirtyListener);
			if (m_bindingContext != null) {
				m_bindingContext.dispose();
				m_bindingContext = null;
			}
			dirty=false;
			if (element != null) {
				m_bindingContext = initDataBindings();
			}
			this.elementMaterialType.setMaterial(this.element.getMaterialType());
		}
		dirty=false;
		
	}

	public MechanicDesignElment getOrigin() {
		return origin;
	}
	public void setOrigin(MechanicDesignElment origin) {
		this.origin = origin;
	}
	public boolean isDirty() {
		return dirty;
	}

	public void setDirty(boolean dirty) {
		this.dirty = dirty;
	}

	@Override
	protected void checkSubclass() {
		// Disable the check that prevents subclassing of SWT components
	}
	protected DataBindingContext initDataBindings() {
		DataBindingContext bindingContext = new DataBindingContext();
		//
		IObservableValue observeSingleSelectionTableComboViewer = ViewerProperties.singleSelection().observe(tableComboViewerMaterial);
		IObservableValue materialElementObserveValue = BeanProperties.value("material").observe(element);
		bindingContext.bindValue(observeSingleSelectionTableComboViewer, materialElementObserveValue, null, null);
		//
		IObservableValue observeEnabledTableComboObserveWidget = WidgetProperties.enabled().observe(tableComboMaterial);
		IObservableValue freeMaterialElementObserveValue = BeanProperties.value("freeMaterial").observe(element);
		bindingContext.bindValue(observeEnabledTableComboObserveWidget, freeMaterialElementObserveValue, null, null);
		//
		IObservableValue observeSelectionBtnLibreObserveWidget = WidgetProperties.widgetSelection().observe(btnLibre);
		bindingContext.bindValue(observeSelectionBtnLibreObserveWidget, freeMaterialElementObserveValue, null, null);
		//
		IObservableValue observeEnabledbtnListObserveWidget = WidgetProperties.enabled().observe(btnList);
		bindingContext.bindValue(observeEnabledbtnListObserveWidget, freeMaterialElementObserveValue, null, null);
		//
		IObservableValue observeSelectionBtnFacadeObserveWidget = WidgetProperties.widgetSelection().observe(btnFacade);
		IObservableValue faceMaterialElementObserveValue = BeanProperties.value("faceMaterial").observe(element);
		bindingContext.bindValue(observeSelectionBtnFacadeObserveWidget, faceMaterialElementObserveValue, null, null);
		//
		IObservableValue observeSelectionBtnElementObserveWidget = WidgetProperties.widgetSelection().observe(btnElement);
		IObservableValue primaryMaterialElementObserveValue = BeanProperties.value("primaryMaterial").observe(element);
		bindingContext.bindValue(observeSelectionBtnElementObserveWidget, primaryMaterialElementObserveValue, null, null);
		//
		IObservableValue observeSelectionBtnDosObserveWidget = WidgetProperties.widgetSelection().observe(btnDos);
		IObservableValue backMaterialElementObserveValue = BeanProperties.value("backMaterial").observe(element);
		bindingContext.bindValue(observeSelectionBtnDosObserveWidget, backMaterialElementObserveValue, null, null);
		//
		IObservableValue observeEnabledElementMaterialTypeObserveWidget = WidgetProperties.enabled().observe(elementMaterialType);
		bindingContext.bindValue(observeEnabledElementMaterialTypeObserveWidget, freeMaterialElementObserveValue, null, null);
		//
		return bindingContext;
	}
}
