package dressing.ui.exemples.tableaux;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;



public class Client {
private String nom;
private Integer age;



public Client(String nom, Integer age) {
	super();
	this.nom = nom;
	this.age = age;
}

public Client() {
	super();
	// TODO Auto-generated constructor stub
}

/**
 * @return the nom
 */
public String getNom() {
	return nom;
}

/**
 * @param nom the nom to set
 */
public void setNom(String nom) {
	
	String oldValue = this.nom;
	this.nom = nom;
	firePropertyChange("nom", oldValue, nom);
}

/**
 * @return the age
 */
public Integer getAge() {
	return age;
}

/* (non-Javadoc)
 * @see java.lang.Object#toString()
 */
@Override
public String toString() {
	return "Client [nom=" + nom + ", age=" + age + "]";
}

/**
 * @param age the age to set
 */
public void setAge(Integer age) {
	this.age = age;
	Integer oldValue = this.age;
	this.age = age;
	firePropertyChange("age", oldValue, age);
}

transient protected PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

public void addPropertyChangeListener(PropertyChangeListener listener) {
	propertyChangeSupport.addPropertyChangeListener(listener);
}

public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
	propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
}

public void removePropertyChangeListener(PropertyChangeListener listener) {
	propertyChangeSupport.removePropertyChangeListener(listener);
}

public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
	propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
}

protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
	propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
}
}
