/*
 * Decompiled with CFR 0.152.
 */
package org.frs.debitage.cam.graphunit;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import org.frs.debitage.cam.dxf.model.DXF_STATIC_VALUE;
import org.frs.debitage.cam.dxf.model.Rotationangle;
import org.frs.debitage.cam.graphunit.DimensionPrintType;
import org.frs.debitage.cam.graphunit.PGraph;
import org.frs.debitage.cam.graphunit.PLineDXFEntity;
import org.frs.debitage.cam.graphunit.PointDXF;
import org.frs.debitage.cam.graphunit.PolyLineDXFEntity;

public class PShape
extends PGraph
implements Serializable {
    private static final long serialVersionUID = 352L;
    public Rectangle2D.Double graph;
    public Color color;
    public Stroke stroke;
    public float Width;
    public float Height;
    public PointDXF Startpoint;
    String texte = " ";
    PointDXF temppoint;
    public int textsize = 70;
    public Font f = new Font("SansSerif", 1, this.textsize);
    AttributedString textattribute;
    Hashtable<TextAttribute, Object> map;
    private LineBreakMeasurer lineMeasurer;
    private int paragraphStart;
    private int paragraphEnd;
    boolean drawtext = false;
    String pieceindexname = "p1";
    String piecenomenc = " PC11 PVC: COTE TIROIR";
    private String widthstr;
    private String hightstr;
    private boolean drawstrdim = false;
    private String sensdefil = "NONE";
    private double width_user;
    private double high_user;
    private String width_user_str;
    private String high_user_str;
    private String muint;
    private boolean draw_with_dim_user_uof = false;

    public PShape() {
        this.Startpoint = new PointDXF(0, 0);
        this.graph = new Rectangle2D.Double(0.0, 0.0, 1.0, 1.0);
        this.stroke = new BasicStroke(1.0f);
        this.color = Color.BLACK;
        this.Width = 1.0f;
        this.Height = 1.0f;
        this.map = new Hashtable();
    }

    public PShape(PointDXF ipoint, float iWidth, float iHeight, Color c, int thik) {
        this.Startpoint = new PointDXF();
        this.Startpoint = ipoint;
        this.graph = new Rectangle2D.Double(ipoint.x, ipoint.y, iWidth, iHeight);
        this.stroke = new BasicStroke(thik);
        this.color = c;
        this.Width = iWidth;
        this.Height = iHeight;
        this.map = new Hashtable();
    }

    public PShape(PointDXF ipoint, float iWidth, float iHeight) {
        this.graph = new Rectangle2D.Double(ipoint.x, ipoint.y, iWidth, iHeight);
        this.color = Color.BLACK;
        this.Startpoint = new PointDXF();
        this.Startpoint = ipoint;
        this.Width = iWidth;
        this.Height = iHeight;
        this.stroke = new BasicStroke(2.0f);
        this.color = Color.black;
        this.map = new Hashtable();
    }

    public void SetColor(Color a) {
        this.color = a;
    }

    public void SetStartPoint(PointDXF istart) {
        this.graph.x = istart.x;
        this.graph.y = istart.y;
        this.Startpoint = istart;
    }

    public void SetShapeDim(int iWidth, int iHeight) {
        this.graph.height = iHeight;
        this.graph.width = iWidth;
        this.Height = (int)this.graph.height;
        this.Width = (int)this.graph.width;
    }

    public void Settroke(int istroke) {
        this.stroke = new BasicStroke(istroke);
    }

    public Font getF() {
        return this.f;
    }

    public void setF(Font f) {
        this.f = f;
    }

    public PointDXF getTemppoint() {
        return this.temppoint;
    }

    public void setTemppoint(PointDXF temppoint) {
        this.temppoint = temppoint;
    }

    public String getTexte() {
        return this.texte;
    }

    public void setTexte(String texte) {
        this.texte = texte;
    }

    public int getTextsize() {
        return this.textsize;
    }

    public void setTextsize(int textsize) {
        this.textsize = textsize;
    }

    public String getSensdefil() {
        return this.sensdefil;
    }

    public void setSensdefil(String sensdefil) {
        this.sensdefil = sensdefil;
    }

    @Override
    public void draw(Graphics g) {
        String PIECEDIM = "Horizontale/Verticale";
        this.type = this.getAffichagePieceDim(PIECEDIM);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(this.color);
        g2d.setStroke(this.stroke);
        g2d.draw(this.graph);
        if (this.drawtext) {
            if (this.type == DimensionPrintType.DOUBLE_COTE_NOMENC || this.type == DimensionPrintType.DOUBLE_COTE_ONLY || this.type == DimensionPrintType.DOUBLE_COTE_PIECE_INDEX) {
                this.drawDimensionString(this.pieceindexname, this.Width, this.Height, g);
            } else {
                this.drawtopleft(g);
            }
        }
    }

    public float drawparagraphdimpieces(Graphics g, AttributedString itextattribute, float offsety, boolean simulate) {
        Graphics2D g2d = (Graphics2D)g;
        float availablehigh = this.Height;
        if (this.lineMeasurer == null) {
            AttributedCharacterIterator paragraph = itextattribute.getIterator();
            this.paragraphStart = paragraph.getBeginIndex();
            this.paragraphEnd = paragraph.getEndIndex();
            FontRenderContext frc = g2d.getFontRenderContext();
            this.lineMeasurer = new LineBreakMeasurer(paragraph, frc);
        }
        float breakWidth = this.Width - 2.0f * this.Width / 9.0f;
        float drawPosY = this.Startpoint.y + offsety;
        availablehigh -= offsety;
        this.lineMeasurer.setPosition(this.paragraphStart);
        while (this.lineMeasurer.getPosition() < this.paragraphEnd) {
            TextLayout layout = this.lineMeasurer.nextLayout(breakWidth);
            float drawPosX = this.Width / 10.0f + this.Startpoint.x;
            drawPosY += layout.getAscent();
            availablehigh -= layout.getAscent();
            if (!simulate) {
                layout.draw(g2d, drawPosX, drawPosY);
            }
            drawPosY += layout.getDescent() + layout.getLeading();
            availablehigh -= layout.getDescent() + layout.getLeading();
        }
        return availablehigh;
    }

    public boolean isDrawtext() {
        return this.drawtext;
    }

    public void setDrawtext(boolean drawtext) {
        this.drawtext = drawtext;
    }

    public void drawDimensionString(String s, float w, float h, Graphics g) {
        String wstr;
        String hstr;
        if (this.drawstrdim) {
            hstr = this.hightstr;
            wstr = this.widthstr;
        } else if (this.draw_with_dim_user_uof && this.high_user_str != null && this.width_user_str != null) {
            hstr = this.high_user_str;
            wstr = this.width_user_str;
        } else {
            hstr = "" + h;
            wstr = "" + w;
        }
        Graphics2D g2d = (Graphics2D)g;
        this.temppoint = new PointDXF();
        this.temppoint.x = this.Startpoint.x;
        this.temppoint.y = this.Startpoint.y;
        g2d.setColor(Color.black);
        this.f = new Font("Courier New", 0, this.piecefontsize);
        g2d.setFont(this.f);
        FontMetrics fm = g2d.getFontMetrics();
        int w_high = fm.getHeight();
        int h_width = fm.stringWidth(hstr);
        int w_width = fm.stringWidth(wstr);
        int h_high = fm.getHeight();
        while (this.overlapcondtion(w_high, h_width, w_width, h_high, h, w)) {
            --this.piecefontsize;
            this.f = new Font("Courier New", 0, this.piecefontsize);
            g2d.setFont(this.f);
            fm = g2d.getFontMetrics();
            w_high = fm.getHeight();
            h_width = fm.stringWidth(hstr);
            w_width = fm.stringWidth(wstr);
            h_high = fm.getHeight();
        }
        String dim = wstr;
        g2d.drawString(dim, this.temppoint.x + w / 10.0f, this.temppoint.y + (float)fm.getAscent());
        dim = hstr;
        g2d.rotate(-1.5707963267948966, 0.0, 0.0);
        g2d.translate(-this.temppoint.y, this.temppoint.x);
        g2d.drawString(dim, -1.0f * h, w - (float)(fm.getAscent() / 4));
        g2d.translate(this.temppoint.y, -this.temppoint.x);
        g2d.rotate(1.5707963267948966, 0.0, 0.0);
        if (this.sensdefil.equalsIgnoreCase("UP")) {
            g2d.rotate(-1.5707963267948966, 0.0, 0.0);
            g2d.translate(-this.temppoint.y, this.temppoint.x);
            g2d.drawString(">>>", -1.0f * h / 2.0f, w / 2.0f);
            g2d.translate(this.temppoint.y, -this.temppoint.x);
            g2d.rotate(1.5707963267948966, 0.0, 0.0);
        } else if (this.sensdefil.equalsIgnoreCase("LEFT")) {
            g2d.drawString("<<<", this.temppoint.x + w / 2.0f, this.temppoint.y + h / 2.0f);
        }
    }

    public void drawCenteredString(String s, int w, int h, Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        this.temppoint = new PointDXF();
        this.temppoint.x = this.Startpoint.x;
        this.temppoint.y = this.Startpoint.y;
        FontMetrics fm = g2d.getFontMetrics();
        while (w - fm.stringWidth(s) < 0) {
            --this.textsize;
            this.f = new Font("SansSerif", 1, this.textsize);
            g2d.setFont(this.f);
            fm = g2d.getFontMetrics();
        }
        --this.textsize;
        --this.textsize;
        --this.textsize;
        this.f = new Font("SansSerif", 1, this.textsize);
        g2d.setFont(this.f);
        fm = g2d.getFontMetrics();
        float x = (float)((w - fm.stringWidth(s)) / 2) + this.temppoint.x;
        float y = (float)(fm.getAscent() + (h - (fm.getAscent() + fm.getDescent())) / 2) + this.temppoint.y;
        g2d.drawString(s, x, y);
    }

    private int calculerbestsizedimpieces(Graphics g, int textsize1, float Height1, float width, String s) {
        Graphics2D g2d = (Graphics2D)g;
        int lingecount = 0;
        Font font = new Font("Serif", 0, textsize1);
        g2d.setFont(font);
        FontMetrics fm = g2d.getFontMetrics();
        lingecount = (int)Math.floor((float)fm.stringWidth(s) / (width + 1.0f)) + 1;
        int lignesize = fm.getHeight();
        int ascent = fm.getAscent();
        int usedhigh = lingecount * lignesize;
        int timeoutcounter = 0;
        if ((float)usedhigh > Height1 - (float)ascent) {
            while ((float)usedhigh > Height1 - (float)ascent && timeoutcounter < 100) {
                font = new Font("Serif", 0, --textsize1);
                g2d.setFont(font);
                fm = g2d.getFontMetrics();
                lignesize = fm.getHeight();
                ascent = fm.getAscent();
                lingecount = (int)Math.floor((float)fm.stringWidth(s) / (width + 1.0f)) + 1;
                usedhigh = lingecount * lignesize;
                ++timeoutcounter;
            }
        }
        return textsize1;
    }

    private void drawtopleft(Graphics g) {
        String wstr;
        String hstr;
        this.temppoint = new PointDXF();
        this.temppoint.x = this.Startpoint.x;
        this.temppoint.y = this.Startpoint.y;
        if (this.drawstrdim) {
            hstr = this.hightstr;
            wstr = this.widthstr;
        } else if (this.draw_with_dim_user_uof && this.high_user_str != null && this.width_user_str != null) {
            hstr = this.high_user_str;
            wstr = this.width_user_str;
        } else {
            hstr = "" + this.Height;
            wstr = "" + this.Width;
        }
        String s = this.type == DimensionPrintType.TOP_LEFT_DIMESION_ONLY || this.type == DimensionPrintType.TOP_LEFT_DIMESION_NOMENC ? String.valueOf(wstr) + " x " + hstr : String.valueOf(wstr) + " x " + hstr + " " + this.pieceindexname;
        int itextsize = this.calculerbestsizedimpieces(g, this.textsize, 10.0f * this.Height / 10.0f, 8.0f * this.Width / 10.0f, s);
        this.map.put(TextAttribute.FAMILY, "Serif");
        this.map.put(TextAttribute.SIZE, new Float(itextsize));
        this.textattribute = new AttributedString(s, this.map);
        int availablehigh = (int)this.drawparagraphdimpieces(g, this.textattribute, 0.0f, true);
        while (availablehigh <= 0 && itextsize > 0) {
            this.map.put(TextAttribute.FAMILY, "Serif");
            this.map.put(TextAttribute.SIZE, new Float(--itextsize));
            this.textattribute = new AttributedString(s, this.map);
            this.lineMeasurer = null;
            availablehigh = (int)this.drawparagraphdimpieces(g, this.textattribute, 0.0f, true);
        }
        availablehigh = (int)this.drawparagraphdimpieces(g, this.textattribute, 0.0f, false);
        if ((this.type == DimensionPrintType.TOP_LEFT_DIMESION_NOMENC || this.type == DimensionPrintType.TOP_LEFT_DIMESION_PIECE_INDEX_NOMNEC) && availablehigh > 20) {
            s = this.piecenomenc;
            itextsize = this.calculerbestsizedimpieces(g, itextsize, availablehigh, 8.0f * this.Width / 10.0f, s);
            this.map.put(TextAttribute.FAMILY, "Serif");
            this.map.put(TextAttribute.SIZE, new Float(itextsize));
            this.textattribute = new AttributedString(s, this.map);
            this.lineMeasurer = null;
            int reamin = (int)this.drawparagraphdimpieces(g, this.textattribute, this.Height - (float)availablehigh, true);
            while (reamin <= 0 && itextsize > 0) {
                this.map.put(TextAttribute.FAMILY, "Serif");
                this.map.put(TextAttribute.SIZE, new Float(--itextsize));
                this.textattribute = new AttributedString(s, this.map);
                this.lineMeasurer = null;
                reamin = (int)this.drawparagraphdimpieces(g, this.textattribute, this.Height - (float)availablehigh, true);
            }
            this.map.put(TextAttribute.FAMILY, "Serif");
            this.map.put(TextAttribute.SIZE, new Float(itextsize));
            this.textattribute = new AttributedString(s, this.map);
            this.lineMeasurer = null;
            this.drawparagraphdimpieces(g, this.textattribute, this.Height - (float)availablehigh, false);
        }
        Graphics2D g2d = (Graphics2D)g;
        if (this.sensdefil.equalsIgnoreCase("UP")) {
            g2d.rotate(-1.5707963267948966, 0.0, 0.0);
            g2d.translate(-this.temppoint.y, this.temppoint.x);
            g2d.drawString(">>>", -1.0f * this.Height / 2.0f, this.Width / 2.0f);
            g2d.translate(this.temppoint.y, -this.temppoint.x);
            g2d.rotate(1.5707963267948966, 0.0, 0.0);
        } else if (this.sensdefil.equalsIgnoreCase("LEFT")) {
            g2d.drawString("<<<", this.temppoint.x + this.Width / 2.0f, this.temppoint.y + this.Height / 2.0f);
        }
    }

    private boolean overlapcondtion(float w_high, float h_width, float w_width, float h_high, float h, float w) {
        float widthreste_w = w - w_width;
        float withreste_h = h - h_width;
        if (w_high >= h || w_width >= w || h_width >= h || h_high >= w) {
            return true;
        }
        return widthreste_w < h_high && withreste_h < h_high;
    }

    public String getPiecenomenc() {
        return this.piecenomenc;
    }

    public void setPiecenomenc(String piecenomenc) {
        this.piecenomenc = piecenomenc;
    }

    public DimensionPrintType getAffichagePieceDim(String typeaffichage) {
        LinkedHashMap<String, DimensionPrintType> dimprint = new LinkedHashMap<String, DimensionPrintType>();
        dimprint.put("Gauche Haut", DimensionPrintType.TOP_LEFT_DIMESION_ONLY);
        dimprint.put("Gauche Haut avec nomenclature", DimensionPrintType.TOP_LEFT_DIMESION_NOMENC);
        dimprint.put("Gauche haut avec indice de piece", DimensionPrintType.TOP_LEFT_DIMESION_PIECE_INDEX);
        dimprint.put("Gauche haut avec indice de piece et nomenclature", DimensionPrintType.TOP_LEFT_DIMESION_PIECE_INDEX_NOMNEC);
        dimprint.put("Horizontale/Verticale", DimensionPrintType.DOUBLE_COTE_ONLY);
        dimprint.put("Horizontale/Verticale avec indice de piece", DimensionPrintType.DOUBLE_COTE_PIECE_INDEX);
        return (DimensionPrintType)((Object)dimprint.get(typeaffichage));
    }

    public void setPieceindexname(String pieceindexname) {
        this.pieceindexname = pieceindexname;
    }

    public String getWidthstr() {
        return this.widthstr;
    }

    public void setWidthstr(String widthstr) {
        this.widthstr = widthstr;
    }

    public String getHightstr() {
        return this.hightstr;
    }

    public void setHightstr(String hightstr) {
        this.hightstr = hightstr;
    }

    public boolean isDrawstrdim() {
        return this.drawstrdim;
    }

    public void setDrawstrdim(boolean drawstrdim) {
        this.drawstrdim = drawstrdim;
    }

    public boolean isDraw_with_dim_user_uof() {
        return this.draw_with_dim_user_uof;
    }

    public void setDraw_with_dim_user_uof(boolean draw_with_dim_user_uof) {
        this.draw_with_dim_user_uof = draw_with_dim_user_uof;
    }

    public double getWidth_user() {
        return this.width_user;
    }

    public void setWidth_user(double width_user) {
        this.width_user = width_user;
    }

    public double getHigh_user() {
        return this.high_user;
    }

    public void setHigh_user(double high_user) {
        this.high_user = high_user;
    }

    public String getMuint() {
        return this.muint;
    }

    public void setMuint(String muint) {
        this.muint = muint;
    }

    public String getWidth_user_str() {
        return this.width_user_str;
    }

    public void setWidth_user_str(String width_user_str) {
        this.width_user_str = width_user_str;
    }

    public String getHigh_user_str() {
        return this.high_user_str;
    }

    public void setHigh_user_str(String high_user_str) {
        this.high_user_str = high_user_str;
    }

    @Override
    public String getDXFLineEntetity() {
        String s = "";
        if (!this.isDrawDXFLine()) {
            return s;
        }
        PLineDXFEntity line1 = null;
        PLineDXFEntity line2 = null;
        PLineDXFEntity line3 = null;
        PLineDXFEntity line4 = null;
        PointDXF origin = new PointDXF(this.Startpoint.getLocation());
        PointDXF p1 = origin.getLocation();
        PointDXF p2 = p1.getLocation();
        p2.x = (float)((double)p2.x + ((double)this.Width + DXF_STATIC_VALUE.CHUTE_DISK));
        PointDXF p3 = p2.getLocation();
        p3.y = (float)((double)p3.y + ((double)this.Height + DXF_STATIC_VALUE.CHUTE_DISK));
        PointDXF p4 = p1.getLocation();
        p4.y = (float)((double)p4.y + ((double)this.Height + DXF_STATIC_VALUE.CHUTE_DISK));
        if (DXF_STATIC_VALUE.INVERT_CORDENATE) {
            this.InvertCodanate(p1);
            this.InvertCodanate(p2);
            this.InvertCodanate(p3);
            this.InvertCodanate(p4);
        } else if (DXF_STATIC_VALUE.INVERT_ANDSCLAE_Y_CORDENATE) {
            this.InvertYCodanate(p1);
            this.InvertYCodanate(p2);
            this.InvertYCodanate(p3);
            this.InvertYCodanate(p4);
            this.SCALEYCodanate(p1, DXF_STATIC_VALUE.Y_SCALE_VALUE);
            this.SCALEYCodanate(p2, DXF_STATIC_VALUE.Y_SCALE_VALUE);
            this.SCALEYCodanate(p3, DXF_STATIC_VALUE.Y_SCALE_VALUE);
            this.SCALEYCodanate(p4, DXF_STATIC_VALUE.Y_SCALE_VALUE);
        }
        if (!DXF_STATIC_VALUE.USE_POLYLINE) {
            line1 = new PLineDXFEntity(p1, p2);
            line2 = new PLineDXFEntity(p2, p3);
            line3 = new PLineDXFEntity(p1, p4);
            line4 = new PLineDXFEntity(p4, p3);
            s = String.valueOf(s) + line1.getDXFLineEntetity();
            s = String.valueOf(s) + line2.getDXFLineEntetity();
            s = String.valueOf(s) + line3.getDXFLineEntetity();
            s = String.valueOf(s) + line4.getDXFLineEntetity();
        } else {
            PolyLineDXFEntity poly = new PolyLineDXFEntity(true);
            poly.addVertices(p1);
            poly.addVertices(p2);
            poly.addVertices(p3);
            poly.addVertices(p4);
            poly.addVertices(p1);
            s = String.valueOf(s) + poly.getDXFEntity(Rotationangle.angleRotation0);
        }
        return s;
    }
}

