/*
 * Decompiled with CFR 0.152.
 */
package org.frs.cryptool.api.security.client;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.frs.cryptool.api.security.client.IAuthenticationService;
import org.frs.supercad.config.ConfigurationManager;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={EnterLicenseDialog.class})
public class EnterLicenseDialog {
    @Reference
    private IAuthenticationService authService;
    @Reference
    private ConfigurationManager configManager;
    private Shell shell;

    private void createControl() {
        this.shell = new Shell(Display.getDefault());
        this.shell.setText("entrez votre license!");
        this.shell.setSize(720, 480);
        this.shell.setLayout((Layout)new GridLayout(1, true));
        final Text txt = new Text((Composite)this.shell, 2626);
        final Text txtMsg = new Text((Composite)this.shell, 2052);
        final Button btnSubmit = new Button((Composite)this.shell, 0);
        txt.setLayoutData((Object)new GridData(4, 4, true, true));
        txt.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (txt.getText().length() > 20) {
                    boolean submitReady = false;
                    if (EnterLicenseDialog.this.check(txt.getText())) {
                        submitReady = true;
                        txtMsg.setForeground(new Color(10, 255, 10));
                        txtMsg.setText("License valide");
                    } else {
                        txtMsg.setForeground(new Color(255, 10, 10));
                        txtMsg.setText("License invalide!");
                    }
                    btnSubmit.setEnabled(submitReady);
                }
            }
        });
        txtMsg.setLayoutData((Object)new GridData(4, 4, true, false));
        btnSubmit.setText("Submit!");
        btnSubmit.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        btnSubmit.setEnabled(false);
        btnSubmit.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                EnterLicenseDialog.this.saveLicense(txt.getText());
                EnterLicenseDialog.this.shell.close();
            }
        });
    }

    protected boolean check(String license) {
        return this.authService.verifySignature(license);
    }

    protected void saveLicense(String text) {
        String path = this.configManager.getProperty("LICENSE_PATH");
        File file = new File(path);
        try {
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(text.getBytes());
            fos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void open() {
        Display.getDefault().syncExec(() -> {
            this.createControl();
            this.shell.open();
            while (!this.shell.isDisposed()) {
                this.shell.getDisplay().readAndDispatch();
            }
        });
    }
}

