/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.model;

import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.ui.IActionFilter;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ide.model.ResourceFactory;
import org.eclipse.ui.internal.ide.model.WorkbenchFile;
import org.eclipse.ui.internal.ide.model.WorkbenchFolder;
import org.eclipse.ui.internal.ide.model.WorkbenchMarker;
import org.eclipse.ui.internal.ide.model.WorkbenchProject;
import org.eclipse.ui.internal.ide.model.WorkbenchRootResource;
import org.eclipse.ui.internal.ide.model.WorkbenchWorkspace;
import org.eclipse.ui.internal.ide.model.WorkspaceFactory;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.model.IWorkbenchAdapter2;
import org.eclipse.ui.model.IWorkbenchAdapter3;

public class WorkbenchAdapterFactory
implements IAdapterFactory {
    private WorkbenchWorkspace workspaceAdapter = new WorkbenchWorkspace();
    private WorkbenchRootResource rootAdapter = new WorkbenchRootResource();
    private WorkbenchProject projectAdapter = new WorkbenchProject();
    private WorkbenchFolder folderAdapter = new WorkbenchFolder();
    private WorkbenchFile fileAdapter = new WorkbenchFile();
    private WorkbenchMarker markerAdapter = new WorkbenchMarker();
    private ResourceFactory resourceFactory = new ResourceFactory();
    private WorkspaceFactory workspaceFactory = new WorkspaceFactory();

    protected IActionFilter getActionFilter(Object o) {
        if (o instanceof IResource) {
            switch (((IResource)o).getType()) {
                case 1: {
                    return this.fileAdapter;
                }
                case 2: {
                    return this.folderAdapter;
                }
                case 4: {
                    return this.projectAdapter;
                }
            }
        }
        if (o instanceof IMarker) {
            return this.markerAdapter;
        }
        return null;
    }

    public <T> T getAdapter(Object o, Class<T> adapterType) {
        if (adapterType.isInstance(o)) {
            return adapterType.cast(o);
        }
        if (adapterType == IWorkbenchAdapter.class || adapterType == IWorkbenchAdapter2.class || adapterType == IWorkbenchAdapter3.class) {
            return adapterType.cast(this.getWorkbenchElement(o));
        }
        if (adapterType == IPersistableElement.class) {
            return adapterType.cast(this.getPersistableElement(o));
        }
        if (adapterType == IElementFactory.class) {
            return adapterType.cast(this.getElementFactory(o));
        }
        if (adapterType == IActionFilter.class) {
            return adapterType.cast(this.getActionFilter(o));
        }
        if (adapterType == IUndoContext.class) {
            return adapterType.cast(this.getUndoContext(o));
        }
        return null;
    }

    public Class<?>[] getAdapterList() {
        return new Class[]{IWorkbenchAdapter.class, IWorkbenchAdapter2.class, IWorkbenchAdapter3.class, IElementFactory.class, IPersistableElement.class, IActionFilter.class, IUndoContext.class};
    }

    protected IElementFactory getElementFactory(Object o) {
        if (o instanceof IResource) {
            return this.resourceFactory;
        }
        if (o instanceof IWorkspace) {
            return this.workspaceFactory;
        }
        return null;
    }

    protected IPersistableElement getPersistableElement(Object o) {
        if (o instanceof IResource) {
            return new ResourceFactory((IResource)o);
        }
        if (o instanceof IWorkspace) {
            return this.workspaceFactory;
        }
        return null;
    }

    protected IWorkbenchAdapter getWorkbenchElement(Object o) {
        if (o instanceof IResource) {
            switch (((IResource)o).getType()) {
                case 1: {
                    return this.fileAdapter;
                }
                case 2: {
                    return this.folderAdapter;
                }
                case 4: {
                    return this.projectAdapter;
                }
            }
        }
        if (o instanceof IWorkspaceRoot) {
            return this.rootAdapter;
        }
        if (o instanceof IWorkspace) {
            return this.workspaceAdapter;
        }
        if (o instanceof IMarker) {
            return this.markerAdapter;
        }
        return null;
    }

    protected IUndoContext getUndoContext(Object o) {
        if (o instanceof IWorkspace) {
            return PlatformUI.getWorkbench().getOperationSupport().getUndoContext();
        }
        return null;
    }
}

