package gdxapp.ui;

import java.util.ArrayList;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.utils.Align;
import com.badlogic.gdx.utils.Scaling;

public class ObjectMenuList extends ScrollPane {

	public static final String COPY = "Copier";
	public static final String PASTE = "Coller";
	public static final String CREATE_HABILLAGE = "Ajouter Habillage";
	public static final String DELETE = "Supprimer";
	public static final String FINITION = "Finition Portes";
	public static final String EDIT = "Modifier";
	public static final String FIT_SPACE = "Adapté à l'espace";
	public static final String[] WALL2D_MENU = { EDIT, DELETE };
	public static final String[] SCENE_OBJECT_MENU = { FINITION, COPY, DELETE };

	private final float width = 250;
	private final float maxHeight = 300;

	private Object subject;
	private final Table contentTable;

	public ObjectMenuList(Object subject, Skin skin, String styleName, ArrayList<ActionItem> extraActions) {
		super(null, skin);
		this.subject = subject;

		contentTable = new Table();
		contentTable.setBackground(skin.newDrawable("white", Color.WHITE));
		contentTable.pad(0);
		contentTable.defaults().fillX().pad(0);
        contentTable.top().left();


		for (ActionItem action : extraActions) {
			Button button = createActionButton(skin, styleName, action);
			contentTable.add(button).width(width - 12).padBottom(2).row();
		}

		contentTable.pack();
		this.setActor(contentTable);

		this.setFadeScrollBars(false);
		this.setScrollingDisabled(true, false);
		this.setScrollbarsOnTop(true);
		this.setOverscroll(false, false);

		float height = Math.min(contentTable.getHeight(), maxHeight);
		this.setSize(width, height);
	}

	private Button createActionButton(Skin skin, String styleName, ActionItem action) {
		Image iconImage = null;
		if (action.getIcon() != null) {
			iconImage = new Image(action.getIcon());
			iconImage.setScaling(Scaling.fit);
			iconImage.setSize(24, 24);
		}
		Label titleLabel = new Label(action.getTitle(), skin);
		titleLabel.setAlignment(Align.left);
		titleLabel.setEllipsis(true);

		Label shortcutLabel = new Label(action.getShortcut(), skin);
		shortcutLabel.setAlignment(Align.right);

		Table rowTable = new Table();
		rowTable.defaults().padLeft(5).padRight(5);

		if (iconImage != null) {
			rowTable.add(iconImage).size(24, 24).padRight(2);
		} else {
			rowTable.add().width(24 + 2);
		}
		rowTable.add(titleLabel).expandX().left();
		rowTable.add(shortcutLabel).width(40).right();

		if (iconImage != null) {
			rowTable.add(iconImage).size(24, 24).padLeft(5);
		}

		Button button = new Button(skin, styleName);
		if (!action.isEnabled()) {
			button.setDisabled(true);
			button.setColor(1, 1, 1, 0.5f);
		}

		button.add(rowTable).expand().fill();

		if (action.isEnabled()) {
			button.addListener(new ClickListener() {
				@Override
				public void clicked(InputEvent event, float x, float y) {
					action.execute();
					ObjectMenuList.this.remove();
				}
			});
		}
		return button;
	}

	
	
	
	
	
	
	
	
	
	
	
	
	
    
    

    
	
//	void setContent() {
//		if( subject instanceof Wall2D) {
//			createContentForWall2D();
//		}else if(subject instanceof Object2D) {
//			createContentForSceneObject();
//		}else  if(subject.equals("top view")) {
//			createContentForTopView();
//		}
//	}
//	
//	private void createContentForWall2D() {
//		setItems(WALL2D_MENU);
//		addListener(new ChangeListener() {	
//			@Override
//			public void changed(ChangeEvent event, Actor actor) {
//				Object selection = getSelected();
//				if(selection != null) {	
//					if(selection.equals(DELETE)) {
//					Wall2D target = (Wall2D) subject;
//					RemoveObjectCommand rmoCmd = new RemoveObjectCommand("delete command", "", target);
//					ChangeCommandController.getInstance().addCommand(rmoCmd);
//					}else{
//						Display.getDefault().asyncExec(new Runnable() {
//							
//							@Override
//							public void run() {
//								Wall wall = ((Wall2D)subject).getWorldObject();
//								Shell shell = new Shell(Display.getDefault());
//								WallSettingWindow window = new WallSettingWindow(shell, wall);
//								window.open();								
//							}
//						});
//						
//					}
//					remove();
//				}
//			}
//		});
//	}
//
//	private void createContentForTopView() {
//		
//		ArrayList<String> actions = new ArrayList<>();
//		if(SuperCadClipBoard.hasItems())
//			actions.add(PASTE);
//		actions.add(CREATE_HABILLAGE);
//		setItems((String[]) actions.toArray(new String[0]));
//		setSelectedIndex(-1);
//		addListener(new ChangeListener() {	
//			@Override
//			public void changed(ChangeEvent event, Actor actor) {
//				Object selection = getSelected();
//				if(selection != null) {	
//					if(selection.equals(PASTE)) {
//						WorldObject element = (WorldObject)SuperCadClipBoard.getContent().get(0).copy();						
//						HashMap<String, Object> eventData = new HashMap<>();
//						Vector3 position = RoomController.getInstance().toRealWorldCoordinate(new Vector3(getX(), getY() + getHeight(),element.getRealWorldPosition().y));
//						eventData.put("position", position);
//						eventData.put("element", element);
//						try {
//							ProjectManager.getManager().getCurrentKitchen().addElement(((KitchenElement) element).getDesignObject());
//						} catch (DesignException e) {
//							// TODO Auto-generated catch block
//							e.printStackTrace();
//						}
//						Event pastevent = new Event(SceneEvent.COPY.name(), eventData);
//						EventDriver.getDriver().deliverEvent(pastevent);
//					}else if(selection.equals(CREATE_HABILLAGE)) {
//						Display.getDefault().asyncExec(new Runnable() {
//							
//							@Override
//							public void run() {
//								Shell shell = new Shell(Display.getCurrent(), SWT.DIALOG_TRIM);
//								HabillageCreator window = new HabillageCreator(shell);
//								window.open();								
//							}
//						});
//						
//					}
//					remove();
//				}
//			}
//		});
//	}
//
//	private void createContentForSceneObject(){
//		
//		setItems(SCENE_OBJECT_MENU);
//		if(!SuperCadClipBoard.getContent().isEmpty()) {
//			getItems().add(PASTE);
//		}
//		if(subject instanceof Object2D 
//				&& ((Object2D) subject).getWorldObject()!=null  
//				&& !(((Object2D) subject).getWorldObject() instanceof KitchenElement)) {
//			getItems().removeValue(COPY, false);
//		}
//		addListener(new ChangeListener() {	
//			@Override
//			public void changed(ChangeEvent event, Actor actor) {
//				Object selection = getSelected();
//				Object2D target = (Object2D) subject;
//				if(selection != null) {	
//					if(selection.equals(DELETE)) {
//						RemoveObjectCommand rmoCmd = new RemoveObjectCommand("delete command", "", target);
//						ChangeCommandController.getInstance().addCommand(rmoCmd);
//					}else if(selection.equals(COPY) 
//							&& target!=null 
//							&& target.getWorldObject()!=null 
//							&& target.getWorldObject() instanceof KitchenElement) {
//						
//						KitchenElement element = target.getWorldObject();
//						SuperCadClipBoard.setContent(element);
//					}else if(selection.equals(PASTE)) {
//						WorldObject element = (WorldObject)SuperCadClipBoard.getContent().get(0).copy();						
//						HashMap<String, Object> eventData = new HashMap<>();
//						Vector3 position = RoomController.getInstance().toRealWorldCoordinate(new Vector3(getX(), getY() + getHeight(),element.getRealWorldPosition().y));
//						eventData.put("position", position);
//						eventData.put("element", element);
//						Event pastevent = new Event(SceneEvent.COPY.name(), eventData);
//						EventDriver.getDriver().deliverEvent(pastevent);
//					}else if(selection.equals(EDIT)) {
//						EventDriver.getDriver().deliverEvent(new Event(SceneEvent.EDIT_OBJECT.name(), subject));
//					}
//					remove();
//				}
//			}
//		});
//	}

}
