package dressing.ui;

import java.util.List;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import dressing.config.persistence.ResourceManagers;
import dressing.ui.util.DoubleViewerComparator;
import dressing.ui.util.EditorWindow;
import dressing.ui.util.ListEditorWindow;
import dressing.ui.util.StringViewerComparator;
import param.Chant;
import param.ParamFactory;

public class ChantListWindow extends ListEditorWindow {

	public ChantListWindow(Shell parentShell, IEventBroker eventBroker) {
		super(parentShell);
	}

	@Override
	protected Composite createClientArea(Composite parent,int style) {
		Composite clientArea = super.createClientArea(parent, style|SWT.MULTI);
		getShell().setText("Liste des chants");
		return clientArea;
	}
	
	public void createColums(TableViewer tableViewer) {
		ColumnLabelProvider nameLabelProvider=new ColumnLabelProvider() {
			public String getText(Object element) {
				if(element !=null && element instanceof Chant ) {
					return ((Chant)element).getName();
				}
				return "";
			}
		};
		createColumn(tableViewer, "Nom", true, null, SWT.LEFT, nameLabelProvider, new StringViewerComparator(nameLabelProvider));

		ColumnLabelProvider eppaisseurColumnLabelProvider=new ColumnLabelProvider() {
			public String getText(Object element) {
				if(element !=null && element instanceof Chant ) {
					return String.valueOf(((Chant)element).getEpaisseur());
				}
				return "";
			}
		};
		createColumn(tableViewer, "Epaisseur", true, null, SWT.CENTER, eppaisseurColumnLabelProvider, new DoubleViewerComparator(eppaisseurColumnLabelProvider));
		
		//
		ColumnLabelProvider priceColumnLabelProvider = new ColumnLabelProvider() {
			public String getText(Object element) {
				if(element !=null && element instanceof Chant ) {
					return String.valueOf(((Chant)element).getPrice());
				}
				return "";
			}
		};
		createColumn(tableViewer, "Prix (DT/m² )", true, null, SWT.CENTER, priceColumnLabelProvider, new DoubleViewerComparator(priceColumnLabelProvider));
	}
	@Override
	protected void Add() {
		Chant chant=ParamFactory.eINSTANCE.createChant();
		chant.setName("");
		chant.setEpaisseur(0);
		ChantEditorWindow mechanicDesignWindow = new ChantEditorWindow(shell,chant,EditorWindow.create);
		mechanicDesignWindow.create();
		int ret=mechanicDesignWindow.open();
		if(ret==Window.OK) {
			tableViewer.refresh();
		}
	}

	@Override
	protected void Modify() {
		IStructuredSelection selection=tableViewer.getStructuredSelection();
		if(selection!=null  && selection.getFirstElement()!=null && selection.getFirstElement() instanceof Chant) {
			ChantEditorWindow mechanicDesignWindow = new ChantEditorWindow(shell,(Chant) selection.getFirstElement(),EditorWindow.update);
			mechanicDesignWindow.create();
			int ret=mechanicDesignWindow.open();
			if(ret==Window.OK) {
				tableViewer.refresh();
			}
		}
	}

	@Override
	protected void delete() {
		boolean ret = MessageDialog.openConfirm(shell, "Confirmation de supression","Voulez vous supprimer les composant sélectionner" );
		if(ret) {
			IStructuredSelection selection=tableViewer.getStructuredSelection();
			if(selection!=null&& !selection.isEmpty()) {
				List selections=selection.toList();
				for(Object obj:selections) {
					if(obj!=null && obj instanceof Chant) {
						ResourceManagers.getIntance().getChants().getChant().remove(obj);
						ResourceManagers.getIntance().saveChants();
					}
				}
				tableViewer.refresh();
			}
		}
		

	}

	@Override
	protected void view() {
		IStructuredSelection selection=tableViewer.getStructuredSelection();
		if(selection!=null  && selection.getFirstElement()!=null && selection.getFirstElement() instanceof Chant) {
			ChantEditorWindow mechanicDesignWindow = new ChantEditorWindow(shell,(Chant) selection.getFirstElement(),EditorWindow.View);
			mechanicDesignWindow.create();
			mechanicDesignWindow.open();
			
		}

	}

	@Override
	public List<?> getInput() {
		return ResourceManagers.getIntance().getChants().getChant();
	}

	@Override
	protected ViewerFilter createListFilter() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	protected Composite createSearchArea(Composite parent, int style) {
		// TODO Auto-generated method stub
		return null;
	}

}
