 
package dressing.handlers.cam;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;

import dressing.model.ProjectManager;
import dressing.model.Space3DFree;
import dressing.model.stock.Article;
import dressing.ui.stock.AccessoiresListEditor;
import gdxapp.Commun.GroupSelection;
import gdxapp.object3d.KitchenElement;
import gdxapp.object3d.Object2D;
import gdxapp.object3d.WorldObject;
import gdxapp.object3d.WorldObject.ObjectType;

public class AccessoireList {
	@Execute
	public void execute() {
		try {
			AccessoiresListEditor window = new AccessoiresListEditor();
			boolean found=false;

			ArrayList<Object> selection =GroupSelection.getInstance().getSelection();
			List<Article> articles=new ArrayList<Article>();

			if(selection!=null && selection.size()>0) {
				Object object=selection.get(0);
				if(object instanceof Object2D) {
					WorldObject wobject=((Object2D) object).getWorldObject();
					if(wobject!=null && wobject.getType().equals(ObjectType.DEFINED)) {
						KitchenElement element = (KitchenElement) wobject;
						if(element.getDesignObject()!=null&& element.getDesignObject() instanceof Space3DFree) {
							Space3DFree space=(Space3DFree) element.getDesignObject();
							articles.addAll(space.getAccessoires());
							articles.addAll(space.getQuincailleries());
							found=true;
						}
					}
				}
			}
			if(!found) {
				articles.addAll(ProjectManager.getManager().getCurrentKitchen().getAccessoires());
				articles.addAll(ProjectManager.getManager().getCurrentKitchen().getQuincailleries());
			}
			window.setArticles(articles);
			window.open();

		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	@CanExecute
	public boolean canExecute() {
		
		return true;
	}	
}