package supercad.runtime;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;



public class AnnotationScanner {

	public static ArrayList<Class> findClassesWithAnnotations(Class<? extends Annotation> annotation, String... pckgs) {
		ReflectionUtils.loadSrcPathClasses();
		ArrayList<Class> classes = ReflectionUtils.getDeclaredClasses();
		ArrayList<Class> searchResult = new ArrayList<Class>();
		for (Class clazz : classes) {
			if (clazz.isAnnotationPresent(annotation))
				searchResult.add(clazz);
		}
		return searchResult;
	}



	public static boolean containsAnnotatedField(Class<? extends Annotation> annotation, Class clazz) {
		ArrayList<Field> fields = new ArrayList<Field>();
		ReflectionUtils.getAllFields(clazz, fields);
		for (Field field : fields) {
			if (field.isAnnotationPresent(annotation))
				return true;
		}
		return false;
	}

	public static ArrayList<Field> findAnnotatedFields(Class<? extends Annotation> annotation, Class clazz) {
		ArrayList<Field> fields = new ArrayList<Field>();
		ArrayList<Field> searchResult = new ArrayList<Field>();
		ReflectionUtils.getAllFields(clazz, fields);
		for (Field field : fields) {
			if (field.isAnnotationPresent(annotation))
				searchResult.add(field);
		}
		return searchResult;
	}

}
