package dressing.config;

import java.io.File;

import org.frs.resources.downloder.DownloaderUI;
import org.frs.supercad.config.ConfigurationManager;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

import dressing.config.persistence.ResourceManagers;
import dressing.model.ProjectManager;

import javax.swing.*;

public class Activator implements BundleActivator {

	private ConfigurationManager configManager;
	private BundleContext context;
	private String requiredResource;

	@Override
	public void start(BundleContext context) throws Exception {
		this.context = context;
		//check if ware in dev or prod envirement
		if (System.getProperty("osgi.dev") == null) {
			UnifiedLogger.init();
		}
		
		acquireOsgiServices();

		loadRequiredResourceFromConfig();
		if (!checkResource()) {
			DownloaderUI downloaderUI = new DownloaderUI();
			downloaderUI.open();
			while (!checkResource() || !downloaderUI.isDownloadCompleted()) {
				Thread.sleep(1000);
			}
			SwingUtilities.invokeLater(() -> downloaderUI.dispose());
		}
		ResourceManagers.getIntance();
		ProjectManager.getInstance();
		UserPreference.getPreference().load();

	}

	private void acquireOsgiServices() {
		ServiceReference<ConfigurationManager> configMamangerRef = this.context.
				getServiceReference(ConfigurationManager.class);
		if(configMamangerRef != null)
			this.configManager = this.context.getService(configMamangerRef);
				
	}

	@Override
	public void stop(BundleContext context) throws Exception {
	}

	private void loadRequiredResourceFromConfig() {
		String dataPath = configManager.getProperty("DATA_PATH");
		String dataVersion = configManager.getProperty("DATA_VERSION");

		if (dataPath != null) {
			if (dataVersion == null || dataVersion.isEmpty()) {
				requiredResource = dataPath;
			} else {
				requiredResource = dataPath + File.separator + dataVersion;
			}

		} else {
			JOptionPane.showMessageDialog(null,
					"Les chemins de ressources ne sont pas définis dans le fichier de configuration.", "Attention",
					JOptionPane.WARNING_MESSAGE);
		}
	}

	private boolean checkResource() {
		if (requiredResource == null)
			return false;
		File resFile = new File(requiredResource);
		return resFile.exists();
	}
}
