package api.ui;

import java.io.File;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.wb.swt.SWTResourceManager;

import api.events.CustomEvent;
import api.events.EventBus;
import api.events.EventType;
import api.provider.ModelProvider;
import api.utils.RessourceLoader;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;

public class RightMenuToolBarManager {
	
	private Composite parent;
	private ToolBar toolBar;
	
	public RightMenuToolBarManager(Composite parent) {
		this.parent = parent;
		createControl();
	}

	private void createControl() {
		toolBar = new ToolBar(parent, SWT.FLAT | SWT.RIGHT);
		toolBar.setBackground(SWTResourceManager.getColor(SWT.COLOR_GRAY));
		toolBar.setLayoutData(new GridData(SWT.CENTER, SWT.CENTER, true, false));
		
		//electric menu item
		ToolItem selectionItem = new ToolItem(toolBar, SWT.RADIO);
		selectionItem.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				EventBus.getInstance().notify( new CustomEvent(EventType.SELECTION_MENU_TRIGGERED, null));
			}
		});
		String imagePath = ModelProvider.root + File.separator +  "icons/icons8-3d-object-32.png";
		Image electricImg = new Image(Display.getDefault(), imagePath);
		selectionItem.setImage(electricImg);
		selectionItem.setSelection(true);
		
		//selcetion item
		ToolItem libraryItem = new ToolItem(toolBar, SWT.RADIO);
		libraryItem.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				EventBus.getInstance().notify(new CustomEvent(EventType.OBJECT_SELECTION_TRIGFERED, null) );
			}
		});
		imagePath = ModelProvider.root + File.separator + "icons/icons8-products-32.png";
		Image selectionImg = new Image(Display.getDefault(), imagePath);
		libraryItem.setImage(selectionImg);
		//plumbing menu item
		ToolItem plumbingItem = new ToolItem(toolBar, SWT.RADIO);
		plumbingItem.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				EventBus.getInstance().notify(new CustomEvent(EventType.PLUMBING_EDITING_TRIGGERED, null));
				
			}
		});
		imagePath = ModelProvider.root + File.separator + "icons/icons8-plumbing-32.png";
		Image plumbingImg = new Image(Display.getDefault(), imagePath);
		plumbingItem.setImage(plumbingImg);
		
	}

}
