package gdxapp.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

import org.apache.commons.collections.map.HashedMap;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.List;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;

import dressing.events.Event;
import dressing.events.EventDriver;
import dressing.model.Copyable;
import dressing.model.DesignException;
import dressing.model.ProjectManager;
import dressing.model.SuperCadClipBoard;
import dressing.ui.ChangeCommandController;
import dressing.ui.RemoveObjectCommand;
import dressing.ui.parts.GdxPart;
import dressing.ui.usinage.HabillageCreator;
import dressing.ui.util.WallSettingWindow;
import gdxapp.object3d.GeometryObject2D;
import gdxapp.object3d.KitchenElement;
import gdxapp.object3d.Object2D;
import gdxapp.object3d.Wall;
import gdxapp.object3d.WorldObject;
import gdxapp.scenes.SceneEvent;
import gdxapp.screens.room.RoomController;
import gdxapp.screens.wall.Wall2D;
import param.MechanicDesign;

import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener.ChangeEvent;

public class ObjectMenuList extends List<String>{
	
	Object subject;
	
	public static final String COPY = "Copier";
	public static final String PASTE = "Coller";
	public static final String CREATE_HABILLAGE = "Creer Habillage";
	public static final String DELETE = "Supprimer";
	public static final String EDIT = "Editer";

	public static final String[] WALL2D_MENU = {EDIT,DELETE};
	public static final String[] SCENE_OBJECT_MENU = {EDIT,COPY,DELETE};

	
	public ObjectMenuList(Object object, Skin skin, String styleName) {
		super(skin, styleName);
		this.subject = object;
		setContent();
		setSize(200, getItems().size * 40);
	}
	
	void setContent() {
		if( subject instanceof Wall2D) {
			createContentForWall2D();
		}else if(subject instanceof Object2D) {
			createContentForSceneObject();
		}else  if(subject.equals("top view")) {
			createContentForTopView();
		}
	}
	
	private void createContentForWall2D() {
		setItems(WALL2D_MENU);
		addListener(new ChangeListener() {	
			@Override
			public void changed(ChangeEvent event, Actor actor) {
				Object selection = getSelected();
				if(selection != null) {	
					if(selection.equals(DELETE)) {
					Wall2D target = (Wall2D) subject;
					RemoveObjectCommand rmoCmd = new RemoveObjectCommand("delete command", "", target);
					ChangeCommandController.getInstance().addCommand(rmoCmd);
					}else{
						Display.getDefault().asyncExec(new Runnable() {
							
							@Override
							public void run() {
								Wall wall = ((Wall2D)subject).getWorldObject();
								Shell shell = new Shell(Display.getDefault());
								WallSettingWindow window = new WallSettingWindow(shell, wall);
								window.open();								
							}
						});
						
					}
					remove();
				}
			}
		});
	}

	private void createContentForTopView() {
		
		ArrayList<String> actions = new ArrayList<>();
		if(SuperCadClipBoard.hasItems())
			actions.add(PASTE);
		actions.add(CREATE_HABILLAGE);
		setItems((String[]) actions.toArray(new String[0]));
		setSelectedIndex(-1);
		addListener(new ChangeListener() {	
			@Override
			public void changed(ChangeEvent event, Actor actor) {
				Object selection = getSelected();
				if(selection != null) {	
					if(selection.equals(PASTE)) {
						WorldObject element = (WorldObject)SuperCadClipBoard.getContent().get(0).copy();						
						HashMap<String, Object> eventData = new HashMap<>();
						Vector3 position = RoomController.getInstance().toRealWorldCoordinate(new Vector3(getX(), getY() + getHeight(),element.getRealWorldPosition().y));
						eventData.put("position", position);
						eventData.put("element", element);
						try {
							ProjectManager.getManager().getCurrentKitchen().addElement(((KitchenElement) element).getDesignObject());
						} catch (DesignException e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						}
						Event pastevent = new Event(SceneEvent.COPY.name(), eventData);
						EventDriver.getDriver().deliverEvent(pastevent);
					}else if(selection.equals(CREATE_HABILLAGE)) {
						Display.getDefault().asyncExec(new Runnable() {
							
							@Override
							public void run() {
								Shell shell = new Shell(Display.getCurrent(), SWT.DIALOG_TRIM);
								HabillageCreator window = new HabillageCreator(shell);
								window.open();								
							}
						});
						
					}
					remove();
				}
			}
		});
	}

	private void createContentForSceneObject(){
		
		setItems(SCENE_OBJECT_MENU);
		if(!SuperCadClipBoard.getContent().isEmpty()) {
			getItems().add(PASTE);
		}
		if(subject instanceof Object2D 
				&& ((Object2D) subject).getWorldObject()!=null  
				&& !(((Object2D) subject).getWorldObject() instanceof KitchenElement)) {
			getItems().removeValue(COPY, false);
		}
		addListener(new ChangeListener() {	
			@Override
			public void changed(ChangeEvent event, Actor actor) {
				Object selection = getSelected();
				Object2D target = (Object2D) subject;
				if(selection != null) {	
					if(selection.equals(DELETE)) {
						RemoveObjectCommand rmoCmd = new RemoveObjectCommand("delete command", "", target);
						ChangeCommandController.getInstance().addCommand(rmoCmd);
					}else if(selection.equals(COPY) 
							&& target!=null 
							&& target.getWorldObject()!=null 
							&& target.getWorldObject() instanceof KitchenElement) {
						
						KitchenElement element = target.getWorldObject();
						SuperCadClipBoard.setContent(element);
					}else if(selection.equals(PASTE)) {
						WorldObject element = (WorldObject)SuperCadClipBoard.getContent().get(0).copy();						
						HashMap<String, Object> eventData = new HashMap<>();
						Vector3 position = RoomController.getInstance().toRealWorldCoordinate(new Vector3(getX(), getY() + getHeight(),element.getRealWorldPosition().y));
						eventData.put("position", position);
						eventData.put("element", element);
						Event pastevent = new Event(SceneEvent.COPY.name(), eventData);
						EventDriver.getDriver().deliverEvent(pastevent);
					}else if(selection.equals(EDIT)) {
						EventDriver.getDriver().deliverEvent(new Event(SceneEvent.EDIT_OBJECT.name(), subject));
					}
					remove();
				}
			}
		});
	}

}
