package dressing.controller;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Predicate;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.jogamp.vecmath.Point3d;

import dressing.model.Delimeter;
import dressing.model.DesignObject3D;
import dressing.model.Intervale;
import dressing.model.MechanicDesignCreator;
import dressing.model.Plan3D;
import dressing.model.Space3D;
import param.Axe;
import param.AxisDelimitersEntry;
import param.ChainOfResponsabilityController;
import param.DelimiterConstraintsEntry;
import param.DelimiterCreatorsEntry;
import param.Direction;
import param.DirectionDelimiterEntry;
import param.DirectionDelimiterMap;
import param.MechanicDesign;
import param.MechanicPublicParam;
import param.ParamFactory;
import param.PieceType;
import param.impl.ChainOfResponsabilityControllerImpl;
import param.impl.DelimeterImpl;

/**
 * 
 * @author Imed
 *
 */
public class DependenceResponsibilityCenter {
	public static Space3D intermidiateSpace;
	public static final int BOX_FACE_NUMBER=6;
	private DesignObject3D root;
	private ConcurrentLinkedQueue<MechanicDesign> updatePool=new ConcurrentLinkedQueue<MechanicDesign>();
    private transient Map<MechanicDesign,DesignObject3D > intsatanceToDefinition=new HashMap<MechanicDesign, DesignObject3D>();
    private transient Map<DelimeterImpl, Delimeter> delimiterIntsatanceToDefinition=new HashMap<DelimeterImpl, Delimeter>();

    ChainOfResponsabilityController chainModel;
	/**
	 * 
	 * @param root
	 */
	public DependenceResponsibilityCenter(DesignObject3D root) {
		super();
		this.setRoot(root);
	}
	public DesignObject3D getRoot() {
		return root;
	}
	public void setRoot(DesignObject3D root) {
		this.root = root;
		if(root!=null && root instanceof Space3D && root.getMechanicDesignDefinition()!=null&&root.getMechanicDesignDefinition().getChainOfResponsabilityController()!=null) {
			this.chainModel=root.getMechanicDesignDefinition().getChainOfResponsabilityController();
		}
	}
	
	public ConcurrentLinkedQueue<MechanicDesign> getUpdatePool() {
		return updatePool;
	}
	public void setUpdatePool(ConcurrentLinkedQueue<MechanicDesign> updatePool) {
		this.updatePool = updatePool;
	}
	
	public Map<MechanicDesign, DesignObject3D> getIntsatanceToDefinition() {
		if(this.intsatanceToDefinition==null) {
			this.intsatanceToDefinition=new HashMap<MechanicDesign, DesignObject3D>();
		}
		return intsatanceToDefinition;
	}
	public void setIntsatanceToDefinition(Map<MechanicDesign, DesignObject3D> intsatanceToDefinition) {
		this.intsatanceToDefinition = intsatanceToDefinition;
	}
	public void addDelimeter(Delimeter delimeter) {
		
		if(getChainModel().getAxisDelimiters().containsKey(delimeter.getDelimeter().getAxis())) {
			List<param.Delimeter> delimeters =getChainModel().getAxisDelimiters().get(delimeter.getDelimeter().getAxis());
			if(!delimeters.contains(delimeter.getDelimeter()))
			{
				delimeters.add(delimeter.getDelimeter());
			}
		}else {
			AxisDelimitersEntry entry=ParamFactory.eINSTANCE.createAxisDelimitersEntry();
			entry.getDelimiters().add(delimeter.getDelimeter());
			entry.setAxis(delimeter.getDelimeter().getAxis());
			getChainModel().getAxisDelimiters().getEntries().add(entry);
		}
		getDelimiterIntsatanceToDefinition().put(delimeter.getDelimeter(), delimeter);
	}
	public void updatePoolObjects() throws Exception {
		if(updatePool.size()>0) {
			for(int i=0;i<updatePool.size();i++) {
				MechanicDesign headUpdate=	updatePool.poll();
				
				if(headUpdate!=null && getChainModel().getDelimiterCreators().containsKey(headUpdate)) {
					DesignObject3D design=getIntsatanceToDefinition().get(headUpdate);
					if(design!=null) {
//						System.err.println("updating design "+ design.getName()+" with id \t"+headUpdate.getId());
						design.update(false);	
					}
					
				}
			}
		}
	}
	/**
	 * 
	 * @param src 
	 * @param delimeters
	 * @param isPropagate
	 * @throws Exception
	 */
	public void registerOrUpdateTargetReference(DesignObject3D src, List<Delimeter> delimeters,boolean isPropagate) throws Exception {
		MechanicDesign target=src.getMechanicDesignDefinition();
//		System.err.println("register design "+ target.getName()+" with id \t"+target.getId()+"\n"+delimeters);

		getIntsatanceToDefinition().put(target,src);
		boolean iscreate=true;
		//check Update or create		
		if(getChainModel().getDelimiterCreators().containsKey(target) && isPropagate) {
			//update
			List<MechanicDesign> dependents=new ArrayList<MechanicDesign>();
			List<param.Delimeter> oldDelimeters=getChainModel().getDelimiterCreators().get(target);
			if(oldDelimeters!=null && !oldDelimeters.isEmpty()) {
				for(param.Delimeter del:oldDelimeters) {
					if (getChainModel().getDelimiterContraints().containsKey(del)) {
						List<MechanicDesign> delDependents=getChainModel().getDelimiterContraints().get(del);
						if(delDependents!=null && !delDependents.isEmpty()) {
							for(MechanicDesign space:delDependents) {
								if(!dependents.contains(space)) {
									dependents.add(space);
								}
							}
						}
						
					}
				}
			}
			
			//we delete the mechanics that contains this target as a constraint  from the dependents to avoid infinite cycle
			List<MechanicDesign> dependentstoDelete=new ArrayList<MechanicDesign>();

			for(MechanicDesign design:dependents) {
				if(getDependents(design).contains(target)) {
					dependentstoDelete.add(design);
				}
			}
			if(!dependentstoDelete.isEmpty()) {
				dependents.removeAll(dependentstoDelete);
			}
			//
			
			//check if there are dependents to update and add them to the pool if any exists
			filterAndAddDependententToUpdatePool(dependents);
			iscreate=false;
		}

		//set the target new delimiters and add them to system delimiters if not exist
		List<param.Delimeter> delimetersDef =new ArrayList<param.Delimeter>();
		if(delimeters!=null && delimeters.size()>0) {
			for(Delimeter del:delimeters) {
				if(del!=null) {
					delimetersDef.add(del.getDelimeter());
				}
			}
		}
		//create entry just to give us the correct type of delimiterList
		DelimiterCreatorsEntry entry=ParamFactory.eINSTANCE.createDelimiterCreatorsEntry();
		entry.getDelimiters().addAll(delimetersDef);
		getChainModel().getDelimiterCreators().put(target, entry.getDelimiters());
		if(delimeters!=null) {
			for(Delimeter del:delimeters) {
				addDelimeter(del);
			}
		}
		if(isPropagate)
		{
			updatePoolObjects();
		}
		
	}
	/**
	 * 
	 * @param target
	 * @return the MechanicDesigns that reference this target
	 */
	public List<MechanicDesign> getDependents(MechanicDesign target){
		List<MechanicDesign> dependents=new ArrayList<MechanicDesign>();
		List<param.Delimeter> oldDelimeters=getChainModel().getDelimiterCreators().get(target);
		if(oldDelimeters!=null && !oldDelimeters.isEmpty()) {
			for(param.Delimeter del:oldDelimeters) {
				if (getChainModel().getDelimiterContraints().containsKey(del)) {
					List<MechanicDesign> delDependents=getChainModel().getDelimiterContraints().get(del);
					if(delDependents!=null && !delDependents.isEmpty()) {
						for(MechanicDesign space:delDependents) {
							if(!dependents.contains(space)) {
								dependents.add(space);
							}
						}
					}
					
				}
			}
		}
		return dependents;
	}
	public void propagateModifyChange(List<MechanicDesign> brothers) {
		Map<MechanicDesign,List<MechanicDesign>> targetToDependents;
		for(MechanicDesign bro:brothers) {
			
		}
	}
	public boolean splitDos(MechanicDesign dos, MechanicDesign splitSource) throws Exception {
		DesignObject3D elementdos=getIntsatanceToDefinition().get(dos);
		DesignObject3D elementSplitter=getIntsatanceToDefinition().get(splitSource);
		if(elementdos==null || elementSplitter==null ) {
			return false;
		}
		//
		Axe axe =getAXis(elementSplitter, elementdos);
		List<param.Delimeter> splitSourceDelimters=getChainModel().getDelimiterCreators().get(splitSource);
		param.Delimeter maxdelimeter=null;
		param.Delimeter mindelimeter=null;
		if (splitSourceDelimters != null && !splitSourceDelimters.isEmpty()) {
			for (param.Delimeter del : splitSourceDelimters) {
				if (del.getAxis().equals(axe)) {
					if (mindelimeter == null) {
						mindelimeter = del;
					} else if (del.getPosition() <= mindelimeter.getPosition()) {
						mindelimeter = del;
					}
					if (maxdelimeter == null) {
						maxdelimeter = del;
					} else if (del.getPosition() >= maxdelimeter.getPosition()) {
						maxdelimeter = del;
					}
				}
			}
		}
		
		DesignObject3D parent=elementdos.getParentdesign();
		MechanicDesign dos2=EcoreUtil.copy(dos);
		MechanicDesign dos1=EcoreUtil.copy(dos);
		
		DirectionDelimiterMap copyReferences=ParamFactory.eINSTANCE.createDirectionDelimiterMap();
		if(getChainModel().getDesignsReferences().get(dos)!=null)
		{
			DirectionDelimiterMap references=EcoreUtil.copy(getChainModel().getDesignsReferences().get(dos));
			copyReferences=EcoreUtil.copy(references);
		
		
			//TODO check meaxDelimeter and min delimeter we cancel split if both null or just update the dos
			if(maxdelimeter!=null && mindelimeter!=null) {
				if(maxdelimeter.getAxis().equals(Axe.X)) {
					//check if splitter is already referenced by dos then we cancel the split
					if(references.get(Direction.XPLUS)!=null && references.get(Direction.XPLUS).equals(maxdelimeter)){
						return false;
					}
					if(references.get(Direction.XMINUS)!=null && references.get(Direction.XMINUS).equals(mindelimeter)){
						return false;
					}
					if(references.get(Direction.XPLUS)==null || maxdelimeter.getPosition()==references.get(Direction.XPLUS).getPosition())
					{
						references.put(Direction.XPLUS,mindelimeter);
						addORUpdateTargetDependent(dos, references);
						elementdos.update(false);
						return true;
					}else if(references.get(Direction.XMINUS)==null || mindelimeter.getPosition()==references.get(Direction.XMINUS).getPosition())
					{
						references.put(Direction.XMINUS,maxdelimeter);
						addORUpdateTargetDependent(dos, references);
						elementdos.update(false);
						return true;
					}
					references.put(Direction.XPLUS,mindelimeter);
					copyReferences.put(Direction.XMINUS,maxdelimeter);
	
				}else if(maxdelimeter.getAxis().equals(Axe.Y)) {
					if(references.get(Direction.YPLUS)!=null && references.get(Direction.YPLUS).equals(maxdelimeter)){
						return false;
					}
					if(references.get(Direction.YMINUS)!=null && references.get(Direction.YMINUS).equals(mindelimeter)){
						return false;
					}
					if(references.get(Direction.YPLUS)==null || maxdelimeter.getPosition()==references.get(Direction.YPLUS).getPosition())
					{
						references.put(Direction.YPLUS,mindelimeter);
						addORUpdateTargetDependent(dos, references);
						elementdos.update(false);
						return true;
					}else if(references.get(Direction.YMINUS)==null || mindelimeter.getPosition()==references.get(Direction.YMINUS).getPosition())
					{
						references.put(Direction.YMINUS,maxdelimeter);
						addORUpdateTargetDependent(dos, references);
						elementdos.update(false);
						return true;
					}
					references.put(Direction.YPLUS,mindelimeter);
					copyReferences.put(Direction.YMINUS,maxdelimeter);
	
				}
				else if(maxdelimeter.getAxis().equals(Axe.Z)) {
					if(references.get(Direction.ZPLUS)!=null && references.get(Direction.ZPLUS).equals(maxdelimeter)){
						return false;
					}
					if(references.get(Direction.ZMINUS)!=null && references.get(Direction.ZMINUS).equals(mindelimeter)){
						return false;
					}
					if(references.get(Direction.ZPLUS)==null || maxdelimeter.getPosition()==references.get(Direction.ZPLUS).getPosition())
					{
						references.put(Direction.ZPLUS,mindelimeter);
						addORUpdateTargetDependent(dos, references);
						elementdos.update(false);
						return true;
					}else if(references.get(Direction.ZMINUS)==null || mindelimeter.getPosition()==references.get(Direction.ZMINUS).getPosition())
					{
						references.put(Direction.ZMINUS,maxdelimeter);
						addORUpdateTargetDependent(dos, references);
						elementdos.update(false);
						return true;
					}
					references.put(Direction.ZPLUS,mindelimeter);
					copyReferences.put(Direction.ZMINUS,maxdelimeter);
				}
				addORUpdateTargetDependent(dos1, references);//
				addORUpdateTargetDependent(dos2, copyReferences);
//				elementdos.update(false);
				parent.deletechild(elementdos, true,false);//
//				MechanicDesignCreator.getInstance().constructObject(dos1, parent, true, false);//
//				MechanicDesignCreator.getInstance().constructObject(dos2, parent, true, false);
				deleteDesign(dos);//
				if(parent.getMechanicDesignDefinition()!=null&&parent.getMechanicDesignDefinition().getStructureAction()!=null
						&& parent.getMechanicDesignDefinition().getStructureAction().getCreatedRefences().contains(dos)) {
					parent.getMechanicDesignDefinition().getStructureAction().getCreatedRefences().remove(dos);
				
				}
				return true;
			}
		}
		return false;
	}
	
	public Axe getAXis(DesignObject3D elementSplitter, DesignObject3D elementdos) {
		Axe axe = Axe.X;
		if ( elementdos.isProfondPiece()) {
			if ( elementSplitter.isVerticallPiece()) {
				axe = Axe.X;
			} else if ( elementSplitter.isHorizontalePiece()) {
				axe = Axe.Y;
			} else if (( elementSplitter).isProfondPiece()) {
				if (elementSplitter.getHauteurext() < elementSplitter.getLongeurext()) {
					axe = Axe.Y;
				} else {
					axe = Axe.X;
				}
			}
		} else if (elementdos.isVerticallPiece()) {
			if (elementSplitter.isProfondPiece()) {
				axe = Axe.Z;
			} else if ( elementSplitter.isHorizontalePiece()) {
				axe = Axe.Y;
			} else if ( elementSplitter.isVerticallPiece()) {
				if (elementSplitter.getHauteurext() < elementSplitter.getProfondeurext()) {
					axe = Axe.Y;
				} else {
					axe = Axe.Z;
				}
			}
		} else if ( elementdos.isHorizontalePiece()) {
			if (elementSplitter.isProfondPiece()) {
				axe = Axe.Z;
			} else if (elementSplitter.isVerticallPiece()) {
				axe = Axe.X;
			} else if (elementSplitter.isHorizontalePiece()) {
				if (elementSplitter.getLongeurext() < elementSplitter.getProfondeurext()) {
					axe = Axe.X;
				} else {
					axe = Axe.Z;
				}
			}
		}
		return axe;
	}
	
	public void filterAndAddDependententToUpdatePool(List<MechanicDesign> dependents) {
		if(!dependents.isEmpty()) {
			List<MechanicDesign> dependentsToElemenate=new ArrayList<MechanicDesign>();
			for(MechanicDesign design:dependents) {
				for(MechanicDesign brother:dependents) {
					if(!design.equals(brother)) {
						if(isTargetContainsBrotherReference(design,brother)) {
							if(!dependentsToElemenate.contains(brother)) {
								dependentsToElemenate.add(brother);
							}
						}
					}
				}
				
			}
			for(MechanicDesign design:dependentsToElemenate) {
				dependents.remove(design);
			}
			for(MechanicDesign design:dependents) {
				getUpdatePool().add(design);
			}
		}
	}
	public void filterDependentent(List<MechanicDesign> dependents) {
		if(!dependents.isEmpty()) {
			List<MechanicDesign> dependentsToElemenate=new ArrayList<MechanicDesign>();
			for(MechanicDesign design:dependents) {
				for(MechanicDesign brother:dependents) {
					if(!design.equals(brother)) {
						if(isTargetContainsBrotherReference(design,brother)) {
							if(!dependentsToElemenate.contains(brother)) {
								dependentsToElemenate.add(brother);
							}
						}
					}
				}
				
			}
			for(MechanicDesign design:dependentsToElemenate) {
				dependents.remove(design);
			}
		}
	}
	public boolean isTargetContainsBrotherReference(MechanicDesign design, MechanicDesign brother) {
		if(getChainModel().getDelimiterCreators().get(design)!=null) {
			List<param.Delimeter> designdelimeters = getChainModel().getDelimiterCreators().get(design);
			if(designdelimeters!=null && !designdelimeters.isEmpty()) {
				for(param.Delimeter del:designdelimeters) {
					if(getChainModel().getDelimiterContraints()!=null &&getChainModel().getDelimiterContraints().containsKey(del) )
					{
						if(getChainModel().getDelimiterContraints().get(del)!=null && getChainModel().getDelimiterContraints().get(del).contains(brother)) {
							return true;
						}
					}
				}
			}
		}
		return false;
	}
	/**
	 * 
	 * @param target
	 * @param constraintdelimeters
	 */
	public void addORUpdateTargetDependent(MechanicDesign target,DirectionDelimiterMap constraintdelimeters) {
		System.err.println("register Dependent design "+ target.getName()+" with id \t"+target.getId()+"\n"+constraintdelimeters.toString());

		if(getChainModel().getDesignsReferences().containsKey(target)) {			
			//if the target is contained in the designReferences map we consider it an old object in the system.
			//first we update the state of its old delimiters if any exist
			DirectionDelimiterMap olddelimeters = getChainModel().getDesignsReferences().get(target);
			if(olddelimeters!=null && !olddelimeters.getEntries().isEmpty()) {
				for(DirectionDelimiterEntry entry:olddelimeters.getEntries()) {
					if( entry!=null) {
						param.Delimeter oldDel=entry.getDelimiter();
						if(oldDel!=null ) {
							//if this old delimiter not contained in the appropriate direction,
							//we check first if this old delimiter constraints contains this target we remove said target from said constraints
							if(!constraintdelimeters.containsKey(entry.getDirection()) || !constraintdelimeters.get(entry.getDirection()).equals(oldDel) ) {
								List<MechanicDesign> constraintsDelimiter =getChainModel().getDelimiterContraints().get(oldDel);
								if(constraintsDelimiter!=null && constraintsDelimiter.contains(target)) {
									constraintsDelimiter.remove(target);
								}
							}
						}
					}
					
				}
			}
		}
		//in all cases (create/update) we put the target and its delimiters in the designReferences map
		getChainModel().getDesignsReferences().put(target, constraintdelimeters);
		
		//we check the target new delimeters and update/add their new state to the constaints map
		if(constraintdelimeters!=null && !constraintdelimeters.getEntries().isEmpty()) {
			for(DirectionDelimiterEntry entry:constraintdelimeters.getEntries()) {
				if(entry!=null) {
					param.Delimeter del=entry.getDelimiter();
					addDeisgnToDelemeterConstraint(del, target);
					
				}	
				
			}
		}
	}
	/**
	 * add the constraint to delimiter constraints
	 * @param del
	 * @param constraint
	 */
	public void addDeisgnToDelemeterConstraint(param.Delimeter del,MechanicDesign constraint) {
		if(del!=null && constraint!=null) {
			//check if the current new delimiter in the constraints map
			if(getChainModel().getDelimiterContraints().get(del)!=null) {
				//check if the target not contained in the constraints of this delimiter we just add it 
				if(!getChainModel().getDelimiterContraints().get(del).contains(constraint)) {
					getChainModel().getDelimiterContraints().get(del).add(constraint);
				}
				
			}else {
				//if the current delimiter not contained in the constraints map,
				//we create a new list contains this target and add it to the constraints map 
				DelimiterConstraintsEntry constraintEntry= ParamFactory.eINSTANCE.createDelimiterConstraintsEntry();
				constraintEntry.setDelimiter(del);
				constraintEntry.getDelimieterContraints().add(constraint);
				getChainModel().getDelimiterContraints().getEntries().add(constraintEntry);
			}
		}
	}
	
	public void deleteDependent(MechanicDesign target) {
		DirectionDelimiterMap olddelimeters = getChainModel().getDesignsReferences().get(target);
		if(olddelimeters!=null && !olddelimeters.getEntries().isEmpty()) {
			for(DirectionDelimiterEntry entry:olddelimeters.getEntries()) {
				if(entry!=null) {
					param.Delimeter oldDel=entry.getDelimiter();
					if(oldDel!=null) {
						//if this old delimiter not contained in the appropriate direction,
						//we check first if this old delimiter constraints contains this target we remove said target from said constraints
						
						List<MechanicDesign> constraintsDelimiter =getChainModel().getDelimiterContraints().get(oldDel);
						if(constraintsDelimiter!=null && constraintsDelimiter.contains(target)) {
							constraintsDelimiter.remove(target);
						}
						
					}
				}
				
			}
		}
		getChainModel().getDesignsReferences().remove(target);
	}
	public void deleteDesign(MechanicDesign src) throws Exception {
		deleteDependent(src);
		deleteCreator(src);
		getUpdatePool().removeIf(new Predicate<MechanicDesign>() {

			@Override
			public boolean test(MechanicDesign t) {
				if(t!=null && t.equals(src)) {
					return true;
				}
				return false;
			}
		});
		getIntsatanceToDefinition().remove(src);
	}
	public void deleteCreator(MechanicDesign target) throws Exception{
		List<MechanicDesign> dependents=getDependents(target);
		if(target!=null) {
			if(target!=null && getChainModel().getDelimiterCreators().containsKey(target)) {
				EList<param.Delimeter> delimeters =getChainModel().getDelimiterCreators().get(target);
				if(delimeters!=null && !delimeters.isEmpty()) {
					
					//remove Delimiters from axisDelimeters Map to remove it completely from the system
					for(param.Delimeter targetDelimeter:delimeters) {
						if(getChainModel().getAxisDelimiters().containsKey(targetDelimeter.getAxis())) {
							List<param.Delimeter> AxisDelemeters=getChainModel().getAxisDelimiters().get(targetDelimeter.getAxis());
							if(AxisDelemeters!=null && AxisDelemeters.contains(targetDelimeter)) {
								AxisDelemeters.remove(targetDelimeter);
							}
						}
					}
					//remove delimiters constraints
					for(param.Delimeter targetDelimeter:delimeters) {
						deleteDelimiterContraints(targetDelimeter);
						getDelimiterIntsatanceToDefinition().remove(targetDelimeter);
					}

				}
				//remove the src from dilimerterCreators map to remove it from the system as an ancestor
				getChainModel().getDelimiterCreators().remove(target);

			}
			filterAndAddDependententToUpdatePool(dependents);
		}
	
		updatePoolObjects();
		
	}
	
	/**
	 * 
	 * @param delimiter
	 * @return
	 */
	public boolean deleteDelimiterContraints(param.Delimeter delimiter) {
		if(getChainModel().getDelimiterContraints()!=null && getChainModel().getDelimiterContraints().containsKey(delimiter)) {
			//search for dependents and update their delimiters
			List<MechanicDesign> Delimeterdependents =getChainModel().getDelimiterContraints().get(delimiter);
			if(Delimeterdependents!=null && !Delimeterdependents.isEmpty()) {
				for(MechanicDesign dependent:Delimeterdependents ) {
					if(dependent!=null && getChainModel().getDesignsReferences().containsKey(dependent)) {
						DirectionDelimiterMap olddelimeters = getChainModel().getDesignsReferences().get(dependent);
						if(olddelimeters!=null && !olddelimeters.getEntries().isEmpty()) {
							//search the appropriate direction the dependent references this delimiter
							for(DirectionDelimiterEntry entry:olddelimeters.getEntries()) {
								param.Delimeter oldDel=entry.getDelimiter();
								if(oldDel!=null) {
									//verify if dependent delimeter in direction dir equal the target delimeter
									if(oldDel.equals(delimiter)) {
										//search for a new delimeter in the current direction
										param.Delimeter newDelimeter=shearchNewDelimeter(oldDel, entry.getDirection(),dependent);
										//
										entry.setDelimiter(newDelimeter);
										//check if the newDelimiter in not null we add the current dependent to said delimiter constraints
										if(newDelimeter!=null)
										{
											addDeisgnToDelemeterConstraint(newDelimeter, dependent);
										}
										
										break;
									}
									
								}
							}
						}
					}
				}
			}
			//remove Delimiter from constraints map to make not constrain its former dependents 
			getChainModel().getDelimiterContraints().remove(delimiter);
		}
		return false;
	}
	
	/**
	 * search in the component (splitter) dependents to find the fonds(dos) to be deleted
	 * @param delsdependents list of dependents of the splitter 
	 * @param splitter 
	 * @return list of fond to be deleted
	 */
	public List<MechanicDesign> findExcessDos(Map<Delimeter, List<MechanicDesign>> delsdependents,MechanicDesign splitter) {
		List<MechanicDesign> listDos=new ArrayList<MechanicDesign>();
		Map<Delimeter, List<MechanicDesign>> delsdependentsDos=new HashMap<Delimeter, List<MechanicDesign>>();
		//filter dependents to obtain only the fonds 
		if(delsdependents!=null && !delsdependents.isEmpty()) {
			for(Delimeter del:delsdependents.keySet()) {
				if(del!=null && delsdependents.get(del)!=null && !delsdependents.get(del).isEmpty() ) {
					List<MechanicDesign> targetdelDependents =delsdependents.get(del);
					for(MechanicDesign design:targetdelDependents) {
						if(design!=null && design.getType().equals(PieceType.PIECE2D)) {
							try {
								MechanicPublicParam param=	design.getPublicParam("Piece_Type");
								if(param!=null && param.getTypedef()!=null && param.getTypedef().getKey().contentEquals("PieceType")
										&& param.getTypedefelement()!=null && param.getTypedefelement().getKey().contentEquals("DOS_INTERIEUR")) {
									if(delsdependentsDos.containsKey(del) &&delsdependentsDos.get(del)!=null) {
										delsdependentsDos.get(del).add(design);
									}
									else {
										List<MechanicDesign> targetdelDependentdos=new ArrayList<MechanicDesign>();
										targetdelDependentdos.add(design);
										delsdependentsDos.put(del, targetdelDependentdos);
									}
								}
							} catch (Exception e) {
								e.printStackTrace();
							}
						}
					}
				}
				
			}
		}
		if(delsdependentsDos!=null &&!delsdependentsDos.isEmpty()) {
			//case of fonds dependents on 2 delimiters of this splitter (cas du separator ou etagere fix)
			if(delsdependentsDos.keySet().size()==2) {
				List<MechanicDesign> del1Dos=null;
				List<MechanicDesign> del2Dos=null;
				//extract 
				for(Delimeter del:delsdependentsDos.keySet()) {
					List<MechanicDesign> deldos = delsdependentsDos.get(del);
					if(del1Dos==null) {
						del1Dos=deldos;
					}else {
						del2Dos=deldos;
					}
				}
				if(del1Dos!=null && !del1Dos.isEmpty() && del2Dos!=null && !del2Dos.isEmpty())
				{	
					//if one side or both sides of the splitter contains 1 dos we delete it otherwise we delete all dos 
					if(del1Dos.size()==1 && del2Dos.size()>=1) {
						listDos.addAll(del1Dos);

					}else if(del2Dos.size()==1 && del1Dos.size()>=1){
						listDos.addAll(del2Dos);
					}else {
						listDos.addAll(del1Dos);
						listDos.addAll(del2Dos);

					}
				}
			}else if (delsdependentsDos.keySet().size()>=2) {
				
			}
		}
		
		return listDos;
	}
	/**
	 * delete list fonds 
	 * @param doslist
	 * @throws Exception 
	 */
	public void deleteExcessDos(List<MechanicDesign> doslist) throws Exception {
		if(doslist!=null && !doslist.isEmpty()) {
			
			for (MechanicDesign design : doslist) {
				DesignObject3D elementdos = getIntsatanceToDefinition().get(design);
				DesignObject3D parent = elementdos.getParentdesign();
				parent.deletechild(elementdos, true);
			}

		}
		
	}
	
	
	public boolean isDelimiterOfDesendent(MechanicDesign design ,param.Delimeter delimiter) {
		if(design!=null && delimiter!=null) {
			List<param.Delimeter> delimetrs = getChainModel().getDelimiterCreators().get(design);
			if(delimetrs!=null && !delimetrs.isEmpty())
			{
				for(int i=0;i<delimetrs.size();i++) {
					param.Delimeter del=delimetrs.get(i);
					if(delimiter.equals(del)) {
						return true;
					}
					List<MechanicDesign> delConstraints= getChainModel().getDelimiterContraints().get(del);
					if(delConstraints!=null && !delConstraints.isEmpty()) {
						for(int j=0;j<delConstraints.size();j++) {
							MechanicDesign constraint =delConstraints.get(j);
							List<param.Delimeter> constraintdelimetrs = getChainModel().getDelimiterCreators().get(constraint);
							if(constraintdelimetrs!=null && !constraintdelimetrs.isEmpty())
							{
								for(param.Delimeter constraintDel:constraintdelimetrs) {
									if(delimiter.equals(constraintDel)) {
										return true;
									}
								}
							}
							if(isDelimiterOfDesendent(constraint, delimiter)) {
								return true;
							}
						}
					}
					
				}
			}
			
			
		}
		return false;
	}
	
	/**
	 * 
	 * @param reference the origin delimiter of the target dependent as reference 
	 * @param dir the direction of delimiter and at the same time the direction of the search
	 * @param referenceBrothers 
	 * @param dependent 
	 * @return the delimiter in the appropriate direction
	 */
	public param.Delimeter shearchNewDelimeter(param.Delimeter reference, Direction dir, MechanicDesign dependent) {
		if(reference!=null &&dir!=null  && reference.getAxis() !=null &&getChainModel().getAxisDelimiters()!=null && !getChainModel().getAxisDelimiters().getEntries().isEmpty()) {
			Delimeter referenceInstance = getDelimiterIntsatanceToDefinition().get(reference);
			DesignObject3D designdependent=getIntsatanceToDefinition().get(dependent);
			Plan3D plan=null;
			if(designdependent!=null) {
				
				Intervale xinter=new Intervale(designdependent.getXPosABS()-root.getXPosABS(), true, designdependent.getXPosABS()-root.getXPosABS()+designdependent.getLongeurext(), true);
				Intervale yinter=new Intervale(designdependent.getYPosABS()-root.getYPosABS(), true, designdependent.getYPosABS()-root.getYPosABS()+designdependent.getHauteurext(), true);
				Intervale zinter=new Intervale(designdependent.getZPosABS()-root.getZPosABS(), true, designdependent.getZPosABS()-root.getZPosABS()+designdependent.getProfondeurext(), true);		
				plan= new Plan3D(xinter,yinter,zinter);		
				
			}
			if(getChainModel().getAxisDelimiters().containsKey(reference.getAxis()) && referenceInstance!=null) {
				List<param.Delimeter> delimeters= getChainModel().getAxisDelimiters().get(reference.getAxis());
				Delimeter ref=null;
				for(param.Delimeter delimiter:delimeters) {
					Delimeter del=getDelimiterIntsatanceToDefinition().get(delimiter);
					if(del!=null &&!delimiter.equals(reference) && !isDelimiterOfDesendent(dependent, delimiter)) {
						boolean match=false;
						switch (dir) {
						case XMINUS:
						case YMINUS:
						case ZMINUS:
							if(del.getPosition()<=referenceInstance.getPosition()) {
								if(ref==null ||del.getPosition()>ref.getPosition()) {
									//case axe X and direction xmin 
									if(dir.equals(Direction.XMINUS) ) {
										//check if the current delimiter is a physical delimiter 
										if(plan!=null) {
											if(plan.getYinter().getintersection(del.getYint())!=null&&plan.getYinter().getintersection(del.getYint()).size()>0  
													&& plan.getZinter().getintersection(del.getZint())!=null&&plan.getZinter().getintersection(del.getZint()).size()>0) {
													match=true;
												}
										}else
											//check if the current delimiter intersect with old delimiter
											if(referenceInstance.getYint().getintersection(del.getYint())!=null&&referenceInstance.getYint().getintersection(del.getYint()).size()>0  
													&& referenceInstance.getZint().getintersection(del.getZint())!=null&&referenceInstance.getZint().getintersection(del.getZint()).size()>0) {
											match=true;
										}
										//case axe Y and direction ymin
									}else if(dir.equals(Direction.YMINUS)) {
										//check if the current delimiter is a physical delimiter 
										if(plan!=null) {
											if(plan.getXinter().getintersection(del.getXint())!=null&&plan.getXinter().getintersection(del.getXint()).size()>0  
													&& plan.getZinter().getintersection(del.getZint())!=null&&plan.getZinter().getintersection(del.getZint()).size()>0) {
												match=true;
											}
										}else
											//check if the current delimiter intersect with old delimiter
											if(referenceInstance.getXint().getintersection(del.getXint())!=null&&referenceInstance.getXint().getintersection(del.getXint()).size()>0  
													&& referenceInstance.getZint().getintersection(del.getZint())!=null&&referenceInstance.getZint().getintersection(del.getZint()).size()>0) {
												match=true;
											}
										//case axe Z and direction zmin
									}else if(dir.equals(Direction.ZMINUS)){
										//check if the current delimiter is a physical delimiter 
										if(plan!=null) {
											if( referenceInstance.getYint().getintersection(del.getYint())!=null&&referenceInstance.getYint().getintersection(del.getYint()).size()>0  
													&& referenceInstance.getXint().getintersection(del.getXint())!=null&&referenceInstance.getXint().getintersection(del.getXint()).size()>0) {
												match=true;
											}
										
										}else
											//check if the current delimiter intersect with old delimiter
											if( referenceInstance.getYint().getintersection(del.getYint())!=null&&referenceInstance.getYint().getintersection(del.getYint()).size()>0  
												&& referenceInstance.getXint().getintersection(del.getXint())!=null&&referenceInstance.getXint().getintersection(del.getXint()).size()>0) {
											match=true;
										}
									}
								}
							}
							break;
						case XPLUS:
						case YPLUS:
						case ZPLUS:
							if(del.getPosition()>=reference.getPosition()) {
								if(ref==null ||del.getPosition()<ref.getPosition()) {
									if(dir.equals(Direction.XPLUS)) {
										//check if the current delimiter is a physical delimiter 
										if(plan!=null) {
											if(plan.getYinter().getintersection(del.getYint())!=null&&plan.getYinter().getintersection(del.getYint()).size()>0  
													&& plan.getZinter().getintersection(del.getZint())!=null&&plan.getZinter().getintersection(del.getZint()).size()>0) {
													match=true;
												}
										}else
											//check if the current delimiter intersect with old delimiter
											if(referenceInstance.getYint().getintersection(del.getYint())!=null&&referenceInstance.getYint().getintersection(del.getYint()).size()>0  
													&& referenceInstance.getZint().getintersection(del.getZint())!=null&&referenceInstance.getZint().getintersection(del.getZint()).size()>0) {
											match=true;
											}
										//case axe Y and direction ymin
									}else if(dir.equals(Direction.YPLUS)) {
										//check if the current delimiter is a physical delimiter 
										if(plan!=null) {
											if(plan.getXinter().getintersection(del.getXint())!=null&&plan.getXinter().getintersection(del.getXint()).size()>0  
													&& plan.getZinter().getintersection(del.getZint())!=null&&plan.getZinter().getintersection(del.getZint()).size()>0) {
												match=true;
											}
										}else
											//check if the current delimiter intersect with old delimiter
											if(referenceInstance.getXint().getintersection(del.getXint())!=null&&referenceInstance.getXint().getintersection(del.getXint()).size()>0  
													&& referenceInstance.getZint().getintersection(del.getZint())!=null&&referenceInstance.getZint().getintersection(del.getZint()).size()>0) {
												match=true;
											}
										//case axe Z and direction zmin
									}else if(dir.equals(Direction.ZPLUS)){
										//check if the current delimiter is a physical delimiter 
										if(plan!=null) {
											if( referenceInstance.getYint().getintersection(del.getYint())!=null&&referenceInstance.getYint().getintersection(del.getYint()).size()>0  
													&& referenceInstance.getXint().getintersection(del.getXint())!=null&&referenceInstance.getXint().getintersection(del.getXint()).size()>0) {
												match=true;
											}
										
										}else
											//check if the current delimiter intersect with old delimiter
											if( referenceInstance.getYint().getintersection(del.getYint())!=null&&referenceInstance.getYint().getintersection(del.getYint()).size()>0  
												&& referenceInstance.getXint().getintersection(del.getXint())!=null&&referenceInstance.getXint().getintersection(del.getXint()).size()>0) {
											match=true;
										}
									}
								}
							}
							break;

						};
						if(match) {
							ref=del;
						}
					}
					
				}
				return (ref!=null && ref.getDelimeter()!=null)?ref.getDelimeter():null;
			}
		}
		
		return null;
	}
	
	public Delimeter getDelimeter(DelimeterImpl delimeter) {
//		if(delimeter.getAxis()!=null) {
//			List<Delimeter> delimeters =getAxisDelimeters().get(delimeter.getAxis());
//			if(delimeters!=null && !delimeters.isEmpty()) {
//				for (Delimeter del : delimeters) {
//					if (del.getDelimeter().equals(delimeter)) {
//						return del;
//						
//					}
//				}
//			}
//		}
		
		return getDelimiterIntsatanceToDefinition().get(delimeter);
	}
	public MechanicDesign getDelimeterCreator(DelimeterImpl del) {
		if(getChainModel()!=null && getChainModel().getDelimiterCreators()!=null && !getChainModel().getDelimiterCreators().getEntries().isEmpty()) {
			for(DelimiterCreatorsEntry entry: getChainModel().getDelimiterCreators().getEntries()) {
				if(entry!=null && entry.getCreator()!=null && entry.getDelimiters()!=null && entry.getDelimiters().contains(del)) {
					return entry.getCreator();
				}
			}
		}
		return null;
	}
	public DirectionDelimiterMap getparentSpace(Point3d point,MechanicDesign design, DesignObject3D parent) throws Exception {
		Delimeter xmin=null;
		Delimeter xmax=null;
		Delimeter ymin=null;
		Delimeter ymax=null;
		Delimeter zmin=null;
		Delimeter zmax=null;
		boolean transversantDos=false;
		if(design!=null) {
			try {
				transversantDos =Boolean.valueOf(design.getPublicParam("SEPRATEUR_TRANSVERSANT").getTypedefelement().getKey());
			} catch (Exception e) {
				transversantDos=false;
//				e.printStackTrace();
			}
		}
		boolean isFacade=false;
		if (design != null && design.getType().equals(param.PieceType.SPACE3D)) {
			try {
				MechanicPublicParam type = design.getPublicParam("Piece_Type");
				if (type!=null && type.getTypedefelement()!=null &&type.getTypedefelement().getKey().equals("FACADE_FRANCAISE")) {
					isFacade=true;		
				}
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
		
		if(getChainModel().getAxisDelimiters().containsKey(Axe.X)&&getChainModel().getAxisDelimiters().get(Axe.X)!=null) {
			for(param.Delimeter delimeter:getChainModel().getAxisDelimiters().get(Axe.X)) {
				Delimeter del=getDelimiterIntsatanceToDefinition().get(delimeter);
				try {
					MechanicDesign delCreator = getDelimeterCreator((DelimeterImpl) delimeter);
					DesignObject3D design3d=getIntsatanceToDefinition().get(delCreator);
					if(design3d==null ||!design3d.isVisible()) {
						continue;
					}
//					if(isFacade&& design3d instanceof Space3D /*&& !delCreator.getType().equals(param.PieceType.CAISSON)*/) {
// 						continue;
//					}
				}catch(Exception e) {
					e.printStackTrace();
				}
				if(transversantDos) {
					MechanicDesign delCreator = getDelimeterCreator((DelimeterImpl) delimeter);
					if(delCreator!=null) {
						MechanicPublicParam param=delCreator.getPublicParam("Piece_Type");
						if(param!=null && param.getTypedefelement()!=null && param.getTypedefelement().getKey().contentEquals("DOS_INTERIEUR")) {
							continue;
						}
					}
				}
				if(del!=null) {
					if(xmin==null && point.x>del.getPosition()&&(del.getYint().contains(point.getY())&&del.getZint().contains(point.getZ()) )) {
						xmin=del;
					}else {
						if(point.x>del.getPosition() &&(del.getYint().contains(point.getY())&&del.getZint().contains(point.getZ()))
								&& Math.abs(point.getX()-del.getPosition())<Math.abs(point.getX()-xmin.getPosition())) {
							xmin=del;
						}
					}
					if(xmax==null && point.x<del.getPosition()&&(del.getYint().contains(point.getY())&&del.getZint().contains(point.getZ()) )) {
						xmax=del;
					}else {
						if(point.x<del.getPosition() &&(del.getYint().contains(point.getY())&&del.getZint().contains(point.getZ()) )
								&& Math.abs(point.getX()-del.getPosition())<Math.abs(point.getX()-xmax.getPosition())) {
							xmax=del;
						}
					}
				}
			}
		}
		if(getChainModel().getAxisDelimiters().containsKey(Axe.Y) && getChainModel().getAxisDelimiters().get(Axe.Y)!=null) {
			for(param.Delimeter delimeter:getChainModel().getAxisDelimiters().get(Axe.Y)) {
				Delimeter del=getDelimiterIntsatanceToDefinition().get(delimeter);
				try {
					MechanicDesign delCreator = getDelimeterCreator((DelimeterImpl) delimeter);
					DesignObject3D design3d=getIntsatanceToDefinition().get(delCreator);
					if(design3d==null ||!design3d.isVisible()) {
						continue;
					}
//					if(isFacade&& design3d instanceof Space3D /*&& !delCreator.getType().equals(param.PieceType.CAISSON)*/) {
//						continue;
//					}
				}catch(Exception e) {
					e.printStackTrace();
				}
				if(transversantDos) {
					MechanicDesign delCreator = getDelimeterCreator((DelimeterImpl) delimeter);
					if(delCreator!=null) {
						MechanicPublicParam param=delCreator.getPublicParam("Piece_Type");
						if(param!=null && param.getTypedefelement()!=null && param.getTypedefelement().getKey().contentEquals("DOS_INTERIEUR")) {
							continue;
						}
					}
				}
				if(del!=null) {
					if(ymin==null && point.getY()>del.getPosition()&&(del.getXint().contains(point.getX())&&del.getZint().contains(point.getZ()) )) {
						ymin=del;
					}else {
						if(point.y>del.getPosition()&&(del.getXint().contains(point.getX())&&del.getZint().contains(point.getZ()) ) 
								&& Math.abs(point.getY()-del.getPosition())<Math.abs(point.getY()-ymin.getPosition())) {
							ymin=del;
						}
					}
					if(ymax==null && point.getY()<del.getPosition()&&(del.getXint().contains(point.getX())&&del.getZint().contains(point.getZ()) )) {
						ymax=del;
					}else {
						if(point.getY()<del.getPosition() &&(del.getXint().contains(point.getX())&&del.getZint().contains(point.getZ()) )
								&& Math.abs(point.getY()-del.getPosition())<Math.abs(point.getY()-ymax.getPosition())) {
							ymax=del;
						}
					}
				}
			}
		}
		if(getChainModel().getAxisDelimiters().containsKey(Axe.Z)&&getChainModel().getAxisDelimiters().get(Axe.Z)!=null) {
			for(param.Delimeter delimeter:getChainModel().getAxisDelimiters().get(Axe.Z)) {
				Delimeter del=getDelimiterIntsatanceToDefinition().get(delimeter);
				try {
					MechanicDesign delCreator = getDelimeterCreator((DelimeterImpl) delimeter);
					DesignObject3D design3d=getIntsatanceToDefinition().get(delCreator);
					if(design3d==null ||!design3d.isVisible()) {
						continue;
					}
//					if(isFacade&& design3d instanceof Space3D /*&& !delCreator.getType().equals(param.PieceType.CAISSON)*/) {
//						continue;
//					}
				}catch(Exception e) {
					e.printStackTrace();
				}
				if(transversantDos) {
					MechanicDesign delCreator = getDelimeterCreator((DelimeterImpl) delimeter);
					if(delCreator!=null) {
						MechanicPublicParam param=delCreator.getPublicParam("Piece_Type");
						if(param!=null && param.getTypedefelement()!=null && param.getTypedefelement().getKey().contentEquals("DOS_INTERIEUR")) {
							continue;
						}
					}
				}
				if(del!=null) {
					if(zmin==null && point.getZ()>=del.getPosition() &&(del.getXint().contains(point.getX()) && del.getYint().contains(point.getY()) )) {
						zmin=del;
					}else {
						if(point.getZ()>=del.getPosition() &&(del.getXint().contains(point.getX()) && del.getYint().contains(point.getY()) )
								&& Math.abs(point.getZ()-del.getPosition())<Math.abs(point.getZ()-zmin.getPosition())) {
							zmin=del;
						}
					}
					if(zmax==null && point.getZ()<del.getPosition() &&(del.getXint().contains(point.getX()) && del.getYint().contains(point.getY()) )) {
						zmax=del;
					}else {
						if((point.getZ()<=del.getPosition() && !del.equals(zmin)) &&(del.getXint().contains(point.getX()) && del.getYint().contains(point.getY()) )
								&& Math.abs(point.getZ()-del.getPosition())<Math.abs(point.getZ()-zmax.getPosition())) {
							zmax=del;
						}
					}
				}
			}
		}
		//
		DirectionDelimiterMap delimeters = createDirectionsMap(design, xmin, xmax, ymin, ymax, zmin, zmax);
		return delimeters;
	}
	protected DirectionDelimiterMap createDirectionsMap(MechanicDesign design, Delimeter xmin, Delimeter xmax,
														Delimeter ymin, Delimeter ymax, Delimeter zmin, Delimeter zmax) {
			EList<param.Delimeter> rootDelimeters = this.getChainModel().getDelimiterCreators().get(this.getRoot().getMechanicDesignDefinition());
	
			if(isAbsolute(design, ymax, "absolute_Top")) {
				ymax=getRootAbsoluteDelimeter(rootDelimeters, Axe.Y,1);
			}
			
			if(isAbsolute(design, ymin, "absolute_Bottom")) {
				ymin=getRootAbsoluteDelimeter(rootDelimeters, Axe.Y,-1);
			}
			
			if(isAbsolute(design, xmax, "absolute_Right")) {
				xmax=getRootAbsoluteDelimeter(rootDelimeters, Axe.X,1);
			}
			if(isAbsolute(design, xmin, "absolute_Left")) {
				xmin=getRootAbsoluteDelimeter(rootDelimeters, Axe.X,-1);	
			}
			
			if(isAbsolute(design, zmax, "absolute_Front")) {
				zmax=getRootAbsoluteDelimeter(rootDelimeters, Axe.Z,1);
			}
			
			if(isAbsolute(design, zmin, "absolute_Back")) {
				zmin = getRootAbsoluteDelimeter(rootDelimeters, Axe.Z,-1);
			}
			
			//
			DirectionDelimiterMap delimeters = ParamFactory.eINSTANCE.createDirectionDelimiterMap();
			if(xmin!=null)
			{
				addReferenceDelimeter(xmin, delimeters,Direction.XMINUS);
			}
			if(xmax!=null)
			{
				addReferenceDelimeter(xmax, delimeters,Direction.XPLUS);
			}
			if(ymin!=null)
			{
				addReferenceDelimeter(ymin, delimeters,Direction.YMINUS);
			}
			if(ymax!=null)
			{
				addReferenceDelimeter(ymax, delimeters,Direction.YPLUS);
			}
			if(zmin!=null)
			{
				addReferenceDelimeter(zmin, delimeters,Direction.ZMINUS);
			}
			if(zmax!=null)
			{
				addReferenceDelimeter(zmax, delimeters,Direction.ZPLUS);
			}
			return delimeters;
	}
	protected void addReferenceDelimeter(Delimeter delimeter, DirectionDelimiterMap delimeters,Direction dir) {
		DirectionDelimiterEntry entry= ParamFactory.eINSTANCE.createDirectionDelimiterEntry();
		entry.setDelimiter(delimeter.getDelimeter());
		entry.setDirection(dir);
		delimeters.getEntries().add(entry);
	}
	protected Delimeter getRootAbsoluteDelimeter(EList<param.Delimeter> rootDelimeters, Axe axe, int sign) {
		
		Delimeter ref=null;
		if(rootDelimeters!=null && rootDelimeters.size()>0) {
			for(param.Delimeter del:rootDelimeters){
				if(del.getAxis().equals(axe)) {
					if(ref==null ||Double.compare(del.getPosition(), ref.getPosition())==sign) {
						ref=getDelimiterIntsatanceToDefinition().get(del);
					}
				}
			}
		}
		return ref;
	}

	public boolean isAbsolute(MechanicDesign design, Delimeter zmin,String param) {
		try {
			return Boolean.valueOf(design.getPublicParam(param).getTypedefelement().getKey());			
		} catch (Exception e) {
			return false;
		}
	}
	public DesignObject3D createConstraintSpace(DirectionDelimiterMap delimeters, DesignObject3D parent,boolean createSpace) {
		if (delimeters != null) {
			param.Delimeter xmin = delimeters.get(Direction.XMINUS);
			param.Delimeter xmax = delimeters.get(Direction.XPLUS);
			param.Delimeter ymin = delimeters.get(Direction.YMINUS);
			param.Delimeter ymax = delimeters.get(Direction.YPLUS);
			param.Delimeter zmin = delimeters.get(Direction.ZMINUS);
			param.Delimeter zmax = delimeters.get(Direction.ZPLUS);

			double xminPos = 0;
			double xmaxPos = parent.getLongeurext();
			double yminPos = 0;
			double ymaxPos = parent.getHauteurext();
			double zminPos = 0;
			double zmaxPos = parent.getProfondeurext();
			// check if all dilimiters are null return null,
			// else check each delimiter if null replace with 0 or parent dimension on the appropriate axis
			if (xmin == null && xmax == null && ymin == null && ymax == null && zmin == null && zmax == null) {
				return null;
			} else {
				if (xmin != null) {
					xminPos = xmin.getPosition();
				}
				if (xmax != null) {
					xmaxPos = xmax.getPosition();
				}
				if (ymin != null) {
					yminPos = ymin.getPosition();
				}
				if (ymax != null) {
					ymaxPos = ymax.getPosition();
				}
				if (zmin != null) {
					zminPos = zmin.getPosition();
				}
				if (zmax != null) {
					zmaxPos = zmax.getPosition();
				}
				if(intermidiateSpace==null || createSpace)
				{
					intermidiateSpace = new Space3D();
					intermidiateSpace.setName("Espace 3d intermidière");
					System.err.println("***********Espace 3d intermidière initiated*************");
				}else {
					try {
						intermidiateSpace.clearautomatique(true);
					} catch (Exception e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}					
					
				}
//				space.setXpos(xminPos-parent.getRootModule().getXpos());
//				space.setYpos(yminPos -parent.getRootModule().getYpos());
//				space.setZpos(zminPos -parent.getRootModule().getZpos());
				intermidiateSpace.setXpos(xminPos);
				intermidiateSpace.setYpos(yminPos);
				intermidiateSpace.setZpos(zminPos);
				intermidiateSpace.setLongeurext(Math.abs(xmaxPos - xminPos));
				intermidiateSpace.setHauteurext(Math.abs(ymaxPos - yminPos));
				intermidiateSpace.setProfondeurext(Math.abs(zmaxPos - zminPos));
				intermidiateSpace.setLongeurint(intermidiateSpace.getLongeurext());
				intermidiateSpace.setHauteurint(intermidiateSpace.getHauteurext());
				intermidiateSpace.setProfondeurint(intermidiateSpace.getProfondeurext());
				intermidiateSpace.setBasematerial(((Space3D) parent).getBasematerial());
				intermidiateSpace.setBackmaterial(((Space3D) parent).getBackmaterial());
				intermidiateSpace.setFacadeMaterial(((Space3D) parent).getFacadeMaterial());
				intermidiateSpace.setParentdesign(parent);
				if(createSpace)
				{   Space3D space=intermidiateSpace;
					intermidiateSpace = new Space3D();
					intermidiateSpace.setName("Espace 3d intermidière");
					System.err.println("***********Espace 3d intermidière initiated*************");
					return space;
				}
				return intermidiateSpace;
			}

		}

		return null;
	}
	public Map<DelimeterImpl, Delimeter> getDelimiterIntsatanceToDefinition() {
		return delimiterIntsatanceToDefinition;
	}
	public void setDelimiterIntsatanceToDefinition(Map<DelimeterImpl, Delimeter> delimiterIntsatanceToDefinition) {
		this.delimiterIntsatanceToDefinition = delimiterIntsatanceToDefinition;
	}
	public ChainOfResponsabilityController getChainModel() {
		return chainModel;
	}
	public void setChainModel(ChainOfResponsabilityController chainModel) {
		this.chainModel = chainModel;
	}
	public void clear() {
		root=null;
		intsatanceToDefinition.clear();
		delimiterIntsatanceToDefinition.clear();
		
	}
	public boolean isDelimeterReferencesSelected(param.Delimeter del) {
		if(getChainModel()!=null
				&&getChainModel().getDelimiterContraints()!=null
				&&getChainModel().getDelimiterContraints().getEntry(del)!=null) {
			EList<MechanicDesign> designs=getChainModel().getDelimiterContraints().getEntry(del).getDelimieterContraints();
			if(designs!=null) {
				for(MechanicDesign design:designs) {
					DesignObject3D obj=getIntsatanceToDefinition().get(design);
						if(obj!=null) {
							if(obj.isSelected()) {
								return true;
							}
						}
				}
			}
		}
		
		return false;
	}
}
