package api.ui;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.swt.widgets.Composite;

import api.provider.ModelInfo;
import api.provider.ModelProvider;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Table;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;

public class ModelLibrary  extends Composite{

	private List<ModelInfo> modelInfos = new ArrayList<ModelInfo>();
	private Table table;
	private TableViewer tableViewer;
	
	private ModelInfo selection;
	
	
	public ModelLibrary(Composite parent, int style) {
		super(parent, style);
		setLayout(new FillLayout(SWT.HORIZONTAL));
		
		tableViewer = new TableViewer(this, SWT.BORDER | SWT.FULL_SELECTION);
		table = tableViewer.getTable();
		createControl();
	}

	private void createControl() {
		modelInfos.addAll(ModelProvider.getProvider().getModelInfos());
		TableViewerColumn imageColumn = new TableViewerColumn(tableViewer, SWT.NONE);
		ColumnLabelProvider labelProvider = new ColumnLabelProvider() {
			@Override
			public Image getImage(Object element) {
				if(element instanceof ModelInfo) {
					ModelInfo info = (ModelInfo) element;
					Image image = new Image(getDisplay(), info.getImagePath());
					ImageData imgData = image.getImageData().scaledTo(160, 120);
					image.dispose();
					return new Image(getDisplay(), imgData);
				}
				return super.getImage(element);
			}

			@Override
			public String getText(Object element) {
				return null;
			}
		};
		imageColumn.setLabelProvider(labelProvider);
		imageColumn.getColumn().setWidth(160);
		TableViewerColumn descriptionColumn = new TableViewerColumn(tableViewer, SWT.NONE);
		descriptionColumn.setLabelProvider(new ColumnLabelProvider() {

			@Override
			public String getText(Object element) {
				if(element instanceof ModelInfo) {
					ModelInfo info = (ModelInfo) element;
					return info.getLabel();
				}
				return super.getText(element);
			}
			
		});
		descriptionColumn.getColumn().setWidth(100);
		tableViewer.setContentProvider(ArrayContentProvider.getInstance());
		tableViewer.setInput(modelInfos.toArray());
		table.setLinesVisible(true);
		table.setHeaderVisible(false);
		tableViewer.addSelectionChangedListener(event -> {
            IStructuredSelection selection = tableViewer.getStructuredSelection();
            this.selection = (ModelInfo) selection.getFirstElement();
		});
		
		//create drag source
		DragSource dragSrc = new DragSource(table, DND.DROP_COPY | DND.DROP_MOVE);
		dragSrc.setTransfer(TextTransfer.getInstance());
		dragSrc.addDragListener(new DragSourceListener() {
			
			@Override
			public void dragStart(DragSourceEvent event) {
					event.doit = selection != null;
			}
			
			@Override
			public void dragSetData(DragSourceEvent event) {
				event.data = selection.getName();
			}
			
			@Override
			public void dragFinished(DragSourceEvent event) {
				
			}
		});
		
		
	}

}
