/*
 * Decompiled with CFR 0.152.
 */
package org.frs.resources.downloder;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JOptionPane;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import org.frs.resources.downloder.DownloadRule;

public class FileInstaller {
    public static void installFiles(List<DownloadRule> rules, List<File> localFiles, Consumer<Integer> onProgress) {
        int progress = 0;
        for (DownloadRule rule : rules) {
            String fileName = rule.getFileName();
            if (fileName.endsWith(".sha")) {
                System.out.println("Ignor\u00e9 (fichier .sha) : " + fileName);
                onProgress.accept(++progress);
                continue;
            }
            File sourceFile = FileInstaller.findSourceFile(fileName, localFiles);
            if (sourceFile == null) {
                sourceFile = new File(System.getProperty("user.dir") + File.separator + "resources" + File.separator + fileName);
            }
            if (sourceFile.exists()) {
                try {
                    FileInstaller.processFile(sourceFile, rule);
                    System.out.println("Installation r\u00e9ussie: " + fileName + " vers " + rule.getInstallPath());
                }
                catch (IOException e) {
                    System.err.println("Erreur d'installation pour " + fileName + ": " + e.getMessage());
                    e.printStackTrace();
                }
            } else {
                System.err.println("Fichier introuvable: " + fileName + " (Recherch\u00e9 dans: " + sourceFile.getAbsolutePath() + ")");
            }
            onProgress.accept(++progress);
        }
    }

    private static File findSourceFile(String fileName, List<File> localFiles) {
        for (File file : localFiles) {
            if (!file.getName().equals(fileName)) continue;
            return file;
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    private static void processFile(File sourceFile, DownloadRule rule) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[6] lbl38 : CaseStatement: default:\u000a, @NONE, blocks:[6] lbl38 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static File getUniqueFileName(File file) {
        File uniqueFile;
        if (!file.exists()) {
            return file;
        }
        String baseName = file.getName();
        String extension = "";
        int dotIndex = baseName.lastIndexOf(46);
        if (dotIndex > 0) {
            extension = baseName.substring(dotIndex);
            baseName = baseName.substring(0, dotIndex);
        }
        int counter = 1;
        do {
            uniqueFile = new File(file.getParent(), baseName + " (" + counter + ")" + extension);
            ++counter;
        } while (uniqueFile.exists());
        return uniqueFile;
    }

    public static void copyFile(File source, File dest) throws IOException {
        if (!source.exists()) {
            throw new IOException("Fichier source inexistant: " + source.getPath());
        }
        File parent = dest.getParentFile();
        if (parent != null && !parent.exists()) {
            parent.mkdirs();
        }
        Files.copy(source.toPath(), dest.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
        if (!dest.exists() || dest.length() != source.length()) {
            throw new IOException("\u00c9chec de la copie du fichier: " + source.getName());
        }
    }

    public static void extractArchive(File archive, String destPath) throws IOException {
        String fileName = archive.getName().toLowerCase();
        if (!fileName.endsWith(".zip")) {
            throw new IOException("Format d'archive non support\u00e9: " + fileName);
        }
        FileInstaller.extractZip(archive, destPath);
    }

    private static void extractZip(File zipFile, String destPath) throws IOException {
        try {
            ZipFile zip = new ZipFile(zipFile);
            if (zip.isEncrypted()) {
                JOptionPane.showMessageDialog(null, "Le fichier ZIP est prot\u00e9g\u00e9 par mot de passe et ne peut pas \u00eatre extrait.", "Fichier prot\u00e9g\u00e9", 2);
                return;
            }
            zip.extractAll(destPath);
        }
        catch (ZipException e) {
            throw new IOException("Erreur d'extraction ZIP: " + e.getMessage(), e);
        }
    }
}

