/*
 * Decompiled with CFR 0.152.
 */
package org.frs.cryptool.api.keys;

import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import org.frs.cryptool.api.keys.KeyPairGen;
import org.frs.supercad.config.IFileResolver;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={KeyVault.class})
public class KeyVault {
    private RSAPrivateKey productKey;
    private RSAPublicKey serverKey;
    @Reference
    private IFileResolver fileResolver;

    @Activate
    public void loadKeys() {
        String publicPath = "resources/public.pem";
        String secretPath = "resources/private.key";
        try {
            byte[] serverKeyData = Files.readAllBytes(this.fileResolver.findFile("org.frs.cryptool", publicPath));
            this.serverKey = (RSAPublicKey)KeyPairGen.loadKey(serverKeyData, KeyPairGen.KeyType.PUBLIC);
            byte[] secretKeyData = Files.readAllBytes(this.fileResolver.findFile("org.frs.cryptool", secretPath));
            this.productKey = (RSAPrivateKey)KeyPairGen.loadKey(secretKeyData, KeyPairGen.KeyType.PRIVATE);
        }
        catch (IOException | URISyntaxException e) {
            e.printStackTrace();
        }
    }

    public RSAPrivateKey getProductKey() throws Exception {
        if (this.productKey == null) {
            throw new Exception("product key not found!");
        }
        return this.productKey;
    }

    public RSAPublicKey getServerKey() throws Exception {
        if (this.serverKey == null) {
            throw new Exception("server key not found!");
        }
        return this.serverKey;
    }
}

