/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal;

import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.internal.services.ResourceBundleHelper;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.core.services.nls.ILocaleChangeService;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimmedWindow;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.osgi.service.log.LogService;

public class LocaleChangeServiceImpl
implements ILocaleChangeService {
    MApplication application;
    @Inject
    IEventBroker broker;
    @Inject
    @Optional
    LogService logService;

    @Inject
    public LocaleChangeServiceImpl(MApplication application) {
        this.application = application;
    }

    public void changeApplicationLocale(Locale locale) {
        this.application.getContext().set("org.eclipse.e4.core.locale", (Object)locale);
        this.updateLocalization(this.application.getChildren());
        this.broker.post("org/eclipse/e4/core/NLS/LOCALE_CHANGE", (Object)locale);
    }

    public void changeApplicationLocale(String localeString) {
        block2: {
            try {
                Locale locale = ResourceBundleHelper.toLocale((String)localeString);
                this.application.getContext().set("org.eclipse.e4.core.locale", (Object)locale);
                this.updateLocalization(this.application.getChildren());
                this.broker.post("org/eclipse/e4/core/NLS/LOCALE_CHANGE", (Object)locale);
            }
            catch (Exception e) {
                if (this.logService == null) break block2;
                this.logService.log(1, e.getMessage() + " - No Locale change will be performed.");
            }
        }
    }

    protected void updateLocalization(List<? extends MUIElement> children) {
        for (MUIElement mUIElement : children) {
            MPart mPart;
            MToolBar toolbar;
            if (mUIElement instanceof MElementContainer) {
                this.updateLocalization(((MElementContainer)mUIElement).getChildren());
            }
            if (mUIElement instanceof MWindow) {
                MWindow window = (MWindow)mUIElement;
                MMenu mainMenu = window.getMainMenu();
                if (mainMenu != null) {
                    mainMenu.updateLocalization();
                    this.updateLocalization(mainMenu.getChildren());
                }
                this.updateLocalization(window.getSharedElements());
                this.updateLocalization(window.getWindows());
            }
            if (mUIElement instanceof MTrimmedWindow) {
                for (MTrimBar trimBar : ((MTrimmedWindow)mUIElement).getTrimBars()) {
                    trimBar.updateLocalization();
                    this.updateLocalization(trimBar.getChildren());
                }
            }
            if (mUIElement instanceof MPerspective) {
                this.updateLocalization(((MPerspective)mUIElement).getWindows());
            }
            if (mUIElement instanceof MPart && (toolbar = (mPart = (MPart)mUIElement).getToolbar()) != null && toolbar.getChildren() != null) {
                toolbar.updateLocalization();
                this.updateLocalization(toolbar.getChildren());
            }
            mUIElement.updateLocalization();
        }
    }
}

