package dressing.ui.caisson;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

import gdxapp.object3d.KitchenElement;

public class ElementFacadeConfigWindow {

	private KitchenElement element;
	private Shell shell;
	private ListFacadesSettingCmp facadeSettingComposite;

	public ElementFacadeConfigWindow(KitchenElement element) {
		this.element = element;
		int style = SWT.APPLICATION_MODAL | SWT.CLOSE | SWT.MAX | SWT.TITLE | SWT.RESIZE;
		shell = new Shell(Display.getDefault(), style);
		shell.setText(element.getMechanicDesign().getName());
		createControl();
	}
	
	private void createControl() {
		shell.setSize(600, 510);
		shell.setLayout(new FillLayout(SWT.HORIZONTAL));
		Composite mainContainer = new Composite(shell, SWT.NONE);
		mainContainer.setLayout(new GridLayout(1, false));
		
		Composite editingComposite = new Composite(mainContainer, SWT.NONE);
		editingComposite.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		editingComposite.setLayout(new FillLayout());
		
		Composite buttonComposite = new Composite(mainContainer, SWT.NONE);
		buttonComposite.setLayout(new GridLayout(2, false));
		buttonComposite.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, true, false, 1, 1));
		
		facadeSettingComposite = new ListFacadesSettingCmp(editingComposite, element);
		facadeSettingComposite.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
		
		createButtons(buttonComposite);
	}
	
	private void createButtons(Composite parent) {
		Button btnAnnuler = new Button(parent, SWT.NONE);
		btnAnnuler.setText("Annuler");
		Button btnModifier = new Button(parent, SWT.NONE);
		btnModifier.setText("Modifier");
		btnModifier.addListener(SWT.MouseDown, event -> {
			facadeSettingComposite.applySetting();
			close();
		});
		btnAnnuler.addListener(SWT.MouseDown, event -> close());
	}

	public void open() {
		shell.open();
	}
	
	public void close() {
		shell.dispose();
	}
}
