package dressing.handlers.pieces2d;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;

import javax.inject.Inject;

import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

import dressing.cam.model.DXFFileManager;
import dressing.handlers.AddUsinageTrou;
import dressing.model.DesignObject3D;
import dressing.model.Kitchen;
import dressing.model.ProjectManager;
import dressing.model.Space3DFree;
import dressing.model.SuperCadProject;

public class DxfExportHandler {
@Inject ESelectionService selectionService;
	
	@Inject
	IEclipseContext  eclipsecontext;
	@Execute
	public void execute(Shell shell, ParameterizedCommand command){
		Preferences preferences = InstanceScope.INSTANCE.getNode("com.dressing");
		Preferences projectpref = preferences.node("SuperCadProject");
		String defaultpath=projectpref.get("SaveAsdirectory", System.getProperty("user.home") + File.separator + "Desktop");
		String dirpath = projectpref.get("directoryWrite", defaultpath);
		Object selected=null;
		if(command.getParameterMap().get("dressing.commandparameter.context")!=null)
		{
			String persp = (String) command.getParameterMap().get("dressing.commandparameter.context");
			if(persp!=null&& persp.contentEquals("global")) {
				SuperCadProject project=ProjectManager.getManager().getCurrentProject();
				selected=project;			
			}
		}
		if(selected==null) {
			Object o = selectionService.getSelection("dressing.part.projectexplorer");
			if(o!=null && (o instanceof Kitchen || o instanceof SuperCadProject|| o instanceof Space3DFree)) {
				selected =o;
			}
		}
		final Object target=selected;
		FileDialog dialog = new FileDialog(shell,SWT.SAVE);
		dialog.setFilterPath(dirpath);
		dialog.setFileName("DXF");
		String filepath = dialog.open();
		if (filepath != null && !filepath.isEmpty() && target !=null) {
			WorkspaceModifyOperation operation =	new WorkspaceModifyOperation() {
				// This is the method that gets invoked when the operation runs.
				//
				@Override
				public void execute(IProgressMonitor monitor) {
					// Save the resources to the file system.
					try {
						 DXFFileManager manager = new DXFFileManager(".DXF");
						 if(target instanceof Kitchen) {
							 manager.saveKitchenDXF(filepath,(Kitchen)target);
						 }else
							 if(target instanceof SuperCadProject) {
							 manager.saveSuperCadProjectDXF(filepath,(SuperCadProject)target);
						 }else
							 if(target instanceof Space3DFree) {
								 try {
									 AddUsinageTrou.createdesignsUsinage((DesignObject3D) target,false,true);
									((Space3DFree) target).refresh();
								 } catch (Exception e) {
									e.printStackTrace();
								 }
								manager.createDxfFolder(filepath,(Space3DFree)target,1);
						 }
					} catch (Exception e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}
					//save file path to preference for future use
					File file = new File(filepath);
					String dirpath = file.getParent();
					 projectpref.put("directoryWrite", dirpath);
					 try {
						projectpref.flush();
					 } catch (BackingStoreException e) {
						e.printStackTrace();
					 }
					//open saved file
					try {
						Desktop.getDesktop().open(file);
					} catch (IOException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}
				}
			};
			try {
				// This runs the options, and shows progress.
				//
				new ProgressMonitorDialog(shell).run(true, false, operation);

			}
			catch (Exception exception) {
				// Something went wrong that shouldn't.
				//
				exception.printStackTrace();
			}	
			
		
		}

	}
	@CanExecute
	public boolean check(ParameterizedCommand command)
	{
		if(command.getParameterMap().get("dressing.commandparameter.context")!=null)
		{
			String persp = (String) command.getParameterMap().get("dressing.commandparameter.context");
			if(persp!=null&& persp.contentEquals("global")) {
				SuperCadProject project=ProjectManager.getManager().getCurrentProject();
				if(project !=null) {
					return true;
				}
			}
		}
		Object o = selectionService.getSelection("dressing.part.projectexplorer");
		if(o!=null && (o instanceof Kitchen || o instanceof SuperCadProject|| o instanceof Space3DFree)) {
			return true;
		}
		
		return false;
	}

}
