/*
 * Decompiled with CFR 0.152.
 */
package api.graphics.geometry;

import api.graphics.geometry.Edge;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class Triangle {
    private Vector3f v0;
    private Vector3f v1;
    private Vector3f v2;
    private Vector3f normal;
    public Matrix4f transform = new Matrix4f();
    public Matrix4f inverseTransform = new Matrix4f();

    public Triangle(Vector3f v0, Vector3f v1, Vector3f v2) {
        this.v0 = v0;
        this.v1 = v1;
        this.v2 = v2;
    }

    public Triangle(Vector3f v0, Vector3f v1, Vector3f v2, Matrix4f transform) {
        this.v0 = v0;
        this.v1 = v1;
        this.v2 = v2;
        this.transform.set((Matrix4fc)transform);
        this.transform.invert(this.inverseTransform);
    }

    public boolean contains(Vector3f point) {
        Vector3f v10 = new Vector3f((Vector3fc)this.v1).sub((Vector3fc)this.v0);
        Vector3f v20 = new Vector3f((Vector3fc)this.v2).sub((Vector3fc)this.v0);
        this.normal = new Vector3f((Vector3fc)v10).cross((Vector3fc)v20).normalize();
        float tolerance = (float)Math.cos(Math.toRadians(88.0));
        Vector3f vector3f = new Vector3f((Vector3fc)point);
        if (Math.abs(vector3f.sub((Vector3fc)this.v0).normalize().dot((Vector3fc)this.normal)) > tolerance) {
            return false;
        }
        tolerance *= 4.0f;
        Vector2f v = null;
        try {
            v = this.toBarycentricCoords(point);
        }
        catch (Exception exception) {
            return false;
        }
        if (v.x < -tolerance || v.y < -tolerance) {
            return false;
        }
        return !(v.x + v.y - tolerance > 1.0f);
    }

    public Vector2f toBarycentricCoords(Vector3f point) {
        Vector3f v10 = new Vector3f((Vector3fc)this.v1).sub((Vector3fc)this.v0);
        Vector3f v20 = new Vector3f((Vector3fc)this.v2).sub((Vector3fc)this.v0);
        Vector3f p = new Vector3f((Vector3fc)point).sub((Vector3fc)this.v0);
        float thresh = (float)Math.sin(Math.toRadians(3.0));
        Vector3f vector3f = new Vector3f((Vector3fc)v10);
        if (vector3f.cross((Vector3fc)v20).length() / (v10.length() * v20.length()) < thresh) {
            throw new IllegalArgumentException("The triangle is degenerate (area is zero).");
        }
        Matrix3f base = new Matrix3f((Vector3fc)new Vector3f((Vector3fc)v10), (Vector3fc)new Vector3f((Vector3fc)v20), (Vector3fc)this.getNormal()).invert();
        Vector3f localCoords = new Vector3f((Vector3fc)p).mul((Matrix3fc)base);
        return new Vector2f(localCoords.x, localCoords.y);
    }

    public void calculateNormal() {
        Vector3f v10 = new Vector3f((Vector3fc)this.v1).sub((Vector3fc)this.v0);
        Vector3f v20 = new Vector3f((Vector3fc)this.v2).sub((Vector3fc)this.v0);
        this.normal = new Vector3f((Vector3fc)v10).cross((Vector3fc)v20).normalize();
    }

    public Vector3f getNormal() {
        if (this.normal == null) {
            this.calculateNormal();
        }
        return this.normal;
    }

    public Edge[] getEdges() {
        return new Edge[]{new Edge(this.v0, this.v1), new Edge(this.v1, this.v2), new Edge(this.v2, this.v0)};
    }

    public Vector3f getV0() {
        return this.v0;
    }

    public void setV0(Vector3f v0) {
        this.v0 = v0;
    }

    public Vector3f getV1() {
        return this.v1;
    }

    public void setV1(Vector3f v1) {
        this.v1 = v1;
    }

    public Vector3f getV2() {
        return this.v2;
    }

    public void setV2(Vector3f v2) {
        this.v2 = v2;
    }

    public String toString() {
        return "Triangle [v0=" + String.valueOf(this.v0) + ", v1=" + String.valueOf(this.v1) + ", v2=" + String.valueOf(this.v2) + ", normal=" + String.valueOf(this.normal) + "]";
    }

    public static void main(String ... args) {
        Vector3f v0 = new Vector3f();
        Vector3f v1 = new Vector3f(0.0f, 0.0f, 1.0f);
        Vector3f v2 = new Vector3f(1.0f, 0.0f, 1.0f);
        Triangle t0 = new Triangle(v0, v1, v2);
        Vector3f point = new Vector3f(0.42f, 0.001f, 0.5f);
        boolean in = t0.contains(point);
        System.out.println(in);
    }

    public Vector3f getTransformedNormal() {
        Vector4f normal4 = new Vector4f((Vector3fc)this.getNormal(), 0.0f).mul((Matrix4fc)this.transform);
        return new Vector3f(normal4.x, normal4.y, this.normal.z).normalize();
    }

    public Vector3f[] getCorners() {
        return new Vector3f[]{this.v0, this.v1, this.v2};
    }
}

