/*
 * Decompiled with CFR 0.152.
 */
package param;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Direction implements Enumerator
{
    XPLUS(0, "XPLUS", "XPLUS"),
    XMINUS(1, "XMINUS", "XMINUS"),
    YPLUS(2, "YPLUS", "YPLUS"),
    YMINUS(3, "YMINUS", "YMINUS"),
    ZPLUS(4, "ZPLUS", "ZPLUS"),
    ZMINUS(5, "ZMINUS", "ZMINUS");

    public static final int XPLUS_VALUE = 0;
    public static final int XMINUS_VALUE = 1;
    public static final int YPLUS_VALUE = 2;
    public static final int YMINUS_VALUE = 3;
    public static final int ZPLUS_VALUE = 4;
    public static final int ZMINUS_VALUE = 5;
    private static final Direction[] VALUES_ARRAY;
    public static final List<Direction> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Direction[]{XPLUS, XMINUS, YPLUS, YMINUS, ZPLUS, ZMINUS};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Direction get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Direction result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Direction getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Direction result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Direction get(int value) {
        switch (value) {
            case 0: {
                return XPLUS;
            }
            case 1: {
                return XMINUS;
            }
            case 2: {
                return YPLUS;
            }
            case 3: {
                return YMINUS;
            }
            case 4: {
                return ZPLUS;
            }
            case 5: {
                return ZMINUS;
            }
        }
        return null;
    }

    private Direction(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

