/*
 * Decompiled with CFR 0.152.
 */
package org.frs.cryptool.api.ui;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.frs.cryptool.api.keys.KeyPairGen;

public class KeyGenTool
extends Composite {
    private int keySize;
    private Text txtPublic;
    private Text txtPrivate;

    public KeyGenTool(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(3, false));
        this.createContent();
    }

    private void createContent() {
        Label lblKeySize = new Label((Composite)this, 0);
        lblKeySize.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblKeySize.setText("Taille de Cl\u00e9");
        final Combo combo = new Combo((Composite)this, 0);
        final String[] options = new String[]{"2048", "3072", "4096"};
        combo.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        combo.setItems(options);
        combo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int selection = combo.getSelectionIndex();
                if (selection >= 0) {
                    String size = options[selection];
                    KeyGenTool.this.keySize = Integer.parseInt(size);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button btnGnrer = new Button((Composite)this, 0);
        btnGnrer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                KeyGenTool.this.generatePair();
            }
        });
        btnGnrer.setText("G\u00e9n\u00e9rer");
        Composite composite = new Composite((Composite)this, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        Group grpClPublic = new Group(composite, 0);
        grpClPublic.setLayout((Layout)new GridLayout(1, false));
        grpClPublic.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        grpClPublic.setText("Cl\u00e9 Public");
        this.txtPublic = new Text((Composite)grpClPublic, 2562);
        this.txtPublic.setBackground(new Color(250, 250, 250));
        this.txtPublic.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.txtPublic.setBounds(0, 0, 78, 26);
        Group grpClPriv = new Group(composite, 0);
        grpClPriv.setLayout((Layout)new GridLayout(1, false));
        grpClPriv.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        grpClPriv.setText("Cl\u00e9 Priv\u00e9");
        this.txtPrivate = new Text((Composite)grpClPriv, 2562);
        this.txtPrivate.setBackground(new Color(250, 250, 250));
        this.txtPrivate.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        new Label((Composite)this, 0);
        Button btnSave = new Button((Composite)this, 0);
        btnSave.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                KeyGenTool.this.saveKeys();
            }
        });
        btnSave.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false, 1, 1));
        btnSave.setText("Sauvgarder");
        new Label((Composite)this, 0);
    }

    protected void saveKeys() {
        DirectoryDialog fileDialog = new DirectoryDialog(new Shell(this.getDisplay()));
        String dir = fileDialog.open();
        if (dir != null) {
            File folder = new File(dir);
            File prv = new File(folder, "private.pem");
            File pub = new File(folder, "public.pem");
            try {
                prv.createNewFile();
                BufferedOutputStream bw = new BufferedOutputStream(new FileOutputStream(prv));
                bw.write(this.txtPrivate.getText().getBytes());
                bw.close();
                pub.createNewFile();
                bw = new BufferedOutputStream(new FileOutputStream(pub));
                bw.write(this.txtPublic.getText().getBytes());
                bw.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected void generatePair() {
        KeyPairGen keyGen = new KeyPairGen();
        try {
            KeyPair pair = keyGen.genNewPair(this.keySize);
            String privateString = keyGen.saveKeyToPEM("PRIVATE KEY", pair.getPrivate().getEncoded());
            this.txtPrivate.setText(privateString);
            String publicString = keyGen.saveKeyToPEM("PUBLIC KEY", pair.getPublic().getEncoded());
            this.txtPublic.setText(publicString);
        }
        catch (IOException | NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
    }
}

