package dressing.ui.design.PublicParam;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

import param.MechanicDesign;
import param.MechanicPublicParam;
import param.PublicParamGroup;

public class PublicParamGroupComposite extends Composite {

	private MechanicDesign design;
	private PublicParamGroup paramGroup;
	private int Nb_COLUMN=3;
	
	/**
	 * @wbp.parser.constructor
	 */
	public PublicParamGroupComposite(PublicParamGroup paramGroup,int Nb_COLUMN ,Composite parent, int style) {
		super(parent, style);
		this.Nb_COLUMN= Nb_COLUMN;
		this.paramGroup = paramGroup;
		CreateContents();
	}
	
	public PublicParamGroupComposite(PublicParamGroup paramGroup,Composite parent, int style) {
		super(parent,  SWT.V_SCROLL| SWT.H_SCROLL);
		this.paramGroup = paramGroup;
		CreateContents();
	}
	public void CreateContents() {
		setLayout(new GridLayout(Nb_COLUMN, true));
		GridData gd_text = new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1);

		for(MechanicPublicParam param:paramGroup.getMechanicpublicparam()) {
			PublicParamComposite paramEditor  = new PublicParamComposite(param,this, SWT.BORDER);
		}
	}

	public PublicParamGroup getParamGroup() {
		return paramGroup;
	}

	public void setParamGroup(PublicParamGroup paramGroup) {
		this.paramGroup = paramGroup;
	}

}
