package dressing.model.persistence.dpos;

import java.util.UUID;

import com.badlogic.gdx.math.Vector3;

import gdxapp.object3d.GolaProfile;
import gdxapp.shaders.PbrMaterial;

public class GolaProfileDPO implements DPO<GolaProfile>{
	
	
	private float thickness;
	private UUID modelId;
	private String name;
	private float price;
	private PbrMaterial material;
	private Vector3 dimension;
	private int rotation;
	private int[] relativePosition;
	private String previewPath;


	@Override
	public DPO<GolaProfile> from(GolaProfile entity) {
		setThickness(entity.getThickness());
		setModelId(entity.getModelId());
		setName(entity.getName());
		setMaterial(entity.getMaterial());
		setPrice(entity.getPrice());
		setDimension(entity.getDimension());
		setRelativePosition(entity.getRelativePosition());
		setPreviewPath(entity.getPreviewPath());
		setRotation(entity.getRotation());
		return this;
	}

	@Override
	public GolaProfile get() {
		GolaProfile profile = new GolaProfile();
		profile.setThickness(thickness);
		profile.setModelId(modelId);
		profile.setName(name);
		profile.setPrice(price);
		profile.setMaterial(material);
		profile.setDimension(dimension);
		profile.setRotation(rotation);
		profile.setRelativePosition(relativePosition[0], relativePosition[1]);
		profile.setPreviewPath(previewPath);
		return profile;
	}

	public float getThickness() {
		return thickness;
	}

	public void setThickness(float thickness) {
		this.thickness = thickness;
	}

	public UUID getModelId() {
		return modelId;
	}

	public void setModelId(UUID modelId) {
		this.modelId = modelId;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public float getPrice() {
		return price;
	}

	public void setPrice(float price) {
		this.price = price;
	}

	public PbrMaterial getMaterial() {
		return material;
	}

	public void setMaterial(PbrMaterial material) {
		this.material = material;
	}

	public Vector3 getDimension() {
		return dimension;
	}

	public void setDimension(Vector3 dimension) {
		this.dimension = dimension;
	}

	public int getRotation() {
		return rotation;
	}

	public void setRotation(int rotation) {
		this.rotation = rotation;
	}

	public int[] getRelativePosition() {
		return relativePosition;
	}

	public void setRelativePosition(int[] relativePosition) {
		this.relativePosition = relativePosition;
	}

	public String getPreviewPath() {
		return previewPath;
	}

	public void setPreviewPath(String previewPath) {
		this.previewPath = previewPath;
	}

	
	
}
