/*
 * Decompiled with CFR 0.152.
 */
package org.frs.cryptool.internal;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.frs.cryptool.api.security.client.Authentication;
import org.frs.cryptool.api.security.client.EnterLicenseDialog;
import org.frs.cryptool.api.security.client.IAuthenticationService;
import org.frs.supercad.config.ConfigurationManager;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={AuthenticationClient.class}, immediate=true)
public class AuthenticationClient {
    @Reference
    private IAuthenticationService authService;
    @Reference
    private ConfigurationManager configMannager;
    @Reference
    private EnterLicenseDialog licenseDialog;

    @Activate
    public void run() throws Exception {
        String licenseFile = this.configMannager.getProperty("LICENSE_PATH");
        File file = new File(licenseFile);
        if (!file.exists()) {
            this.licenseDialog.open();
            this.run();
        } else {
            byte[] licenseData = Files.readAllBytes(Paths.get(file.getAbsolutePath(), new String[0]));
            String license = new String(licenseData);
            this.authService.authenticate(license);
            Authentication auth = this.authService.getAuthentication();
            if (auth == null || !auth.isValid()) {
                throw new RuntimeException("invalid license!");
            }
        }
    }
}

