/*
 * Decompiled with CFR 0.152.
 */
package org.frs.cryptool.api.keys;

import java.io.IOException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import org.frs.cryptool.api.keys.KeyPairGen;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;

@Component(service={KeyVault.class})
public class KeyVault {
    private RSAPrivateKey productKey;
    private RSAPublicKey serverKey;

    @Activate
    public void loadKeys() {
        String publicPath = "src\\resources\\public.pem";
        String secretPath = "src\\resources\\private.key";
        try {
            byte[] serverKeyData = this.getClass().getClassLoader().getResourceAsStream(publicPath).readAllBytes();
            this.serverKey = (RSAPublicKey)KeyPairGen.loadKey(serverKeyData, KeyPairGen.KeyType.PUBLIC);
            byte[] secretKeyData = this.getClass().getClassLoader().getResourceAsStream(secretPath).readAllBytes();
            this.productKey = (RSAPrivateKey)KeyPairGen.loadKey(secretKeyData, KeyPairGen.KeyType.PRIVATE);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public RSAPrivateKey getProductKey() throws Exception {
        if (this.productKey == null) {
            throw new Exception("product key not found!");
        }
        return this.productKey;
    }

    public RSAPublicKey getServerKey() throws Exception {
        if (this.serverKey == null) {
            throw new Exception("server key not found!");
        }
        return this.serverKey;
    }
}

