package reporting.htmlReporting;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;

import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

import com.kotcrab.vis.ui.widget.file.FileUtils;

import dressing.model.SuperCadProject;

abstract public class ReportHtmlGenerator {

	public File generate(SuperCadProject project, String filepath) {

		FileOutputStream fosFace = null;
		File file = new File(filepath);
		Writer out=null;
		try {
			String htmlFile = getHtmlFileTemplate();
			String title=getReportTitle();
//			System.err.println(htmlFile);
			htmlFile =htmlFile.replace("@reportTitle@", title);
//			System.err.println(htmlFile);
			String body=generateDocumentBody(project);
			htmlFile =htmlFile.replace("@body@",body );
			if (!file.exists()) {
				file.getParentFile().mkdirs();
				file.createNewFile();
			}
//			fosFace = new FileOutputStream(file, false);
			Paths.get(file.getAbsolutePath());
			out = Files.newBufferedWriter(Paths.get(file.getAbsolutePath()), StandardCharsets.UTF_8);
			out.write(htmlFile);
//			fosFace.write(htmlFile.getBytes());
		} catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} finally {
			try {
				out.close();
			} catch (IOException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			}
		}

		return file;
	}

	protected abstract String getReportTitle();

	protected abstract String generateDocumentBody(SuperCadProject project);
	protected abstract String generateReportHeader(SuperCadProject project);
	protected abstract String generateReportFooter(SuperCadProject project);
	protected abstract String generateReportLastPageFooter(SuperCadProject project);

	protected String getTemplate(String template) {
		String content = "";
		try {
			Bundle bundle = Platform.getBundle("Dressing");
			URL url = FileLocator.find(bundle, new Path(template), null);
			String path = FileLocator.toFileURL(url).getPath();
			File file = new File(path);
//			content = new String(Files.readAllBytes(Paths.get(file.getPath())));
			BufferedReader reader=Files.newBufferedReader(Paths.get(file.getPath()), StandardCharsets.UTF_8);
			String line=""; 
			while((line = reader.readLine()) != null) {
				content+=line+"\n";
			}
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return content;
	}

	protected String getTableTemplate() {
		return getTemplate("src/reporting/htmlReporting/templates/table.txt");
	}

	protected String getPageBreakTemplate() {
		return getTemplate("src/reporting/htmlReporting/templates/pageBreak.txt");
	}

	protected String getHtmlFileTemplate() {
		return getTemplate("src/reporting/htmlReporting/templates/htmlfile.txt");

	}

}
