package reporting.data.handle;

import java.util.ArrayList;
import java.util.List;

import dressing.model.DesignObject3D;
import dressing.model.Piece2D;
import dressing.model.ui.util.CommonStringExtractor;
import tech.frsdev.solids.Solide3D;

public class PieceCoupe {
	
	List<Piece2D> pieces=new ArrayList<Piece2D>();
	String name;
	private double pieceL;
	private double pieceH;
	private String material;
	private int qty=1;
	private double epaisseur;

	public PieceCoupe(String name,Piece2D piece) {
		super();
		this.name = name;
		this.pieceL = piece.getPieceL();
		this.pieceH = piece.getPieceH();
		this.material = piece.getMaterial().getName();
		this.epaisseur=piece.getEpaisseur();
		this.pieces.add(piece);
	}
	public List<Piece2D> getPieces() {
		return pieces;
	}
	public void setPieces(List<Piece2D> pieces) {
		this.pieces = pieces;
	}
	public String getName() {
		return name;
	}
	public String getcompactedName() {
		List<String[]> nameparts=new ArrayList<String[]>();
		if(pieces.size()>1) {
			for(Solide3D piece:pieces) {
				nameparts.add(((DesignObject3D) piece).getName().split(" "));
			}
			String[] compactedArray=CommonStringExtractor.extractCommonStrings(nameparts);
			String compoactedname=compactedArray.length>0?String.join(" ",compactedArray ):name;
			System.err.println("compoactedname :"+compoactedname+pieces);
			return compoactedname;
			
		}else {
			System.err.println("compoacte  dname :"+name+pieces);
			return name;
		}
	}
	public void setName(String name) {
		this.name = name;
	}
	public double getPieceL() {
		return pieceL;
	}
	public void setPieceL(double pieceL) {
		this.pieceL = pieceL;
	}
	public double getPieceH() {
		return pieceH;
	}
	public void setPieceH(double pieceH) {
		this.pieceH = pieceH;
	}
	public String getMaterial() {
		return material;
	}
	public void setMaterial(String material) {
		this.material = material;
	}
	public int getQty() {
		return qty;
	}
	public void setQty(int qty) {
		this.qty = qty;
	}
	
	public double getEpaisseur() {
		return epaisseur;
	}
	public void setEpaisseur(double epaisseur) {
		this.epaisseur = epaisseur;
	}
	public boolean contains(Piece2D piece) {
		if(pieces.contains(piece)|| 
				(piece.getPieceL()==getPieceL() 
					&&piece.getPieceH()==getPieceH() 
					&&piece.getEpaisseur()==getEpaisseur()
					&&piece.getMaterial().getName().contentEquals(getMaterial()))) {
			return true;
		}
		return false;
	}
	public void addPiece(Piece2D piece) {
		this.qty+=1;
		this.pieces.add(piece);
	}
	
}
