package gdxapp.assets;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;

public class SDFFont extends BitmapFont {
	
	private final String vertexCode = "uniform mat4 u_projTrans;\r\n" + 
			"\r\n" + 
			"attribute vec4 a_position;\r\n" + 
			"attribute vec2 a_texCoord0;\r\n" + 
			"attribute vec4 a_color;\r\n" + 
			"\r\n" + 
			"varying vec4 v_color;\r\n" + 
			"varying vec2 v_texCoord;\r\n" + 
			"\r\n" + 
			"void main() {\r\n" + 
			"    gl_Position = u_projTrans * a_position;\r\n" + 
			"    v_texCoord = a_texCoord0;\r\n" + 
			"    v_color = a_color;\r\n" + 
			"}\r\n";
	
	private final String fragCode = "#ifdef GL_ES\r\n" + 
			"precision mediump float;\r\n" + 
			"#endif\r\n" + 
			"\r\n" + 
			"uniform sampler2D u_texture;\r\n" + 
			"\r\n" + 
			"varying vec4 v_color;\r\n" + 
			"varying vec2 v_texCoord;\r\n" + 
			"\r\n" + 
			"const float smoothing = 1.0/16.0;\r\n" + 
			"\r\n" + 
			"void main() {\r\n" + 
			"    float distance = texture2D(u_texture, v_texCoord).a;\r\n" + 
			"    float alpha = smoothstep(0.5 - smoothing, 0.5 + smoothing, distance);\r\n" + 
			"    gl_FragColor = vec4(v_color.rgb, v_color.a * alpha);\r\n" + 
			"}\r\n";
	
	ShaderProgram program;
	
	
	public SDFFont(FileHandle fileHandle, TextureRegion textureRegion, boolean flip) {
		super(fileHandle, textureRegion, flip);
		compileShader();
	}
	
	private void compileShader() {
		program = new ShaderProgram(vertexCode, fragCode);
		if (!program.isCompiled()) {
		    Gdx.app.error("fontShader", "compilation failed:\n" + program.getLog());
		}
	}
	
	
	public void draw (Batch batch, CharSequence str, float x, float y, float targetWidth, int halign, boolean wrap, Color color) {
		//save the current state
		ShaderProgram preprogram = batch.getShader();
		Color precolor = batch.getColor();
		//apply setting and draw
		setColor(color);
		batch.setShader(this.program);
		super.draw(batch, str, x, y, targetWidth, halign, wrap);
		//restore the initial state
		batch.setShader(preprogram);
		setColor(precolor);
	}
	
	
	
	
	

}
