package dressing.ui.space3dfree;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ComboBoxViewerCellEditor;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.nebula.jface.tablecomboviewer.TableComboViewer;
import org.eclipse.nebula.widgets.tablecombo.TableCombo;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

import dressing.config.persistence.ResourceManagers;
import dressing.model.DesignException;
import dressing.model.IUpdateStructure;
import dressing.model.ModelProvider;
import dressing.model.Space3DFree;
import dressing.ui.util.SingleImageItemLabelProvider;
import param.MechanicDesign;
import param.MechanicPublicParam;
import param.PublicParamGroup;
import param.TypeDefElement;
import param.impl.MaterialGroupImpl;
import param.impl.MechanicDesignImpl;
import param.impl.MechanicPublicParamImpl;
import org.eclipse.core.databinding.beans.typed.BeanProperties;

public class MechanicDesignEditor extends Composite implements IUpdateStructure{
	
	public static String[] material_coulmns=new String[] { "Texture","Epaisseur" };
	
	private DataBindingContext m_bindingContext;
	private Text text;
	private Table table;
	Space3DFree space;
	MechanicDesign mechanicDesign;
	PublicParamGroup publicparams;
	MaterialGroupImpl materials;
	private TableViewer tableViewer;
	private TableViewerColumn tableViewerColumn;
	private TableViewerColumn tableViewerColumn_1;
	private TableComboViewer tableComboViewer_Base;
	private MDirtyable dirty;
	private TableComboViewer tableComboViewer_backMat;
	private TableComboViewer tableComboViewer_faceMat;

	MechanicPublicParam longeur;
	MechanicPublicParam hauteur;
	MechanicPublicParam profondeur;
	MechanicPublicParam ep;
	MechanicPublicParam epback;
	IEventBroker eventBroker;
	private Spinner spinner;
	private Spinner spinner_1;
	private Spinner spinner_2;
	PropertyChangeListener listener;
	TableViewerColumn tableViewerColumn_2;
	Composite composite_2;
	public MechanicDesignEditor(Composite parent, int style,Space3DFree design) {
		this(parent, SWT.H_SCROLL | SWT.V_SCROLL);
		this.space=design;
		init();
	}
	private void init() {
		this.mechanicDesign=(MechanicDesign) this.space.getMechanicDesignDefinition();
		this.materials=(MaterialGroupImpl) ModelProvider.getModelroot().getMaterialgroup();
		this.publicparams=mechanicDesign.getPublicparamgroup();
		try {
			longeur=this.publicparams.getParam("global.l");
			hauteur=this.publicparams.getParam("global.h");
			profondeur=this.publicparams.getParam("global.p");
			ep=this.publicparams.getParam("global.ep");
			epback=this.publicparams.getParam("global.epback");
		}catch(Exception e) {
			e.printStackTrace();
		}
		

		 listener=new PropertyChangeListener() {
			
			@Override
			public void propertyChange(PropertyChangeEvent evt) {
				int value=0;
				try {
					value=Integer.parseInt((String) evt.getNewValue());

				}catch (NumberFormatException e) {
					value=0;
				}
				if(evt.getSource().equals(longeur)) {
					spinner.setSelection(value);
				}else if(evt.getSource().equals(hauteur)) {
					spinner_1.setSelection(value);
				}else if(evt.getSource().equals(profondeur)) {
					spinner_2.setSelection(value);
				}
			}
		};
		longeur.addPropertyChangeListener(listener);
		hauteur.addPropertyChangeListener(listener);
		profondeur.addPropertyChangeListener(listener);
		spinner.setSelection(Integer.parseInt(longeur.getDefaultvalue()));
		spinner_1.setSelection(Integer.parseInt( hauteur.getDefaultvalue()));
		spinner_2.setSelection(Integer.parseInt( profondeur.getDefaultvalue()));

		this.spinner.addModifyListener(new ModifyListener() {
			
			@Override
			public void modifyText(ModifyEvent e) {
				longeur.setDefaultvalue(spinner.getText());	
				
			}
		});
		this.spinner_1.addModifyListener(new ModifyListener() {
			
			@Override
			public void modifyText(ModifyEvent e) {
				hauteur.setDefaultvalue(spinner_1.getText());	
				
			}
		});
		this.spinner_2.addModifyListener(new ModifyListener() {
			
			@Override
			public void modifyText(ModifyEvent e) {
				profondeur.setDefaultvalue(spinner_2.getText());	
				
			}
		});
		if(space!=null) {
			if (m_bindingContext != null) {
				m_bindingContext.dispose();
				m_bindingContext = null;
			}
			m_bindingContext = initDataBindings();
		}
		
		tableViewer.setContentProvider(ArrayContentProvider.getInstance());
		tableViewerColumn.setLabelProvider(new ColumnLabelProvider() {
		    @Override
		    public String getText(Object element) {
		    	MechanicPublicParamImpl p = (MechanicPublicParamImpl) element;
		        return p.getUserlabel();
		    }
		});
		tableViewerColumn_1.setLabelProvider(new ColumnLabelProvider() {
		    @Override
		    public String getText(Object element) {
		    	MechanicPublicParamImpl p = (MechanicPublicParamImpl) element;
		    	p.addPropertyChangeListener(new PropertyChangeListener() {
					
					@Override
					public void propertyChange(PropertyChangeEvent evt) {					
						tableViewer.update(element, null);
					}
				});
		        return p.getDefaultvalue();
		    }
		});
		tableViewerColumn_1.setEditingSupport(new PublicParamValueEditingSupport(tableViewer));
		
		tableViewerColumn_2.setLabelProvider(new ColumnLabelProvider() {
		    @Override
		    public String getText(Object element) {
		    	MechanicPublicParamImpl p = (MechanicPublicParamImpl) element;
		    	if(p.getTypedefelement()==null) {
		    		return "";
		    	}
		        return p.getTypedefelement().getName();
		    }
		});
		tableViewerColumn_2.setEditingSupport(new PublicParamTypeEditingSupport(tableViewer));
		
		tableViewer.setInput(((MechanicDesignImpl)space.getMechanicDesignDefinition()).getPublicparamgroup().getMechanicpublicparam());
		// set the content provider
		tableComboViewer_Base.setContentProvider(ArrayContentProvider.getInstance());

		// set the label provider
		tableComboViewer_Base.setLabelProvider(SingleImageItemLabelProvider.getInstance());
		tableComboViewer_Base.setInput(this.materials.getMaterial());
		// set the content provider
		tableComboViewer_backMat.setContentProvider(ArrayContentProvider.getInstance());

		// set the label provider
		tableComboViewer_backMat.setLabelProvider(SingleImageItemLabelProvider.getInstance());
		tableComboViewer_backMat.setInput(this.materials.getMaterial());

		
		// set the content provider
		tableComboViewer_faceMat.setContentProvider(ArrayContentProvider.getInstance());

		// set the label provider
		tableComboViewer_faceMat.setLabelProvider(SingleImageItemLabelProvider.getInstance());
		tableComboViewer_faceMat.setInput(this.materials.getMaterial());
		
		ControlAdapter cal= new ControlAdapter() {
			
		    public void controlResized(ControlEvent e) {
		    	
		      Rectangle area = MechanicDesignEditor.this.getClientArea();
		      Point preferredSize = table.computeSize(SWT.DEFAULT, SWT.DEFAULT);
		      int width = area.width - 2*table.getBorderWidth();
		      if (preferredSize.y > area.width + table.getHeaderHeight()) {
		        // Subtract the scrollbar width from the total column width
		        // if a vertical scrollbar will be required
		       
		      }
		      Point vBarSize = table.getVerticalBar().getSize();
		        width -= vBarSize.x;
		      Point oldSize = table.getSize();
		      if (oldSize.x > area.width) {
		        // table is getting smaller so make the columns 
		        // smaller first and then resize the table to
		        // match the client area width
		    	  tableViewerColumn.getColumn().setWidth(width/3-2*table.getBorderWidth());
		    	  tableViewerColumn_1.getColumn().setWidth(width/3-2*table.getBorderWidth());
		    	  tableViewerColumn_2.getColumn().setWidth(width/3-2*table.getBorderWidth());
		        table.setSize(area.width, area.height-30);
		      } else {
		        // table is getting bigger so make the table 
		        // bigger first and then make the columns wider
		        // to match the client area width
		        table.setSize(area.width, area.height-30);
		        tableViewerColumn.getColumn().setWidth(width/3-2*table.getBorderWidth());
		    	tableViewerColumn_1.getColumn().setWidth(width/3-2*table.getBorderWidth());
		    	tableViewerColumn_2.getColumn().setWidth(width/3-2*table.getBorderWidth());

		      }
		    }};
		
		  
		this.addControlListener(cal);
		table.addControlListener(cal);
		table.setHeaderVisible(true);
		table.setLinesVisible(true);
		tableViewer.refresh();
		if (m_bindingContext != null) {
			m_bindingContext.dispose();
			m_bindingContext = null;
		}
		if(space!=null) {		
			m_bindingContext = initDataBindings();
		}
	}
	/**
	 * Create the composite.
	 * @param parent
	 * @param style
	 */
	public MechanicDesignEditor(Composite parent, int style) {
		super(parent, SWT.NONE);
		setLayout(new FillLayout(SWT.HORIZONTAL));
		
		Composite composite_1 = new Composite(this, SWT.NONE);
		composite_1.setLayout(new GridLayout(2, false));
		
		Label lblName = new Label(composite_1, SWT.WRAP);
		lblName.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblName.setText("Name:");
		
		text = new Text(composite_1, SWT.BORDER | SWT.WRAP);
		text.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		TabFolder tabFolder = new TabFolder(composite_1, SWT.NONE);
		tabFolder.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, true, 2, 1));
		
		TabItem tbtmMesures = new TabItem(tabFolder, SWT.NONE);
		tbtmMesures.setText("Mesures");
		
		Composite composite = new Composite(tabFolder, SWT.NONE);
		tbtmMesures.setControl(composite);
		composite.setLayout(new GridLayout(2, false));
		
		Label lblLongeur = new Label(composite, SWT.NONE);
		lblLongeur.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblLongeur.setText("Longeur");
		
		spinner = new Spinner(composite, SWT.BORDER | SWT.WRAP);
		spinner.setTextLimit(3000000);
		spinner.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		spinner.setFont(SWTResourceManager.getFont("Segoe UI", 10, SWT.NORMAL));
		spinner.setMaximum(1000000000);
		spinner.setMinimum(0);
		spinner.setSelection(500);
		spinner.setIncrement(1);
		spinner.setPageIncrement(1);
		Label lblHauteur = new Label(composite, SWT.NONE);
		lblHauteur.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblHauteur.setText("Hauteur");
		
		spinner_1 = new Spinner(composite, SWT.BORDER | SWT.WRAP);
		spinner_1.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		spinner_1.setFont(SWTResourceManager.getFont("Segoe UI", 10, SWT.NORMAL));
		spinner_1.setMaximum(100000000);
		spinner_1.setMinimum(0);
		spinner_1.setSelection(500);
		spinner_1.setIncrement(1);
		spinner_1.setPageIncrement(1);
		Label lblProfondeur = new Label(composite, SWT.NONE);
		lblProfondeur.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblProfondeur.setText("Profondeur");
		
		spinner_2 = new Spinner(composite, SWT.BORDER | SWT.WRAP);
		spinner_2.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		spinner_2.setFont(SWTResourceManager.getFont("Segoe UI", 10, SWT.NORMAL));
		spinner_2.setMaximum(1000000000);
		spinner_2.setMinimum(0);
		spinner_2.setSelection(500);
		spinner_2.setIncrement(1);
		spinner_2.setPageIncrement(1);
		TabItem tbtmMaterial = new TabItem(tabFolder, SWT.NONE);
		tbtmMaterial.setText("Material");
		
		 composite_2 = new Composite(tabFolder, SWT.NONE);
		tbtmMaterial.setControl(composite_2);
		composite_2.setLayout(new GridLayout(2, false));
		//
		Label lblBaseMaterial = new Label(composite_2, SWT.NONE);
		lblBaseMaterial.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblBaseMaterial.setText("Base Material");
		
		tableComboViewer_Base = new TableComboViewer(composite_2, SWT.READ_ONLY | SWT.BORDER);
		TableCombo tableCombo = tableComboViewer_Base.getTableCombo();
		tableCombo.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		tableCombo.setShowTableHeader(true);
		tableCombo.defineColumns(material_coulmns);
		tableCombo.getTextControl().setFont(SWTResourceManager.getFont("Segoe UI", 10, SWT.NORMAL));
		tableCombo.setEditable(false);
		//
		Label lblFaceMaterial = new Label(composite_2, SWT.NONE);
		lblFaceMaterial.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblFaceMaterial.setText("Facade Material");
		
		tableComboViewer_faceMat = new TableComboViewer(composite_2, SWT.READ_ONLY | SWT.BORDER);
		TableCombo tableCombo_faceMat = tableComboViewer_faceMat.getTableCombo();
		tableCombo_faceMat.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		tableCombo_faceMat.setShowTableHeader(true);
		tableCombo_faceMat.defineColumns(material_coulmns);
		tableCombo_faceMat.getTextControl().setFont(SWTResourceManager.getFont("Segoe UI", 10, SWT.NORMAL));
		tableCombo_faceMat.setEditable(false);
		//
		Label lblBackmaterial = new Label(composite_2, SWT.NONE);
		lblBackmaterial.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblBackmaterial.setText("Back material");
		
		tableComboViewer_backMat = new TableComboViewer(composite_2,  SWT.READ_ONLY | SWT.BORDER);
		TableCombo tableCombo_1 = tableComboViewer_backMat.getTableCombo();
		tableCombo_1.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		tableCombo_1.setShowTableHeader(true);
		tableCombo_1.defineColumns(material_coulmns);
		tableCombo_1.getTextControl().setFont(SWTResourceManager.getFont("Segoe UI", 10, SWT.NORMAL));
		// do not allow editable
		tableCombo_1.setEditable(false);
		// set the content provider
		tableComboViewer_backMat.setContentProvider(ArrayContentProvider.getInstance());

		// set the label provider
		tableComboViewer_backMat.setLabelProvider(SingleImageItemLabelProvider.getInstance());
		tableComboViewer_backMat.setInput(ResourceManagers.getIntance().getMaterials());
		
		//
		TabItem tbtmGlobalParams = new TabItem(tabFolder, SWT.NONE);
		tbtmGlobalParams.setText("Global params");
		
		Composite composite_3 = new Composite(tabFolder, SWT.NONE);
		tbtmGlobalParams.setControl(composite_3);
		composite_3.setLayout(new FillLayout(SWT.HORIZONTAL));
		
		tableViewer = new TableViewer(composite_3,  SWT.BORDER | SWT.FULL_SELECTION|SWT.FILL);
		table = tableViewer.getTable();
		table.setLinesVisible(true);
		table.setHeaderVisible(true);
		
		tableViewerColumn = new TableViewerColumn(tableViewer, SWT.NONE|SWT.FILL);
		TableColumn tblclmnName = tableViewerColumn.getColumn();
		tblclmnName.setWidth(100);
		tblclmnName.setText("Name");
		tblclmnName.setResizable(true);
		tableViewerColumn_1 = new TableViewerColumn(tableViewer, SWT.NONE|SWT.FILL);
		TableColumn tblclmnValue = tableViewerColumn_1.getColumn();
		tblclmnValue.setWidth(100);
		tblclmnValue.setText("Value");
		tblclmnValue.setResizable(true);
		
		tableViewerColumn_2 = new TableViewerColumn(tableViewer, SWT.NONE);
		TableColumn tblclmnType = tableViewerColumn_2.getColumn();
		tblclmnType.setWidth(100);
		tblclmnType.setText("Type");

		composite_1.setTabList(new Control[]{text, tabFolder});
		
		makedirtycontroller(this);
		if (space != null) {
			if (m_bindingContext != null) {
				m_bindingContext.dispose();
				m_bindingContext = null;
			}
			m_bindingContext = initDataBindings();
		}
	}

	@Override
	protected void checkSubclass() {
		// Disable the check that prevents subclassing of SWT components
	}

	@Override
	public void run() throws DesignException {
		m_bindingContext.updateModels();
		
		try {
			//ProgressBarMonitor.addtask();
			this.space.update();
			eventBroker.send("PREVIEW_MODEL", this.space);
			//ProgressBarMonitor.removetask();
		} catch (Exception e) {
			MessageBox dialog = new MessageBox(this.getShell(), SWT.ICON_ERROR | SWT.OK | SWT.CANCEL);
			dialog.setText("Error");
			dialog.setMessage("un erreur est servenue lors de mise à jour du model à cause de :" + e.getMessage());

			// open dialog and await user selection
			int returnCode = dialog.open();
			e.printStackTrace();
		}
		
	}

	@Override
	public void cancel() {
		m_bindingContext.updateTargets();
		
	}
	protected void makedirtycontroller(Composite comp)
	{
		//Faire la mise ajour des controel pour qui enregistre le dirty
				for(Control ctr :  comp.getChildren())
				{
					if(ctr instanceof Text)
					{
						((Text) ctr).addKeyListener(new KeyListener() {
							
							@Override
							public void keyReleased(KeyEvent e) {
								// TODO Auto-generated method stub
								updateDirty();
							}
							
							@Override
							public void keyPressed(KeyEvent e) {
								// TODO Auto-generated method stub
								
							}
						});
					}
					else
					{
						ctr.addListener(SWT.Selection, event->updateDirty());//Pour les spinner et les chekbox labada expresseion
					}
					if(ctr instanceof Composite)
					{
						makedirtycontroller((Composite)ctr);
					}
					if(ctr instanceof Spinner)
					{
						ctr.addListener(SWT.Selection, event->updateCaretposition(ctr));
					}
				}
	}
	//Pour corriger le Bug de spinner que selctionne tous apres chaque saisie
	private void updateCaretposition(Control ctr)
	{
		Event ke = new Event();
        ke.type = SWT.MENU_KEYBOARD;
        ke.keyCode = SWT.ARROW_RIGHT;
        ctr.getDisplay().post(ke);
	}
	public void setDirty(MDirtyable dirty) {
		this.dirty = dirty;
	}
	public MDirtyable getDirty() {
		return dirty;
	}
	public void updateDirty()
	{
		if(this.dirty!=null)
		{
			this.dirty.setDirty(true);
		}
	}
	
	public IEventBroker getEventBroker() {
		return eventBroker;
	}
	public void setEventBroker(IEventBroker eventBroker) {
		this.eventBroker = eventBroker;
	}
	@Override
	public void dispose() {
		this.longeur.removePropertyChangeListener(listener);
		this.hauteur.removePropertyChangeListener(listener);
		this.profondeur.removePropertyChangeListener(listener);
		m_bindingContext.dispose();
		super.dispose();
	}
	protected DataBindingContext initDataBindings() {
		DataBindingContext bindingContext = new DataBindingContext();
		//
		IObservableValue observeSingleSelectionTableComboViewer_1 = ViewerProperties.singleSelection().observe(tableComboViewer_backMat);
		IObservableValue secondmaterialMechanicDesignObserveValue = BeanProperties.value("secondmaterial").observe(mechanicDesign);
		bindingContext.bindValue(observeSingleSelectionTableComboViewer_1, secondmaterialMechanicDesignObserveValue, null, null);
		//
		IObservableValue observeSingleSelectionTableComboViewer = ViewerProperties.singleSelection().observe(tableComboViewer_Base);
		IObservableValue principalmaterialMechanicDesignObserveValue = BeanProperties.value("principalmaterial").observe(mechanicDesign);
		bindingContext.bindValue(observeSingleSelectionTableComboViewer, principalmaterialMechanicDesignObserveValue, null, null);
		//
		IObservableValue observeTextTextObserveWidget = WidgetProperties.text(SWT.Modify).observe(text);
		IObservableValue nameMechanicDesignObserveValue = BeanProperties.value("name").observe(mechanicDesign);
		bindingContext.bindValue(observeTextTextObserveWidget, nameMechanicDesignObserveValue, null, null);
		//
		IObservableValue observeSingleSelectionTableComboViewer_faceMat = ViewerProperties.singleSelection().observe(tableComboViewer_faceMat);
		IObservableValue facadeMaterialMechanicDesignObserveValue = BeanProperties.value("facadeMaterial").observe(mechanicDesign);
		bindingContext.bindValue(observeSingleSelectionTableComboViewer_faceMat, facadeMaterialMechanicDesignObserveValue, null, null);
		//
		return bindingContext;
	}
}
 class PublicParamValueEditingSupport extends EditingSupport {

    private final TableViewer viewer;
    private final CellEditor editor;

    public PublicParamValueEditingSupport(TableViewer viewer) {
        super(viewer);
        this.viewer = viewer;
        this.editor = new TextCellEditor(viewer.getTable());
    }

    @Override
    protected CellEditor getCellEditor(Object element) {
        return editor;
    }

    @Override
    protected boolean canEdit(Object element) {
    	MechanicPublicParamImpl param=((MechanicPublicParamImpl) element);
    	if(!param.isChangeable()) {
    		return false;
    	}
    	if(param.getDefaultvalue()==null) {
    		 return false;
    	}
    	if(param.getKey().contentEquals("global.ep")||param.getKey().contentEquals("global.epback")){
    		return false;
    	}
		return true;

    }

    @Override
    protected Object getValue(Object element) {
    	return ((MechanicPublicParamImpl) element).getDefaultvalue();
    }

    @Override
    protected void setValue(Object element, Object userInputValue) {
        ((MechanicPublicParamImpl) element).setDefaultvalue((String) userInputValue);
        viewer.update(element, null);
    }
}
 class PublicParamTypeEditingSupport extends EditingSupport {

	    private final TableViewer viewer;
	    private final CellEditor editor;
	    LabelProvider  TydefElementlabelProvider= new LabelProvider() {
		    @Override
		    public String getText(Object element) {
		        if (element instanceof TypeDefElement) {
		        	TypeDefElement  person = (TypeDefElement ) element;
		            return person.getName();
		        }
		        return super.getText(element);
		    }
		};
	    public PublicParamTypeEditingSupport(TableViewer viewer) {
	        super(viewer);
	        this.viewer = viewer;
	        this.editor = new ComboBoxViewerCellEditor(viewer.getTable());
	    }

	    @Override
	    protected CellEditor getCellEditor(Object element) {
	    	MechanicPublicParamImpl param=((MechanicPublicParamImpl) element);
	    	ComboViewer combo=((ComboBoxViewerCellEditor)editor).getViewer();
	    	if(param.getTypedef()!=null&& param.getTypedefelement()!=null) {
	    		combo.getCCombo().setEditable(false);
	    		combo.setContentProvider(ArrayContentProvider.getInstance());
	    		combo.setLabelProvider(TydefElementlabelProvider);
	    		combo.setInput(param.getTypedef().getTypedefelement());

	    	}
	        return editor;
	    }

	    @Override
	    protected boolean canEdit(Object element) {
	    	MechanicPublicParamImpl param=((MechanicPublicParamImpl) element);
	    	if(!param.isChangeable()) {
	    		return false;
	    	}
	    	if(param.getTypedef()==null|| param.getTypedefelement()==null) {
	    		return false;
	    	}
			return true;

	    }

	    @Override
	    protected Object getValue(Object element) {
	    	MechanicPublicParamImpl param=((MechanicPublicParamImpl) element);

	    	return param.getTypedefelement();
	    }

	    @Override
	    protected void setValue(Object element, Object userInputValue) {
	    	MechanicPublicParamImpl param=((MechanicPublicParamImpl) element);
	    	param.setTypedefelement((TypeDefElement) userInputValue);
	        viewer.update(element, null);
	    }
	}

