package dressing.model.persistence.dpos;

import gdxapp.object3d.GeometryObject;
import gdxapp.object3d.PlinthObject;
import geometry.CompoundObject;
import jakarta.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="Plinth")
public class PlinthDPO implements DPO<PlinthObject>{

	private CompoundObject geometry;
	private float[] color;
	private float thickness;
	private float height;
	

	
	public PlinthDPO() {
		super();
	}
	
	
	@Override
	public DPO<PlinthObject> from(PlinthObject entity) {
		setGeometry(entity.getGeometry());
		setThickness(entity.getThickness());
		setHeight(entity.getHeight());
		return this;
	}

	@Override
	public PlinthObject get() {
		PlinthObject plinth = new PlinthObject(geometry);
		plinth.setThickness(thickness);
		plinth.setHeight(height);
		return plinth;
	}

	public float[] getColor() {
		return color;
	}

	public void setColor(float[] color) {
		this.color = color;
	}

	public float getThickness() {
		return thickness;
	}

	public void setThickness(float thickness) {
		this.thickness = thickness;
	}

	public float getHeight() {
		return height;
	}

	public void setHeight(float height) {
		this.height = height;
	}


	public CompoundObject getGeometry() {
		return geometry;
	}


	public void setGeometry(CompoundObject geometry) {
		this.geometry = geometry;
	}
	
}
