package reporting.htmlReporting.model;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HtmlTableRowElement extends HtmlElement{
	Map<String,String> values=new HashMap<String, String>();
	HtmlTableElement table;
	boolean isHeader=false;
	public HtmlTableRowElement(HtmlTableElement table,boolean isheader) {
		super("tr");
		this.table=table;
		this.isHeader=isheader;
	}
	
	@Override
	public List<HtmlNode> getChildNodes() {
		return super.getChildNodes();
	}

	public Map<String, String> getValues() {
		return values;
	}

	public void setValues(Map<String, String> values) {
		this.values = values;
	}

	public HtmlTableElement getTable() {
		return table;
	}

	public void setTable(HtmlTableElement table) {
		this.table = table;
	}

	public boolean isHeader() {
		return isHeader;
	}

	public void setHeader(boolean isHeader) {
		this.isHeader = isHeader;
		for(HtmlNode cell:getChildNodes()) {
			if(cell instanceof HtmlTableCell) {
				((HtmlTableCell) cell).setName(isHeader()?"th":"td");
			}
		}
	}
	
}
