package gdxapp.fabs3d;

import java.util.ArrayList;


import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.graphics.VertexAttributes;
import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.graphics.g3d.attributes.TextureAttribute;
import com.badlogic.gdx.graphics.g3d.utils.MeshPartBuilder;
import com.badlogic.gdx.graphics.g3d.utils.ModelBuilder;
import com.badlogic.gdx.graphics.g3d.utils.MeshPartBuilder.VertexInfo;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;

import dressing.model.persistence.dpos.Object3D;
import dressing.model.persistence.dpos.WoodCoveringDPO;
import dressing.model.persistence.mappers.Persistable;
import dressing.ui.engine3d.SceneTexture;
import gdxapp.assets.AssetsTextures;
import gdxapp.object3d.ObjectModel;
import gdxapp.object3d.WorldObject;

import gdxapp.shaders.PbrMaterial;


@Persistable(persistableForm = WoodCoveringDPO.class)
public class WoodCovering extends WorldObject {
	
	private float bandWidth;
	private float extrusionWidth;
	private float extrusionDepth;
	private PbrMaterial material;
	
	public WoodCovering() {
		super();
		type = ObjectType.MODELED;
		
	}
	
	public WoodCovering(float bandWidth, float extrusionWidth, float extrusionDepth) {
		super();
		type = ObjectType.MODELED;
		this.bandWidth = bandWidth;
		this.extrusionWidth = extrusionWidth;
		this.extrusionDepth = extrusionDepth;
	}
	
	public void prepareModel() {
		ArrayList<Vector3> positions = new ArrayList<Vector3>();
		ArrayList<Vector3> normals = new ArrayList<Vector3>();
		ArrayList<Vector2> textCoords = new ArrayList<Vector2>();
		float currentX = 0;
		float[] dims = new float[] {bandWidth, extrusionWidth};
		int counter = 0;
		Vector3 v0, v1, v2, v3, v4, v5;
		Vector2 uv0, uv1, uv2, uv3, uv4, uv5;
		while(currentX <= this.realWorldDimension.x ) {
			currentX = Math.min(currentX, realWorldDimension.x);
			if(counter % 2 == 0) {
				v0 = new Vector3(currentX, realWorldDimension.y,realWorldDimension.z);
				v1 = new Vector3(v0).add(bandWidth, 0, 0);
				v2 = new Vector3(v1).sub(0, 0, extrusionDepth);
				v3 = new Vector3(v2).sub(0, realWorldDimension.y, 0);
				v4 = new Vector3(v1).sub(0, realWorldDimension.y, 0);
				v5 = new Vector3(v0).sub(0, realWorldDimension.y, 0);
				
				uv0 = new Vector2(currentX, realWorldDimension.y);
				uv1 = uv0.cpy().add(bandWidth, 0);
				uv2 = uv1.cpy().add(extrusionDepth, 0);
				uv3 = uv2.cpy().sub(0,realWorldDimension.y);
				uv4 = uv1.cpy().sub(0,realWorldDimension.y);
				uv5 = uv0.cpy().sub(0,realWorldDimension.y);

			}else {
				v0 = new Vector3(currentX, realWorldDimension.y,realWorldDimension.z - extrusionDepth);
				v1 = new Vector3(v0).add(extrusionWidth, 0, 0);
				v2 = new Vector3(v1).add(0, 0, extrusionDepth);
				v3 = new Vector3(v2).sub(0, realWorldDimension.y, 0);
				v4 = new Vector3(v1).sub(0, realWorldDimension.y, 0);
				v5 = new Vector3(v0).sub(0, realWorldDimension.y, 0);
				
				uv0 = new Vector2(currentX, realWorldDimension.y);
				uv1 = uv0.cpy().add(extrusionWidth, 0);
				uv2 = uv1.cpy().add(extrusionDepth, 0);
				uv3 = uv2.cpy().sub(0,realWorldDimension.y);
				uv4 = uv1.cpy().sub(0,realWorldDimension.y);
				uv5 = uv0.cpy().sub(0,realWorldDimension.y);
				
			}
			positions.add(v0);
			positions.add(v4);
			positions.add(v5);
			normals.add(new Vector3(0,0,1));
			normals.add(new Vector3(0,0,1));
			normals.add(new Vector3(0,0,1));				
			textCoords.add(uv0);
			textCoords.add(uv4);
			textCoords.add(uv5);

			positions.add(v0);
			positions.add(v1);
			positions.add(v4);
			normals.add(new Vector3(0,0,1));
			normals.add(new Vector3(0,0,1));
			normals.add(new Vector3(0,0,1));
			textCoords.add(uv0);
			textCoords.add(uv1);
			textCoords.add(uv4);
			
			positions.add(v1);
			positions.add(v3);
			positions.add(v4);
			normals.add(new Vector3(1,0,0));
			normals.add(new Vector3(1,0,0));
			normals.add(new Vector3(1,0,0));
			textCoords.add(uv1);
			textCoords.add(uv3);
			textCoords.add(uv4);
			
			positions.add(v1);
			positions.add(v2);
			positions.add(v3);
			normals.add(new Vector3(1,0,0));
			normals.add(new Vector3(1,0,0));
			normals.add(new Vector3(1,0,0));
			textCoords.add(uv1);
			textCoords.add(uv3);
			textCoords.add(uv4);
			currentX += dims[counter%2];
			counter++;
		}
		ModelBuilder modelBuilder = new ModelBuilder();
		int attributes = VertexAttributes.Usage.Position | VertexAttributes.Usage.Normal | VertexAttributes.Usage.TextureCoordinates;
		modelBuilder.begin();
		if(!material.isReady())
			material.prepare();
		material.remove(TextureAttribute.Normal);
		MeshPartBuilder meshPartBuilder = modelBuilder.part("covering", GL20.GL_TRIANGLES, attributes, material);
		ArrayList<VertexInfo> vertices = new ArrayList<MeshPartBuilder.VertexInfo>();
		
		for(int i = 0; i < positions.size(); i++) {
			VertexInfo vertex = new VertexInfo();
			vertex.setPos(positions.get(i));
			vertex.setNor(normals.get(i));
			vertex.setUV(textCoords.get(i));
			vertices.add(vertex);
		}
		for(int c = 0; c < vertices.size(); c += 3) {
			meshPartBuilder.triangle(vertices.get(c), vertices.get(c + 1), vertices.get(c + 2));
			meshPartBuilder.triangle(vertices.get(c), vertices.get(c + 2), vertices.get(c + 1));

		}
		
		Model model = modelBuilder.end();
		setModel(new ObjectModel(model, null));
	}

	@Override
	public Object3D toDPO() {
		return new WoodCoveringDPO(this);
	}
	
	public float getBandWidth() {
		return bandWidth;
	}

	public void setBandWidth(float bandWidth) {
		this.bandWidth = bandWidth;
	}

	public float getExtrusionWidth() {
		return extrusionWidth;
	}

	public void setExtrusionWidth(float extrusionWidth) {
		this.extrusionWidth = extrusionWidth;
	}

	public float getExtrusionDepth() {
		return extrusionDepth;
	}

	public void setExtrusionDepth(float extrusionDepth) {
		this.extrusionDepth = extrusionDepth;
	}

	public PbrMaterial getMaterial() {
		return material;
	}

	public void setMaterial(PbrMaterial material) {
		this.material = material;
	}
	
	
	
	
	
	
	
	

}
