package gdxapp.Commun;

import java.util.ArrayList;

import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Display;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.Input.Keys;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.utils.Array;

import dressing.handlers.gdx.ToolControlHandler;
import dressing.mathutils.Edge;
import dressing.mathutils.MathUtilities;
import dressing.ui.ChangeCommand;
import dressing.ui.CommandStack;
import dressing.ui.MoveCommand;
import dressing.ui.util.MeasureLineWidow;
import gdxapp.object3d.Object2D;
import gdxapp.scenes.Scene;
import gdxapp.screens.room.RoomController;
import gdxapp.screens.wall.SurfaceController;
import gdxapp.screens.wall.Wall2D;
import gdxapp.shapes.LineSegment;
import geometry.Shape;


public class Object2DMover extends Actor {
	
	public enum ActionFocus {
		START, END
	}
	private Measure tmpMeasure; 
	private MeasurerEventProcessor inputProcessor;
	private ArrayList<Vector2> measurePoints;
	private static Object2DMover measurer;
	private ActionFocus focus=ActionFocus.START; 
	public static Object2DMover getInstance() {
	 		synchronized(Object2DMover.class) {
	 			if (measurer == null) {
	 				 measurer = new Object2DMover();
	 			}
	 			return measurer;
	 		}
	 }
	private Object2DMover() {
		super();
		setWidth(Gdx.graphics.getWidth());
		setHeight(Gdx.graphics.getHeight());
		inputProcessor = new MeasurerEventProcessor(this);
		addListener(inputProcessor);
	}
	
	public void begin() {
		tmpMeasure = new Measure();
		tmpMeasure.setScale(Preferences.WORLD_WIDTH/getStage().getWidth());
		if(((AbstractScreen) Scene.game.getScreen()).getController() instanceof SurfaceController) {
			SurfaceController controller=(SurfaceController) ((AbstractScreen) Scene.game.getScreen()).getController();
			tmpMeasure.setContext(controller.getSurface());
		}
		calculateMeasurePoints();

	}
	
	public void setkeyboardFocus() {
		if (getStage() != null){
				getStage().setKeyboardFocus(this);
		}
	}
	public void move() {
		final Measure measure = tmpMeasure.copy();

		Display.getDefault().asyncExec(new Runnable() {
		    public void run() {
		    	MeasureLineWidow window = MeasureLineWidow.getInstance();
		    	window.setRunAction(new Action() {
		    		
					@Override
					public void run() {
						ArrayList<Object> selection=GroupSelection.getInstance().getSelection();
						if(selection!=null && selection.size()>0) {
							CommandStack command = new CommandStack("change from action move", "change from action move",
									new ArrayList<ChangeCommand>());
							for(Object object:selection) {
								if(object instanceof Object2D) {
									Vector3 oldPosition = ((Object2D) object).getWorldObject().getRealWorldPosition();
									Object2D object2d= ((Object2D)object);
									Vector2 pos=new Vector2(object2d.getX(), object2d.getY());
									Vector2 dir=measure.getLineSegment().getDirector().cpy();
									Vector2 dir2=new Vector2(dir.x, dir.y);
									
									pos=pos.add(dir2.scl(measure.getLineSegment().getLength()));
									object2d.setPosition(pos.x, pos.y);
									Vector3 newPosition= ((Object2D) object).getWorldObject().getRealWorldPosition();
									if (!newPosition.epsilonEquals(oldPosition, 0.001f)) {
										MoveCommand move = new MoveCommand("move " + ((Object2D) object).getWorldObject(), "move",
												oldPosition, newPosition, ((Object2D) object).getWorldObject());
										command.addCommand(move);
									}
								}
							}
							if(command.getStack()!=null && command.getStack().size()>0) {
								if (((AbstractScreen) Scene.game.getScreen()).getController().getChangeCommandController() != null) {
									((AbstractScreen) Scene.game.getScreen()).getController().getChangeCommandController().addCommand(command);
								}
							}
							
						}
					}
		    		
				});
				window.setMeasure(measure,false);
				
				window.show();
		    }
		});
		
		ToolControlHandler.getInstance().triggerSelectObject();
		tmpMeasure = null;
		focus=ActionFocus.START;
		remove();
		ToolControlHandler.getInstance().triggerSelectObject();
	}
	public void finish() {
		focus=ActionFocus.START;
		tmpMeasure = null;
		remove();
	}
	
	public void calculateMeasurePoints() {
		if(measurePoints == null)
			measurePoints = new ArrayList<Vector2>();
		measurePoints.clear();
		AbstractScreen screen = (AbstractScreen) Scene.game.getScreen();
		ScreenController controller = screen.getController();
		if(controller instanceof SurfaceController) {
			Array<Object2D>  actors=((SurfaceController) controller).getAttachedActors();
			for(Actor actor:actors) {
				if(actor instanceof Object2D) {
					Object2D object2D = (Object2D) actor;
					measurePoints.addAll(object2D.calculateAttachmentPosition());
				}
			}
			if(measurer.getTmpMeasure()!=null && measurer.getTmpMeasure().getLine()!=null && 
					measurer.getTmpMeasure().getLine().getStart()!=null) {
				measurePoints.add(new Vector2(measurer.getTmpMeasure().getLine().getStart().x, measurer.getStage().getHeight()));
				measurePoints.add(new Vector2(measurer.getTmpMeasure().getLine().getStart().x, 0));
				measurePoints.add(new Vector2(measurer.getStage().getWidth(), measurer.getTmpMeasure().getLine().getStart().y));
				measurePoints.add(new Vector2(0,  measurer.getTmpMeasure().getLine().getStart().y));

			}
		}else if(controller instanceof RoomController){
			Array<Actor> actors =new Array<Actor>();
			actors.addAll(getStage().getActors());
			for(Actor actor:actors ) {
				if(actor instanceof Object2D) {
					Object2D object2D = (Object2D) actor;
					measurePoints.addAll(object2D.calculateAttachmentPosition());
				}
				if(actor instanceof Wall2D) {
					Wall2D wall=(Wall2D) actor;
					ArrayList<Shape> edges=wall.getSides();
					for(Shape e:edges) {						
						if(e instanceof Edge ) {
							Edge edge=(Edge) e;
							measurePoints.add(edge.getV0());
							measurePoints.add(edge.getV1());
							measurePoints.add(edge.getMiddle());
						}
					}
				}
			}
		}
		
	}
	public Vector2 getNearestMeasurePoint(float x, float y) {
		AbstractScreen screen = (AbstractScreen) Scene.game.getScreen();
		ScreenController controller = screen.getController();
		if(controller instanceof SurfaceController &&measurer.getTmpMeasure()!=null && measurer.getTmpMeasure().getLine()!=null && 
				measurer.getTmpMeasure().getLine().getStart()!=null) {
			measurePoints.add(new Vector2(measurer.getTmpMeasure().getLine().getStart().x, measurer.getStage().getHeight()));
			measurePoints.add(new Vector2(measurer.getTmpMeasure().getLine().getStart().x, 0));
			measurePoints.add(new Vector2(measurer.getStage().getWidth(), measurer.getTmpMeasure().getLine().getStart().y));
			measurePoints.add(new Vector2(0,  measurer.getTmpMeasure().getLine().getStart().y));

		}
		Vector2 nearest = null;
		if(measurePoints != null && measurePoints.size()>0) {
			Vector2 point = new Vector2(x,y);
			nearest = this.measurePoints.get(0);
			for(Vector2 measurepoint: this.measurePoints) {
				if(measurepoint.dst(point) < nearest.dst(point))
					nearest = measurepoint;
			}
		}
		return nearest;
	}
	public Edge getNearestEdge(float x, float y) {
		Edge edge=null;
		float pdistance=1000000.0f;
		AbstractScreen screen = (AbstractScreen) Scene.game.getScreen();
		ScreenController controller = screen.getController();
		Array<Actor>  actors = new Array<Actor>();
		if(controller!=null) {
			if(controller instanceof SurfaceController) {
				if(((SurfaceController) controller).getAttachedActors()!=null && !((SurfaceController) controller).getAttachedActors().isEmpty())
				{
					actors.addAll(((SurfaceController) controller).getAttachedActors());
				}
			}else {
				if(getStage()!=null && getStage().getActors()!=null) {
					actors.addAll(getStage().getActors());
				}	
			}	
		}
		
		for(Actor actor: actors) {
			if(actor instanceof Object2D) {
				Object2D object2D = (Object2D) actor;
				for(Edge e:object2D.getEdges()) {
					float distance=MathUtilities.lineToPointDistance(x, y, e.getV0().x, e.getV0().y, e.getV1().x, e.getV1().y);
					if(distance<pdistance) {
						pdistance=distance;
						edge=e;
					}
				}
				
			}
			if(actor instanceof Wall2D) {
				Wall2D wall=(Wall2D) actor;
				ArrayList<Shape> edges=wall.getSides();
				for(Shape e:edges) {
					if(e instanceof Edge)
					{
						float distance=MathUtilities.lineToPointDistance(x, y, ((Edge) e).getV0().x, ((Edge) e).getV0().y, ((Edge) e).getV1().x, ((Edge) e).getV1().y);
						if(distance<pdistance) {
							pdistance=distance;
							edge=(Edge) e;
						}
					}
				}
			}
		}
		
		return edge;
	}	
	
	@Override
	public void draw(Batch batch, float parentAlpha) {
		if(tmpMeasure != null)
		{
			Vector2 end=tmpMeasure.getLine().getEnd()!=null? tmpMeasure.getLine().getEnd():tmpMeasure.getLine().getTmpVertex();
			if(tmpMeasure.getLine()!=null && tmpMeasure.getLine().getStart()!=null&& end!=null &&end.cpy().sub(tmpMeasure.getLine().getStart()).len()>0) {
				Edge e=getNearestEdge(end.x, end.y);
				if(e!=null)
				{
					float distance=MathUtilities.lineToPointDistance(end.x, end.y, e.getV0().x, e.getV0().y, e.getV1().x, e.getV1().y);
					if(distance>0.01f) {
						tmpMeasure.getLine().setTmpcolor(Color.RED);
					}
				}
				
				tmpMeasure.draw(batch, parentAlpha);
				tmpMeasure.getLine().setTmpcolor(Color.BLACK);
			}
			

		}

	}
	
	public Measure getTmpMeasure() {
		return tmpMeasure;
	}

	public void setTmpMeasure(Measure tmpMeasure) {
		this.tmpMeasure = tmpMeasure;
	}

	class MeasurerEventProcessor extends ActorInputListener{
		
		private final String TAG = MeasurerEventProcessor.class.getName();
		
		private Object2DMover measurer;
		private long lastClickDate = System.currentTimeMillis();

		public MeasurerEventProcessor(Object2DMover measurer) {
			super();
			this.measurer = measurer;
		}

		@Override
		public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {

			if(button ==  Input.Buttons.LEFT) {
				
				if(measurer.getTmpMeasure() == null )
				{
					measurer.begin();
				}
				Vector2 point = new Vector2(x,y);
				Vector2 nearestPoint=getNearestMeasurePoint(x, y);
				if( nearestPoint != null)
				{
					if(Gdx.input.isKeyPressed(Keys.SHIFT_LEFT)||Gdx.input.isKeyPressed(Keys.SHIFT_RIGHT))
					{
						point = new Vector2(nearestPoint);
					}else if(new Vector2(nearestPoint).cpy().dst(point)/measurer.getTmpMeasure().getLineSegment().getScale()[0]<0.05f) {
						point = new Vector2(nearestPoint);
					}
				}
				
				Edge e=getNearestEdge(point.x, point.y);
				if(e!=null) {
					if(Gdx.input.isKeyPressed(Keys.M)){
							Vector2 point1 =MathUtilities.getclosestPoint(point.x, point.y, e.getV0().x,  e.getV0().y,  e.getV1().x,  e.getV1().y);
							point = new Vector2(point1.x,point1.y);
					}
					else {
						float distance=MathUtilities.lineToPointDistance(point.x, point.y, e.getV0().x, e.getV0().y, e.getV1().x, e.getV1().y);
						distance/=measurer.getTmpMeasure().getLineSegment().getScale()[0];
						if(distance<0.03f ) {
							Vector2 point1 =MathUtilities.getclosestPoint(point.x, point.y, e.getV0().x,  e.getV0().y,  e.getV1().x,  e.getV1().y);
							point = new Vector2(point1.x,point1.y);
						}
					}
				}
				if(measurer.focus.equals(ActionFocus.START)) {
					measurer.getTmpMeasure().getLine().setStart(point);
					measurer.getTmpMeasure().getLine().setTmpVertex(point);
					measurer.focus=	ActionFocus.END;

				}else if(measurer.focus.equals(ActionFocus.END)) {
					float len=point.cpy().sub(tmpMeasure.getLine().getStart()).scl(tmpMeasure.getLineSegment().getScale()[0]).len();
					if(len>0.01f) {
						measurer.getTmpMeasure().getLine().setEnd(point);
					}
					measurer.move();

				}
				return true;

			}
			return false;
		}

		@Override
		public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
			
			
		}

		@Override
		public void touchDragged(InputEvent event, float x, float y, int pointer) {
			if(measurer.getTmpMeasure() != null ) {
				Vector2 point = new Vector2(x,y);
				LineSegment lineSegment = measurer.getTmpMeasure().getLineSegment();
				Vector2 nearestPoint=getNearestMeasurePoint(x, y);
				if( nearestPoint != null)
				{
					if(Gdx.input.isKeyPressed(Keys.SHIFT_LEFT)||Gdx.input.isKeyPressed(Keys.SHIFT_RIGHT))
					{
						point = nearestPoint;
					}else if(nearestPoint.cpy().dst(point)/measurer.getTmpMeasure().getLineSegment().getScale()[0]<0.05f) {
						point = nearestPoint;
					}
				}

					Edge e=getNearestEdge(point.x, point.y);
					if(e!=null) {

						if(Gdx.input.isKeyPressed(Keys.M)){
							point =MathUtilities.getclosestPoint(point.x, point.y, e.getV0().x,  e.getV0().y,  e.getV1().x,  e.getV1().y);
						}else {
							float distance=MathUtilities.lineToPointDistance(point.x, point.y, e.getV0().x, e.getV0().y, e.getV1().x, e.getV1().y);
							distance/=measurer.getTmpMeasure().getLineSegment().getScale()[0];
							if(distance<0.03f ) {
								Vector2 point1 =MathUtilities.getclosestPoint(point.x, point.y, e.getV0().x,  e.getV0().y,  e.getV1().x,  e.getV1().y);
								point = new Vector2(point1.x,point1.y);
							}
						}
					}
				if(Object2DMover.this.focus.equals(ActionFocus.END))
				{
					lineSegment.getLine().setTmpVertex(new Vector2(point));
				}
			}
		}

		@Override
		public boolean mouseMoved(InputEvent event, float x, float y) {			
			if(measurer.getTmpMeasure() != null ) {
				Vector2 point = new Vector2(x,y);
				LineSegment lineSegment = measurer.getTmpMeasure().getLineSegment();
				Vector2 nearestPoint=getNearestMeasurePoint(x, y);
				if( nearestPoint != null)
				{
					if(Gdx.input.isKeyPressed(Keys.SHIFT_LEFT)||Gdx.input.isKeyPressed(Keys.SHIFT_RIGHT))
					{
						point = nearestPoint;
					}else if(nearestPoint.cpy().dst(point)/measurer.getTmpMeasure().getLineSegment().getScale()[0]<0.05f) {
						point = nearestPoint;
					}
				}

					Edge e=getNearestEdge(point.x, point.y);
					if(e!=null) {
						if(Gdx.input.isKeyPressed(Keys.M)){
								point =MathUtilities.getclosestPoint(point.x, point.y, e.getV0().x,  e.getV0().y,  e.getV1().x,  e.getV1().y);
						}else {
							float distance=MathUtilities.lineToPointDistance(point.x, point.y, e.getV0().x, e.getV0().y, e.getV1().x, e.getV1().y);
							distance/=measurer.getTmpMeasure().getLineSegment().getScale()[0];
							if(distance<0.03f ) {
								Vector2 point1 =MathUtilities.getclosestPoint(point.x, point.y, e.getV0().x,  e.getV0().y,  e.getV1().x,  e.getV1().y);
								point = new Vector2(point1.x,point1.y);
							}
						}
					}
				
				if(Object2DMover.this.focus.equals(ActionFocus.END))
				{
					lineSegment.getLine().setTmpVertex(new Vector2(point));
				}
			}
			return true;
		}

		@Override
		public void enter(InputEvent event, float x, float y, int pointer, Actor fromActor) {
			super.enter(event, x, y, pointer, fromActor);
		}

		@Override
		public void exit(InputEvent event, float x, float y, int pointer, Actor toActor) {
			super.exit(event, x, y, pointer, toActor);
		}

		@Override
		public boolean scrolled(InputEvent event, float x, float y, int amount) {
			Gdx.app.debug(TAG, " scrolled");
			return super.scrolled(event, x, y, amount);
		}

		@Override
		public boolean keyDown(InputEvent event, int keycode) {
			Gdx.app.debug(TAG, " key down");
			return super.keyDown(event, keycode);
		}

		@Override
		public boolean keyUp(InputEvent event, int keycode) {
			Gdx.app.debug(TAG, " key up");
			if(keycode == Keys.ESCAPE)
			{
				measurer.finish();
				return true;
			}
			
			return false;
		}
		
	}

}
