package dressing.ui.components;

import java.util.Arrays;
import java.util.Set;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.nebula.jface.tablecomboviewer.TableComboViewer;
import org.eclipse.nebula.widgets.tablecombo.TableCombo;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;

import dressing.ui.engine3d.SceneTexture;
import param.BaseObject;

public class TableComboViewerSearch extends TableComboViewer {
	private static final int TIME_OUT = 150;
	private static final Set<Object> IGNORED_KEYS = Set.of(SWT.ARROW_UP, SWT.ARROW_DOWN, SWT.CR, SWT.LF, SWT.ESC,
			SWT.KEYPAD_CR);

	final int[] debounceId = { 0 };

	public TableComboViewerSearch(Composite parent, int style) {
		super(parent, style);
		initDynamicSearch();
	}

	public TableComboViewerSearch(Composite parent) {
		super(parent);
		initDynamicSearch();
	}

	public TableComboViewerSearch(TableCombo tableCombo) {
		super(tableCombo);
		initDynamicSearch();
	}

	private void initDynamicSearch() {

		TableCombo tableCombo = getTableCombo();

		tableCombo.getTextControl().addKeyListener(new KeyAdapter() {
			@Override
			public void keyReleased(KeyEvent e) {
				if (IGNORED_KEYS.contains(e.keyCode)) {
					return;
				}

				int id = ++debounceId[0];

				Display.getCurrent().timerExec(TIME_OUT, () -> {
					if (debounceId[0] == id) {

						tableCombo.getArrowControl().notifyListeners(SWT.Selection, new Event());
						String searchText = tableCombo.getText().toUpperCase();
						resetFilters();

						if (!searchText.isEmpty()) {
							addFilter(new ViewerFilter() {
								@Override
								public boolean select(Viewer viewer, Object parentElement, Object element) {

									if (element instanceof BaseObject) {
										String searchableLable = ((BaseObject) element).getSearchLabel().toUpperCase();
										String[] tokens = searchText.toUpperCase().split("\\s+");
										return Arrays.stream(tokens).allMatch(token -> searchableLable.contains(token));
									}
									if (element instanceof SceneTexture) {

										String searchableLable = ((SceneTexture) element).getPath().toUpperCase();
										String[] tokens = searchText.toUpperCase().split("\\s+");
										return Arrays.stream(tokens).allMatch(token -> searchableLable.contains(token));

									}
									return false;
								}
							});

							refresh();
							tableCombo.setVisible(true);
							tableCombo.setTableVisible(true);
							tableCombo.setVisibleItemCount(10);

						}
					}
				});
			}

		});
	}

}
