package dressing.ui;

import java.util.List;
import java.util.UUID;

import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

import dressing.config.persistence.ResourceManagers;
import dressing.model.ModelProvider;
import dressing.ui.util.EditorWindow;
import dressing.ui.util.ListEditorWindow;
import dressing.ui.util.StringViewerComparator;
import param.Chant;
import param.Finition;
import param.Fournisseur_fabricant;
import param.Material;
import param.Nature_panneaux;
import param.ParamFactory;

public class NaturePanneauxListWindow extends ListEditorWindow {

	IEventBroker eventBroker;
	public NaturePanneauxListWindow(Shell parentShell, IEventBroker eventBroker) {
		super(parentShell);
		this.eventBroker=eventBroker;
	}

	@Override
	protected Composite createClientArea(Composite parent,int style) {
		Composite clientArea = super.createClientArea(parent, style|SWT.MULTI);
		getShell().setText("Liste des Finitions");
		return clientArea;
	}
	
	public void createColums(TableViewer tableViewer) {
		
		ColumnLabelProvider nameLabelProvider=new ColumnLabelProvider() {
			public String getText(Object element) {
				if(element !=null && element instanceof Nature_panneaux ) {
					return ((Nature_panneaux)element).getName();
				}
				return "";
			}
		};
		createColumn(tableViewer, "Nom", true, null, SWT.LEFT, nameLabelProvider, new StringViewerComparator(nameLabelProvider));
		//
		ColumnLabelProvider codeLabelProvider=new ColumnLabelProvider() {
			public String getText(Object element) {
				if(element !=null && element instanceof Nature_panneaux ) {
					return ((Nature_panneaux)element).getCode();
				}
				return "";
			}
		};
		createColumn(tableViewer, "Code", true, null, SWT.LEFT, codeLabelProvider, new StringViewerComparator(codeLabelProvider));
		//
		ColumnLabelProvider descriptionLabelProvider=new ColumnLabelProvider() {
			public String getText(Object element) {
				if(element !=null && element instanceof Nature_panneaux ) {
					return ((Nature_panneaux)element).getDescription();
				}
				return "";
			}
		};
		createColumn(tableViewer, "Description", true, null, SWT.LEFT, descriptionLabelProvider, new StringViewerComparator(descriptionLabelProvider));
		//
	}
	
	@Override
	protected void Add() {
		Nature_panneaux nature=ParamFactory.eINSTANCE.createNature_panneaux();
		nature.setName("");
		NaturePanneauxEditorWindow nature_panneauxEditorWindow = new NaturePanneauxEditorWindow(shell,nature,EditorWindow.create);
		nature_panneauxEditorWindow.create();
		int ret=nature_panneauxEditorWindow.open();
		if(ret==Window.OK) {
			tableViewer.refresh();
		}
	}

	@Override
	protected void Modify() {
		IStructuredSelection selection=tableViewer.getStructuredSelection();
		if(selection!=null  && selection.getFirstElement()!=null && selection.getFirstElement() instanceof Nature_panneaux) {
			NaturePanneauxEditorWindow nature_panneauxEditorWindow = new NaturePanneauxEditorWindow(shell,(Nature_panneaux) selection.getFirstElement(),EditorWindow.update);
			nature_panneauxEditorWindow.create();
			int ret=nature_panneauxEditorWindow.open();
			if(ret==Window.OK) {
				tableViewer.refresh();
			}
		}
	}

	@Override
	protected void delete() {
		boolean ret = MessageDialog.openConfirm(shell, "Confirmation de supression","Voulez vous supprimer les composant sélectionner" );
		if(ret) {
			IStructuredSelection selection=tableViewer.getStructuredSelection();
			if(selection!=null&& !selection.isEmpty()) {
				List selections=selection.toList();
				for(Object obj:selections) {
					if(obj!=null && obj instanceof Nature_panneaux) {
						ResourceManagers.getIntance().getGestion().getNaturePanneaux().getNatures().remove(obj);
						ResourceManagers.getIntance().saveGestion();
					}
				}
				tableViewer.refresh();
			}
		}
		

	}

	@Override
	protected void view() {
		IStructuredSelection selection=tableViewer.getStructuredSelection();
		if(selection!=null  && selection.getFirstElement()!=null && selection.getFirstElement() instanceof Nature_panneaux) {
			NaturePanneauxEditorWindow nature_panneauxEditorWindow = new NaturePanneauxEditorWindow(shell,(Nature_panneaux) selection.getFirstElement(),EditorWindow.View);
			nature_panneauxEditorWindow.create();
			nature_panneauxEditorWindow.open();
			
		}

	}

	@Override
	public List<?> getInput() {
		return ResourceManagers.getIntance().getGestion().getNaturePanneaux().getNatures();
	}

	@Override
	protected ViewerFilter createListFilter() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	protected Composite createSearchArea(Composite parent, int style) {
		// TODO Auto-generated method stub
		return null;
	}

}
