package dressing.handlers;

import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

import dressing.model.DesignException;
import dressing.model.IUpdateStructure;

public class RunHandler {
	@CanExecute
	public boolean canExecute(EPartService partService) {
		if (partService != null) {
			if (partService.getDirtyParts().isEmpty()) {
				return false;

			} else {
				for (MPart part : partService.getDirtyParts()) {
					Object o = part.getObject();
					if (o != null && o instanceof IUpdateStructure) {
						return true;
					}

				}
				return false;
			}

		}
		return false;
	}

	@Execute
	public void execute(EPartService partService) {
		if(partService!=null)
		{
			MPart part  = partService.getActivePart();

			Object o = part.getObject();
			
			if(o != null &&  o instanceof IUpdateStructure)
			{
				try {
					((IUpdateStructure) o).run();
				} catch (DesignException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
			int debug =0;
			debug++;
//			partService.saveAll(false);
		}

	}
}
