package dressing.ui.composite;

import org.eclipse.swt.widgets.Composite;

import gdxapp.fabs3d.WoodCovering;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.layout.GridData;

import dressing.model.ModelProvider;
import dressing.ui.engine3d.SceneTexture;
import dressing.ui.engine3d.SceneTexture.CATEGORY;
import dressing.ui.util.ColorComposite;
import dressing.ui.util.SingleImageItemLabelProvider;

import org.eclipse.nebula.widgets.tablecombo.TableCombo;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.nebula.jface.tablecomboviewer.TableComboViewer;
import org.eclipse.wb.swt.SWTResourceManager;

import com.badlogic.gdx.math.Vector3;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;

public class WoodCoveringCreatorComposite extends Composite {

	private WoodCovering woodCovering;
		
	private Label lblPreview;
	
	public WoodCoveringCreatorComposite(Composite parent, int style, WoodCovering covering) {
		super(parent, style);
		this.woodCovering = covering;
		
		setLayout(new GridLayout(1, false));
		
		Composite composite = new Composite(this, SWT.NONE);
		composite.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		composite.setLayout(new GridLayout(1, false));
		
		Group grpDimensions = new Group(composite, SWT.NONE);
		grpDimensions.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		grpDimensions.setText("Dimensions");
		grpDimensions.setBounds(0, 0, 70, 87);
		grpDimensions.setLayout(new GridLayout(4, false));
		
		Label lblNewLabel = new Label(grpDimensions, SWT.NONE);
		lblNewLabel.setText("Longueur");
		
		Spinner spinner = new Spinner(grpDimensions, SWT.BORDER);
		spinner.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				woodCovering.getRealWorldDimension().x = spinner.getSelection()/1000.0f;
			}
		});
		spinner.setMaximum(10000);
		spinner.setMinimum(1);
		spinner.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		Label lblNewLabel_3 = new Label(grpDimensions, SWT.NONE);
		lblNewLabel_3.setText("Largeur du Bande");
		
		Spinner spnBandWidth = new Spinner(grpDimensions, SWT.BORDER);
		spnBandWidth.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				woodCovering.setBandWidth(spnBandWidth.getSelection()/1000.0f);
			}
		});
		spnBandWidth.setMaximum(10000);
		spnBandWidth.setMinimum(1);
		spnBandWidth.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		Label lblNewLabel_1 = new Label(grpDimensions, SWT.NONE);
		lblNewLabel_1.setText("Hauteur");
		
		Spinner spnHeight = new Spinner(grpDimensions, SWT.BORDER);
		spnHeight.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				woodCovering.getRealWorldDimension().y = spnHeight.getSelection() / 1000.0f;
			}
		});
		spnHeight.setMaximum(10000);
		spnHeight.setMinimum(1);
		spnHeight.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		Label lblNewLabel_4 = new Label(grpDimensions, SWT.NONE);
		lblNewLabel_4.setText("Entre Distance");
		
		Spinner spnInterDst = new Spinner(grpDimensions, SWT.BORDER);
		spnInterDst.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				woodCovering.setExtrusionWidth(spnInterDst.getSelection() / 1000.0f);
			}
		});
		spnInterDst.setMaximum(10000);
		spnInterDst.setMinimum(1);
		spnInterDst.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		Label lblNewLabel_2 = new Label(grpDimensions, SWT.NONE);
		lblNewLabel_2.setText("Profondeur");
		
		Spinner spnDepth = new Spinner(grpDimensions, SWT.BORDER);
		spnDepth.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				woodCovering.getRealWorldDimension().z = spnDepth.getSelection() / 1000.0f;
			}
		});
		spnDepth.setMaximum(10000);
		spnDepth.setMinimum(1);
		spnDepth.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		Label lblNewLabel_5 = new Label(grpDimensions, SWT.NONE);
		lblNewLabel_5.setText("Fond");
		
		Spinner spnExtrusionDepth = new Spinner(grpDimensions, SWT.BORDER);
		spnExtrusionDepth.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				woodCovering.setExtrusionDepth(spnExtrusionDepth.getSelection() / 1000.0f);
			}
		});
		spnExtrusionDepth.setMaximum(10000);
		spnExtrusionDepth.setMinimum(1);
		spnExtrusionDepth.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		Group grpApparence = new Group(composite, SWT.NONE);
		grpApparence.setLayout(new GridLayout(1, false));
		grpApparence.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		grpApparence.setText("Apparence");
		grpApparence.setBounds(0, 0, 70, 87);
		
		Composite composite_1 = new Composite(grpApparence, SWT.NONE);
		composite_1.setLayout(new GridLayout(2, true));
		composite_1.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		Label lblTexture = new Label(composite_1, SWT.NONE);
		lblTexture.setFont(SWTResourceManager.getFont("Segoe UI", 10, SWT.NORMAL));
		lblTexture.setText("Texture");
		
		TableComboViewer tableComboViewer = new TableComboViewer(composite_1, SWT.NONE);
		TableCombo tableCombo = tableComboViewer.getTableCombo();
		tableComboViewer.addSelectionChangedListener(new ISelectionChangedListener() {
			public void selectionChanged(SelectionChangedEvent event) {
				SceneTexture texture = (SceneTexture) tableComboViewer.getStructuredSelection().getFirstElement();
				displayImage(texture);
				woodCovering.getMaterial().setAlbedoMapPath(texture.getPath());
				woodCovering.getProperties().setProperty("top-texture", texture.getPath());
				woodCovering.getProperties().setProperty("front-texture", texture.getPath());

			}
		});
		tableCombo.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		tableCombo.defineColumns(1);
		tableComboViewer.setContentProvider(ArrayContentProvider.getInstance());
		tableComboViewer.setLabelProvider(SingleImageItemLabelProvider.getInstance());
		tableComboViewer.setInput(ModelProvider.getTextures(CATEGORY.ELEMENT));
		
		
		Composite composite_2 = new Composite(grpApparence, SWT.NONE);
		composite_2.setLayout(new GridLayout(1, false));
		composite_2.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, true, 1, 1));
		
		lblPreview = new Label(composite_2, SWT.NONE);
		lblPreview.setFont(SWTResourceManager.getFont("Segoe UI Semibold", 9, SWT.ITALIC));
		GridData gd_lblPreview = new GridData(SWT.CENTER, SWT.CENTER, true, true, 1, 1);
		gd_lblPreview.heightHint = 240;
		gd_lblPreview.widthHint = 240;
		lblPreview.setLayoutData(gd_lblPreview);
		
		
	}
	
	private void displayImage(SceneTexture texture) {
		lblPreview.setImage(texture.getPreview());
	}
	

}
