package dressing.ui;

import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import dressing.config.persistence.ResourceManagers;
import dressing.ui.util.DoubleToStringConvertor;
import dressing.ui.util.EditorWindow;
import dressing.ui.util.NumericConvertor;
import param.PanelSize;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.beans.typed.PojoProperties;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;

public class PanneauxEditorWindow extends EditorWindow {
	private PanelSize eppaisseur;
	private PanelSize eppaisseurOrigin;
	Composite parentComposite;
	private Composite clientArea;
	private Text txtName;
	private Text txtWidth;
	private Label lblLargeur;
	private Text txtLargeur;
	private Button btnGnrer;

	public PanneauxEditorWindow(Shell parentShell,PanelSize frs,int update) {
		super(parentShell,update);	
		this.eppaisseur=frs;
		this.eppaisseurOrigin=EcoreUtil.copy(frs);
	}

	@Override
	protected Composite createClientArea(Composite parent) {
		parentComposite=parent;
		clientArea = new Composite(parent, SWT.BORDER);
		clientArea.setLayout(new GridLayout(3, false));
		clientArea.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		Label lblName = new Label(clientArea, SWT.NONE);
		lblName.setText("Nom");
		
		txtName = new Text(clientArea, SWT.BORDER);
		txtName.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		btnGnrer = new Button(clientArea, SWT.NONE);
		btnGnrer.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				int width =(int) eppaisseur.getWidth();
				int height = (int) eppaisseur.getHeight();
				txtName.setText(width+" X "+height+ " mm");
			}
		});
		btnGnrer.setText("Générer");
		
		Label lblWidth = new Label(clientArea, SWT.NONE);
		lblWidth.setText("Longeur");
		
		txtWidth = DoubleTextFieldFactory.createDoubleTextField(clientArea,SWT.BORDER);
		txtWidth.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));
		
		lblLargeur = new Label(clientArea, SWT.NONE);
		lblLargeur.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblLargeur.setText("Largeur");
		
		txtLargeur = DoubleTextFieldFactory.createDoubleTextField(clientArea,SWT.BORDER);
		txtLargeur.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));
		
		this.shell.setText("Editeur du Panneaux");
		parent.requestLayout();
		if(eppaisseur!=null) {
			initDataBindings();
		}
		return clientArea;
	}

	@Override
	public boolean terminer() {
		if(!super.terminer()) {
			return false;
		}
		String originName =txtName.getText().trim();
//		double originEp = Double.valueOf(txtEp.getText().trim());

		this.eppaisseur.setName(originName);
//		this.frs.setEpaisseur(originEp);
		if(getUpdateMode()==EditorWindow.create) {
			ResourceManagers.getIntance().getGestion().getPanelsizes().getPanelSizes().add(eppaisseur);
		}
		ResourceManagers.getIntance().saveGestion();
		finish();
		return true;
	}
	
	@Override
	protected void cancel() {
		this.eppaisseur.setName(this.eppaisseurOrigin.getName());

	}
	@Override
	public boolean check() {
		errorExist=false;
		errorMessage="";
		String name =txtName.getText().trim();
		if(name==null || name.isEmpty()) {
			errorExist=true;
			errorMessage="Le nom est obligatoire";
		}
		String swidth=txtWidth.getText().trim();
		try {
			double width=Double.valueOf(swidth);
		} catch (NumberFormatException e) {
			errorExist=true;
			errorMessage="Le longeur est non ";
			e.printStackTrace();
		}
		return !errorExist;
	}
	protected DataBindingContext initDataBindings() {
		DataBindingContext bindingContext = new DataBindingContext();
		//
		IObservableValue observeTextTxtNameObserveWidget = WidgetProperties.text(new int[]{SWT.Modify, SWT.FocusOut}).observe(txtName);
		IObservableValue nameChantObserveValue = PojoProperties.value("name").observe(eppaisseur);
		bindingContext.bindValue(observeTextTxtNameObserveWidget, nameChantObserveValue, null, null);
		//
		IObservableValue observeTextTxtWidthObserveWidget = WidgetProperties.text(new int[]{SWT.Modify, SWT.FocusOut}).observe(txtWidth);
		IObservableValue widthEppaisseurObserveValue = PojoProperties.value("width").observe(eppaisseur);
		UpdateValueStrategy strategy = new UpdateValueStrategy();
		strategy.setConverter(new DoubleToStringConvertor());
		UpdateValueStrategy strategy_1 = new UpdateValueStrategy();
		strategy_1.setConverter(new NumericConvertor());
		bindingContext.bindValue(observeTextTxtWidthObserveWidget, widthEppaisseurObserveValue, strategy, strategy_1);
		//
		IObservableValue observeTextTxtLargeurObserveWidget = WidgetProperties.text(new int[]{SWT.Modify, SWT.FocusOut}).observe(txtLargeur);
		IObservableValue heightEppaisseurObserveValue = PojoProperties.value("height").observe(eppaisseur);
		UpdateValueStrategy strategy_3 = new UpdateValueStrategy();
		strategy_3.setConverter(new DoubleToStringConvertor());
		UpdateValueStrategy strategy_4 = new UpdateValueStrategy();
		strategy_4.setConverter(new NumericConvertor());
		bindingContext.bindValue(observeTextTxtLargeurObserveWidget, heightEppaisseurObserveValue, strategy_3, strategy_4);
		//
		return bindingContext;
	}
}
