package dressing.mathutils;

import com.badlogic.gdx.math.Vector3;

public class Cuboid {
	
	private Vector3 origin;
	private float width, height, depth;
	
	public Cuboid(Vector3 origin, float width, float height, float depth) {
		super();
		this.origin = origin;
		this.width = width;
		this.height = height;
		this.depth = depth;
	}
	
	
	public boolean collide(Cuboid other) {
		//the vector connecting both origins
		Vector3 connecotr = this.origin.sub(other.origin);
		//x axis projection
		if(2 * Math.abs(connecotr.x) - 0.01f > other.getWidth() + this.getWidth())
			return false;
		//y axis projection
		if(2 * Math.abs(connecotr.y) - 0.01f> other.getHeight() + this.getHeight())
			return false;
		//z axis projection
		if(2 * Math.abs(connecotr.z) - 0.01f> other.getDepth() + this.getDepth())
			return false;
		return true;
	}

	public float getWidth() {
		return width;
	}

	public void setWidth(float width) {
		this.width = width;
	}

	public float getHeight() {
		return height;
	}

	public void setHeight(float height) {
		this.height = height;
	}

	public float getDepth() {
		return depth;
	}

	public void setDepth(float depth) {
		this.depth = depth;
	}
	
	public static void main(String[] args) {
		Vector3 origin1 = new Vector3(0,0,0);
		Vector3 origin2 = new Vector3(2,2,2);
		Cuboid cube1 = new Cuboid(origin1, 2, 2, 2);
		Cuboid cube2 = new Cuboid(origin2, 2.5f, 2.1f, 2.5f);
		System.out.println(cube1.collide(cube2));
	}
	
}
