package dressing.handlers.reporting;

import java.awt.Desktop;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Timer;
import java.util.TimerTask;

import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

import dressing.config.WorkspaceConfiguration;
import dressing.model.ProjectManager;
import dressing.model.SuperCadProject;
import gdxapp.DressingRoomApp;
import gdxapp.scenes.Scene;
import gdxapp.screens.room.RoomController;
import gdxapp.screens.room3d.Room3DScreen;
import reporting.htmlReporting.DevisServlet;
import reporting.htmlReporting.JettyServer;
import reporting.htmlReporting.SingleDocKitchenReport;

public class GenerateKitchenReportHandler {

	@Execute
	public void execute(Shell shell) {
		SuperCadProject project = ProjectManager.getManager().getCurrentProject();
		SingleDocKitchenReport report = new SingleDocKitchenReport(project);
		report.setShell(shell);
		try {
			report.bind();
		} catch (Exception e) {
			e.printStackTrace();
			MessageDialog.openError(shell, "erreur lors de création de rapport", e.getMessage());
			return;
		}
		report.generate(false);
		String reportFolder = project.getProjectDirectory() + File.separator + "reporting";
		report.export(reportFolder + File.separator + "report.html");
		writeScriptFile(reportFolder);
		
		try {
			JettyServer.getInstance().restart(reportFolder);
			URI url = new URI(WorkspaceConfiguration.JETTY_HOST + "/" + "report.html");
			Desktop.getDesktop().browse(url);
			Timer timer = new Timer();
	        timer.schedule(new TimerTask() {
	            @Override
	            public void run() {
	                JettyServer.getInstance().registerServlet(DevisServlet.class, "/api/article");
	                DevisServlet.setReport(report);
	            }
	        }, 2000); // Delay for 5 seconds
		} catch (URISyntaxException | IOException e) {
			e.printStackTrace();
		}
	}

	private void writeScriptFile(String reportFolder) {
		String script = """
						// Add event listener to the "ajouter" button
						document.getElementById("add-btn").addEventListener("click", function(event) {
						// Prevent default behavior (optional, depending on your needs)
						event.preventDefault();

				    // Capture the input values
				    const data = {
				        center: document.getElementById("input-center").value,
				        reference: document.getElementById("input-reference").value,
				        designation: document.getElementById("input-designation").value,
				        quantity: document.getElementById("input-qty").value,
				        price: document.getElementById("input-price").value,
				        remise: document.getElementById("input-remise").value
				    };

				    // Send the data to the API using Fetch API
				    fetch("/api/article", { // Replace this with your actual API endpoint
				        method: "POST",
				        headers: {
				            "Content-Type": "application/json"
				        },
				        body: JSON.stringify(data)
				    })
				    .then(response => response.json())
				    .then(data => {
				        location.reload();
				         document.getElementById("input-center").value = "";
				         document.getElementById("input-reference").value = "";
				         document.getElementById("input-designation").value = "";
				         document.getElementById("input-qty").value = "";
				         document.getElementById("input-price").value = "";
				         document.getElementById("input-remise").value = "";
				        console.log("Success:", data);
				        // You can handle updating the UI here
				    })
				    .catch(error => {
				        console.error("Error:", error);
				    });
				});
						""";
		File file = new File(reportFolder + File.separator + "script_api.js");
		try {
			file.getParentFile().mkdirs();
			file.createNewFile();
			FileOutputStream fos = new FileOutputStream(file);
			fos.write(script.getBytes());
			fos.close();

		} catch (Exception e) {
			e.printStackTrace();
		}
		
	}

	@CanExecute
	public boolean canExecute() {
		return ProjectManager.getManager().getCurrentProject() != null &&
				Scene.game.getScreen() instanceof Room3DScreen;
	}

}
