package dressing.ui;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.wb.swt.SWTResourceManager;

import dressing.model.Piece2D;

public class DesignObject3DComposite extends Composite {

	private DataBindingContext m_bindingContext;
	private dressing.model.DesignObject3D designObject3D = null;
	private Label hauteurextLabel;
	private Label hauteurintLabel;
	private Label longeurextLabel;
	private Label longeurintLabel;
	private Label nameLabel;
	private Label profondeurextLabel;
	private Label profondeurintLabel;
	private Label xposLabel;
	private Label yposLabel;
	private Label zposLabel;
	private Label lblBasematerial;
	private Label lblBaseMaterial;
	private Label lblNewLabel;
	private Label lblBackMaterial;
	private TabFolder tabFolder;
	private TabItem tbtmMesures;
	private TabItem tbtmPositions;
	private TabItem tbtmMate;
	private Composite composite;
	private Label lblXposAbsolue;
	private Label lblYposAbsolue;
	private Label lblZposAbsolue;
	private Label XposAbs;
	private Label YposAbs;
	private Label ZposAbs;
	private Label lblFacadeMaterial;
	private Label lblFacade;
	private Label lblTypeMaterial;
	private Label lblmaterialType;
	private Composite elementMatComposite;
	private Composite composite_3;
	private Label lblMaterieaux;
	private Label lblPieceMaterial;
	private Label lblVitreTypeMaterieaux;
	private Label vitreTypeMaterial;

	public DesignObject3DComposite(Composite parent, int style, dressing.model.DesignObject3D newDesignObject3D) {
		this(parent, style);
		setDesignObject3D(newDesignObject3D);
	}

	public DesignObject3DComposite(Composite parent, int style) {
		super(parent, style);
		setLayout(new GridLayout(2, false));
		
				Label label_9 = new Label(this, SWT.NONE);
				label_9.setFont(SWTResourceManager.getFont("Segoe UI", 14, SWT.BOLD | SWT.ITALIC));
				label_9.setForeground(SWTResourceManager.getColor(SWT.COLOR_DARK_GREEN));
				label_9.setText("Nom :");
		
				nameLabel = new Label(this, SWT.NONE);
				nameLabel.setFont(SWTResourceManager.getFont("Segoe UI", 12, SWT.ITALIC));
				nameLabel.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
		
		tabFolder = new TabFolder(this, SWT.NONE);
		GridData gd_tabFolder = new GridData(SWT.FILL, SWT.FILL, false, true, 2, 1);
		gd_tabFolder.heightHint = 236;
		gd_tabFolder.widthHint = 434;
		tabFolder.setLayoutData(gd_tabFolder);
		
		tbtmMesures = new TabItem(tabFolder, SWT.NONE);
		tbtmMesures.setText("Mesures");

		Composite composite_2 = new Composite(tabFolder, SWT.NONE);
		tbtmMesures.setControl(composite_2);
		composite_2.setLayout(new GridLayout(2, false));

		Label label = new Label(composite_2, SWT.NONE);
		label.setText("Hauteur Extérieure :");

		hauteurextLabel = new Label(composite_2, SWT.NONE);
		hauteurextLabel.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));

		Label label_1 = new Label(composite_2, SWT.NONE);
		label_1.setText("Hauteur Intérieure :");

		hauteurintLabel = new Label(composite_2, SWT.NONE);
		hauteurintLabel.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));

		Label label_2 = new Label(composite_2, SWT.NONE);
		label_2.setText("Longueur Extérieure :");

		longeurextLabel = new Label(composite_2, SWT.NONE);
		longeurextLabel.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));

		Label label_3 = new Label(composite_2, SWT.NONE);
		label_3.setText("Longueur Intérieure :");

		longeurintLabel = new Label(composite_2, SWT.NONE);
		longeurintLabel.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));

		Label label_4 = new Label(composite_2, SWT.NONE);
		label_4.setText("Profondeur Extérieure :");

		profondeurextLabel = new Label(composite_2, SWT.NONE);
		profondeurextLabel.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));

		Label label_5 = new Label(composite_2, SWT.NONE);
		label_5.setText("Profondeur Intérieure :");

		profondeurintLabel = new Label(composite_2, SWT.NONE);
		profondeurintLabel.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));

		tbtmPositions = new TabItem(tabFolder, SWT.NONE);
		tbtmPositions.setText("Positions");
		
		Composite composite_1 = new Composite(tabFolder, SWT.NONE);
		tbtmPositions.setControl(composite_1);
		composite_1.setLayout(new GridLayout(2, false));

		Label lblXposRelative = new Label(composite_1, SWT.NONE);
		lblXposRelative.setText("Xpos Relative:");

		xposLabel = new Label(composite_1, SWT.NONE);
		xposLabel.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));

		lblXposAbsolue = new Label(composite_1, SWT.NONE);
		lblXposAbsolue.setText("Xpos Absolue");

		XposAbs = new Label(composite_1, SWT.NONE);
		XposAbs.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));

		Label lblYposRelative = new Label(composite_1, SWT.NONE);
		lblYposRelative.setText("Ypos Relative:");

		yposLabel = new Label(composite_1, SWT.NONE);
		yposLabel.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));

		lblYposAbsolue = new Label(composite_1, SWT.NONE);
		lblYposAbsolue.setText("Ypos Absolue");

		YposAbs = new Label(composite_1, SWT.NONE);
		YposAbs.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));

		Label lblZposRelative = new Label(composite_1, SWT.NONE);
		lblZposRelative.setText("Zpos Relative:");

		zposLabel = new Label(composite_1, SWT.NONE);
		zposLabel.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));

		lblZposAbsolue = new Label(composite_1, SWT.NONE);
		lblZposAbsolue.setText("Zpos Absolue");

		ZposAbs = new Label(composite_1, SWT.NONE);
		ZposAbs.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));

		tbtmMate = new TabItem(tabFolder, SWT.NONE);
		tbtmMate.setText("Matériaux");
		
//		composite = new Composite(tabFolder, SWT.NONE);
//		tbtmMate.setControl(composite);
//		composite.setLayout(new GridLayout(2, false));
		
		elementMatComposite = new Composite(tabFolder, SWT.NONE);
		elementMatComposite.setLayout(new GridLayout(2, false));
		elementMatComposite.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));
		
		lblBasematerial = new Label(elementMatComposite, SWT.NONE);
		lblBasematerial.setText("Base Matériaux :");
		
		lblBaseMaterial = new Label(elementMatComposite, SWT.NONE);
		lblBaseMaterial.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		lblBaseMaterial.setText("base");
		lblBaseMaterial.setSize(0, 15);
		
		lblNewLabel = new Label(elementMatComposite, SWT.NONE);
		lblNewLabel.setText("Dos Matériaux :");
		
		lblBackMaterial = new Label(elementMatComposite, SWT.NONE);
		lblBackMaterial.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		lblBackMaterial.setText("back");
		
		lblFacadeMaterial = new Label(elementMatComposite, SWT.NONE);
		lblFacadeMaterial.setText("Façade Matériaux :");
		
		lblFacade = new Label(elementMatComposite, SWT.NONE);
		lblFacade.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		lblFacade.setText("facade");
		
		composite_3 = new Composite(tabFolder, SWT.NONE);
		composite_3.setLayout(new GridLayout(2, false));
		composite_3.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));
		
		lblMaterieaux = new Label(composite_3, SWT.NONE);
		lblMaterieaux.setText("Matériaux");
		
		lblPieceMaterial = new Label(composite_3, SWT.NONE);
		
		lblTypeMaterial = new Label(composite_3, SWT.NONE);
		lblTypeMaterial.setText("Type Matériaux :");
		
		lblmaterialType = new Label(composite_3, SWT.NONE);
		lblmaterialType.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, true, false, 1, 1));
		lblmaterialType.setSize(0, 15);
		
		lblVitreTypeMaterieaux = new Label(composite_3, SWT.NONE);
		lblVitreTypeMaterieaux.setText("Matériau de la vitre :");
		
		vitreTypeMaterial = new Label(composite_3, SWT.NONE);
		tbtmMate.setControl(elementMatComposite);

		if (designObject3D != null) {
			m_bindingContext = initDataBindings();
		}
	}

	@Override
	protected void checkSubclass() {
		// Disable the check that prevents subclassing of SWT components
	}

	public dressing.model.DesignObject3D getDesignObject3D() {
		return designObject3D;
	}

	public void setDesignObject3D(dressing.model.DesignObject3D newDesignObject3D) {
		setDesignObject3D(newDesignObject3D, true);
	}

	public void setDesignObject3D(dressing.model.DesignObject3D newDesignObject3D, boolean update) {
		designObject3D = newDesignObject3D;
		if (update) {
			if (m_bindingContext != null) {
				m_bindingContext.dispose();
				m_bindingContext = null;
			}
			if (designObject3D != null) {
				m_bindingContext = initDataBindings();
				boolean visible=false;
				if(designObject3D instanceof Piece2D) {
					Piece2D piece=((Piece2D) designObject3D);
					if(piece.getMaterialType()!=null && piece.getMaterialType().getMaterial()!=null && piece.getMaterialType().getMaterial().getName()!=null) 						
					{
						lblmaterialType.setText(piece.getMaterialType().getMaterial().getName());
					}
					if(piece.getMaterial()!=null && piece.getMaterial().getName()!=null) 
					{
						lblPieceMaterial.setText(piece.getMaterial().getName());
					}
					if(piece.getVitreMaterialType()!=null &&piece.getVitreMaterialType().getMaterial()!=null 
							&& piece.getVitreMaterialType().getMaterial().getName()!=null) 						
					{
						vitreTypeMaterial.setText(piece.getVitreMaterialType().getMaterial().getName());
					}
					visible=true;
//					
					
				}
				elementMatComposite.setVisible(!visible);
				composite_3.setVisible(visible);
				if(visible) {
					tbtmMate.setControl(composite_3);
				}else {
					tbtmMate.setControl(elementMatComposite);

				}
				tbtmMate.getControl().redraw();
			}
		}
	}
	protected DataBindingContext initDataBindings() {
		DataBindingContext bindingContext = new DataBindingContext();
		//
		IObservableValue hauteurextObserveWidget = WidgetProperties.text().observe(hauteurextLabel);
		IObservableValue hauteurextObserveValue = BeanProperties.value("hauteurext").observe(designObject3D);
		bindingContext.bindValue(hauteurextObserveWidget, hauteurextObserveValue, null, null);
		//
		IObservableValue hauteurintObserveWidget = WidgetProperties.text().observe(hauteurintLabel);
		IObservableValue hauteurintObserveValue = BeanProperties.value("hauteurint").observe(designObject3D);
		bindingContext.bindValue(hauteurintObserveWidget, hauteurintObserveValue, null, null);
		//
		IObservableValue longeurextObserveWidget = WidgetProperties.text().observe(longeurextLabel);
		IObservableValue longeurextObserveValue = BeanProperties.value("longeurext").observe(designObject3D);
		bindingContext.bindValue(longeurextObserveWidget, longeurextObserveValue, null, null);
		//
		IObservableValue longeurintObserveWidget = WidgetProperties.text().observe(longeurintLabel);
		IObservableValue longeurintObserveValue = BeanProperties.value("longeurint").observe(designObject3D);
		bindingContext.bindValue(longeurintObserveWidget, longeurintObserveValue, null, null);
		//
		IObservableValue nameObserveWidget = WidgetProperties.text().observe(nameLabel);
		IObservableValue nameObserveValue = BeanProperties.value("name").observe(designObject3D);
		bindingContext.bindValue(nameObserveWidget, nameObserveValue, null, null);
		//
		IObservableValue profondeurextObserveWidget = WidgetProperties.text().observe(profondeurextLabel);
		IObservableValue profondeurextObserveValue = BeanProperties.value("profondeurext").observe(designObject3D); 
		bindingContext.bindValue(profondeurextObserveWidget, profondeurextObserveValue, null, null);
		//
		IObservableValue profondeurintObserveWidget = WidgetProperties.text().observe(profondeurintLabel);
		IObservableValue profondeurintObserveValue = BeanProperties.value("profondeurint").observe(designObject3D);  
		bindingContext.bindValue(profondeurintObserveWidget, profondeurintObserveValue, null, null);
		//
		IObservableValue xposObserveWidget = WidgetProperties.text().observe(xposLabel);
		IObservableValue xposObserveValue = BeanProperties.value("xpos").observe(designObject3D); 
		bindingContext.bindValue(xposObserveWidget, xposObserveValue, null, null);
		//
		IObservableValue yposObserveWidget = WidgetProperties.text().observe(yposLabel);
		IObservableValue yposObserveValue = BeanProperties.value("ypos").observe(designObject3D);
		bindingContext.bindValue(yposObserveWidget, yposObserveValue, null, null);
		//
		IObservableValue zposObserveWidget = WidgetProperties.text().observe(zposLabel);
		IObservableValue zposObserveValue = BeanProperties.value("zpos").observe(designObject3D);
		bindingContext.bindValue(zposObserveWidget, zposObserveValue, null, null);
		//
		IObservableValue observeTextLblBaseMaterialObserveWidget_1 = WidgetProperties.text().observe(lblBaseMaterial);
		IObservableValue basematerialnameDesignObject3DObserveValue = BeanProperties.value("basematerial.name").observe(designObject3D);
		bindingContext.bindValue(observeTextLblBaseMaterialObserveWidget_1, basematerialnameDesignObject3DObserveValue, null, null);
		//
		IObservableValue observeTextLblBackMaterialObserveWidget_1 = WidgetProperties.text().observe(lblBackMaterial);
		IObservableValue backmaterialnameDesignObject3DObserveValue = BeanProperties.value("backmaterial.name").observe(designObject3D);
		bindingContext.bindValue(observeTextLblBackMaterialObserveWidget_1, backmaterialnameDesignObject3DObserveValue, null, null);
		//
		IObservableValue observeTextXposAbsObserveWidget = WidgetProperties.text().observe(XposAbs);
		IObservableValue xPosABSDesignObject3DObserveValue = BeanProperties.value("XPosABS").observe(designObject3D);
		bindingContext.bindValue(observeTextXposAbsObserveWidget, xPosABSDesignObject3DObserveValue, null, null);
		//
		IObservableValue observeTextYposAbsObserveWidget = WidgetProperties.text().observe(YposAbs);
		IObservableValue yPosABSDesignObject3DObserveValue = BeanProperties.value("YPosABS").observe(designObject3D);
		bindingContext.bindValue(observeTextYposAbsObserveWidget, yPosABSDesignObject3DObserveValue, null, null);
		//
		IObservableValue observeTextZposAbsObserveWidget = WidgetProperties.text().observe(ZposAbs);
		IObservableValue zPosABSDesignObject3DObserveValue = BeanProperties.value("ZPosABS").observe(designObject3D);
		bindingContext.bindValue(observeTextZposAbsObserveWidget, zPosABSDesignObject3DObserveValue, null, null);
		//
		IObservableValue observeTextLblFacadeObserveWidget_1 = WidgetProperties.text().observe(lblFacade);
		IObservableValue facadeMaterialnameDesignObject3DObserveValue = BeanProperties.value("facadeMaterial.name").observe(designObject3D);
		bindingContext.bindValue(observeTextLblFacadeObserveWidget_1, facadeMaterialnameDesignObject3DObserveValue, null, null);
		//
		return bindingContext;
	}
}
