package dressing.model;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class ProjectRoot extends ObservableEntity implements TreeElement{
	
	SuperCadProject project;
	transient private boolean notificationon=true;
	private transient PropertyChangeListener pcl=new PropertyChangeListener() {
		@Override
		public void propertyChange(PropertyChangeEvent evt) {
			if(!evt.getPropertyName().equalsIgnoreCase("selected")) {
				firePropertyChangeEvent("project.modify", null, evt.getNewValue());
			}	
		}
	};
	@Override
	public Object getDirectParent() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public boolean hasChildren() {
		// TODO Auto-generated method stub
		return project != null;
	}

	@Override
	public Object[] getChildren() {
		// TODO Auto-generated method stub
		if(this.project == null)
			return new Object[] {};
		return new Object[] {this.project};
	}

	@Override
	public String getNodeName() {
		// TODO Auto-generated method stub
		return "";
	}

	@Override
	public String getLabelIconPath() {
		// TODO Auto-generated method stub
		return "";
	}

	public SuperCadProject getProject() {
		return project;
	}

	public void setProject(SuperCadProject project) {
		SuperCadProject oldValue=this.project;
		project.setRoot(this);
		this.project = project;
		firePropertyChangeEvent("project", oldValue, project);
	}
	
	public void addProject(SuperCadProject projet,boolean fromfile) {
		if(this.project!=null) {
			this.project.removePropertyChangeListener(pcl);
		}
		if (projet != null) {
			this.project = projet;
			projet.addPropertyChangeListener(pcl);
			if(fromfile)
			{
				firePropertyChangeEvent("project.read", null, projet);
			}
			else
			{
				firePropertyChangeEvent("project.modify", null, projet);
			}
			

		}
	}
	public void setNotificationon(boolean notificationon) {
		this.notificationon = notificationon;
	}
	public boolean isNotificationon() {
		return notificationon;
	}
	public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
		if(isNotificationon())
		{
			getPropertyChangeSupport().firePropertyChange(propertyName, oldValue,newValue);
		}
	}
	
}
