package dressing.io;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

import javax.imageio.ImageIO;

import org.eclipse.swt.graphics.Rectangle;
import org.json.simple.parser.JSONParser;
import org.lwjgl.util.vector.Matrix;

import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.math.Matrix4;

public class IOUtilities {

	private static JSONParser jsonParser;
	private static boolean initialized;

	public static String readTextFile(String path) {
		File file = new File(path);
		FileInputStream stream = null;
		try {
			stream = new FileInputStream(file);
			byte[] buffer = new byte[(int) file.length()];
			stream.read(buffer);
			return new String(buffer);
		} catch (IOException e) {
			return "";
		}
	}
	
	

	public static void addStringTofile(File parent, String path, String content) {
		File file = new File(parent, path);
		BufferedWriter writerfile = null;
		try {
			try {
				writerfile = new BufferedWriter(new FileWriter(file));
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			try {
				writerfile.append(content);
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		} finally {
			if (writerfile != null)
				try {
					writerfile.close();

				} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
		}

	}

	public static String getPathRelativeToParent(String parent, String filePath) {
        Path parentPath = Paths.get(parent).toAbsolutePath().normalize();
        Path file = Paths.get(filePath).toAbsolutePath().normalize();

        if (!file.startsWith(parentPath)) {
            throw new IllegalArgumentException("The file is not inside the specified parent directory.");
        }
        return parentPath.relativize(file).toString();
    }
	
	public static void pngToJpg(String path) throws IOException {
		Path source = Paths.get(path);
		Path target = Paths.get(path.substring(0, path.length() - 3) + "jpg");
		BufferedImage originalImage = ImageIO.read(source.toFile()); // create a blank, RGB, same width and height
		BufferedImage newBufferedImage = new BufferedImage(originalImage.getWidth(), originalImage.getHeight(),
				BufferedImage.TYPE_INT_RGB);
		// draw a white background and puts the originalImage on it.
		newBufferedImage.createGraphics().drawImage(originalImage, 0, 0, Color.WHITE, null);
		// save an image
		ImageIO.write(newBufferedImage, "jpg", target.toFile());
	}

	// construct and return a libgdx Texture Object from an swt image
	public static Texture swtImageToGdxTexture(org.eclipse.swt.graphics.Image image) {
		Rectangle rec = image.getBounds();
		int[] ipixels = new int[rec.width * rec.height];
		for (int i = 0; i < rec.height; i++) {
			image.getImageData().getPixels(0, i, rec.width, ipixels, rec.width * i);
		}
		byte[] bpixels = new byte[ipixels.length];
		int twoPow16 = (int) Math.pow(2, 16);
		for (int i = 0; i < ipixels.length; i++) {
			bpixels[i] = (byte) (ipixels[i] / twoPow16);
		}
		Pixmap pix = new Pixmap(bpixels, 0, bpixels.length);
		Texture texture = new Texture(pix);
		pix.dispose();
		return texture;
	}



	public static void copyFileUsingChannel(File source, File dest) throws IOException {

		if (source.getAbsolutePath() == dest.getAbsolutePath())
			return;

		if (!dest.exists()) {
			dest.getParentFile().mkdirs();
			dest.createNewFile();
		}
		FileChannel sourceChannel = null;
		FileChannel destChannel = null;
		try {
			sourceChannel = new FileInputStream(source).getChannel();
			destChannel = new FileOutputStream(dest).getChannel();
			destChannel.transferFrom(sourceChannel, 0, sourceChannel.size());

		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			if (sourceChannel != null)
				sourceChannel.close();
			if (destChannel != null)
				destChannel.close();
		}
	}

	public static String updateRefPath(String oldPath, String newPath) {

		// oldPath = oldPath.replaceAll("\\", "!");
		String[] elementOldpath = oldPath.split("\\\\");
		String elementadd = "\\\\";
		for (String element : elementOldpath) {
			// if (element.contains(".png")) {
			// elementadd = elementadd+"texture_" ;
			// break;
			// }
		}
		newPath = newPath + elementadd;
		return newPath;
	}

	public static void deleteFolder(File folder) {
		File[] files = folder.listFiles();
		if (files != null) { // some JVMs return null for empty dirs
			for (File f : files) {
				if (f.isDirectory()) {
					deleteFolder(f);
				} else {
					f.delete();
				}
			}
		}
		folder.delete();
	}

	public static void zipFile(File fileToZip, String fileName, ZipOutputStream zipOut) throws IOException {
		if (fileToZip.isHidden()) {
			return;
		}
		if (fileToZip.isDirectory()) {
			if (fileName.endsWith("/")) {
				zipOut.putNextEntry(new ZipEntry(fileName));
				zipOut.closeEntry();
			} else {
				zipOut.putNextEntry(new ZipEntry(fileName + "/"));
				zipOut.closeEntry();
			}
			File[] children = fileToZip.listFiles();
			for (File childFile : children) {
				zipFile(childFile, fileName + "/" + childFile.getName(), zipOut);
			}
			return;
		}
		FileInputStream fis = new FileInputStream(fileToZip);
		ZipEntry zipEntry = new ZipEntry(fileName);
		zipOut.putNextEntry(zipEntry);
		byte[] bytes = new byte[1024];
		int length;
		while ((length = fis.read(bytes)) >= 0) {
			zipOut.write(bytes, 0, length);
		}
		fis.close();
	}

	public static void UnzipFile() {
		String fileZip = "C:/Users/MEUBLENA/OneDrive/Bureau/test/cadtest.cad";
		IOUtilities.UnzipFile(fileZip, "C:/Users/MEUBLENA/OneDrive/Bureau/test1/unzipTest2");
	}

	public static void UnzipFile(String srcFilePath, String destFilePath) {

		File destDir = new File(destFilePath);
		byte[] buffer = new byte[1024];
		try {
			ZipInputStream zis = new ZipInputStream(new FileInputStream(srcFilePath));

			ZipEntry zipEntry = zis.getNextEntry();
			while (zipEntry != null) {
				File newFile = newFile(destDir, zipEntry);
				if (zipEntry.isDirectory()) {
					if (!newFile.isDirectory() && !newFile.mkdirs()) {
						throw new IOException("Failed to create directory " + newFile);
					}
				} else {
					// fix for Windows-created archives
					File parent = newFile.getParentFile();
					if (!parent.isDirectory() && !parent.mkdirs()) {
						throw new IOException("Failed to create directory " + parent);
					}

					// write file content
					FileOutputStream fos = new FileOutputStream(newFile);
					int len;
					while ((len = zis.read(buffer)) > 0) {
						fos.write(buffer, 0, len);
					}
					fos.close();
				}
				zipEntry = zis.getNextEntry();
			}
			zis.closeEntry();
			zis.close();
		} catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	public static File newFile(File destinationDir, ZipEntry zipEntry) throws IOException {
		File destFile = new File(destinationDir, zipEntry.getName());

		String destDirPath = destinationDir.getCanonicalPath();
		String destFilePath = destFile.getCanonicalPath();

		if (!destFilePath.startsWith(destDirPath + File.separator)) {
			throw new IOException("Entry is outside of the target dir: " + zipEntry.getName());
		}

		return destFile;
	}

	public static String convertPathToFileHandlerPath(String path) {
		return path.replace("\\", "/");
	}

	public static ArrayList<File> listFilesRec(File parent) {
		ArrayList<File> files = new ArrayList<File>();
		for (File file : parent.listFiles()) {
			if (file.isFile()) {
				files.add(file);
			} else {
				files.addAll(listFilesRec(file));
			}
		}
		return files;
	}

	public static JSONParser getJsonParser() {
		if (jsonParser == null)
			jsonParser = new JSONParser();
		return jsonParser;
	}
	
	public static void main(String[] args) {
		File source = new File("C:\\Users\\nadhe\\OneDrive\\Bureau\\imagessss.jpg");
		File destination = new File("C:\\ProgramData\\supercad.2.1.0\\icons\\dog.jpg");
		try {
			copyFileUsingChannel(source, destination);
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

}
