/*
 * Decompiled with CFR 0.152.
 */
package api.graphics;

import api.graphics.Camera;
import api.graphics.IDrawable;
import api.graphics.IScene;
import api.graphics.ModelInstance;
import api.graphics.Shader;
import api.input.InputMultiplexer;
import api.ui.CameraController;
import api.ui.DualModeCameraController;
import java.util.ArrayList;
import org.joml.Vector3f;

public class Scene
implements IScene {
    protected Camera camera;
    protected Shader shader;
    protected Shader debugShader;
    protected ArrayList<IDrawable> drawables;
    protected DualModeCameraController cameraController;

    @Override
    public void init() {
        this.shader = new Shader("C:\\ProgramData\\supercad\\shaders\\pbr\\vertex.glsl", "C:\\ProgramData\\supercad\\shaders\\pbr\\frag.glsl");
        this.debugShader = new Shader("C:\\ProgramData\\supercad\\shaders\\shape shader\\vertx.glsl", "C:\\ProgramData\\supercad\\shaders\\shape shader\\frag.glsl");
        this.drawables = new ArrayList();
        this.camera = new Camera(new Vector3f(5.0f, 2.0f, 5.0f), new Vector3f(0.0f, 1.0f, 0.0f), 1.0f, -90.0f, 0.0f);
        this.camera.lookAt(new Vector3f());
        this.cameraController = new DualModeCameraController(this.camera);
        InputMultiplexer.getInstance().pushEventHandler(this.cameraController);
    }

    @Override
    public void render(long delta) {
        for (IDrawable drawable : this.drawables) {
            this.shader.begin(this.camera);
            drawable.draw(this.shader, this.camera);
        }
    }

    public void renderVertices() {
        for (IDrawable drawable : this.drawables) {
            if (!(drawable instanceof ModelInstance)) continue;
            ModelInstance instance = (ModelInstance)drawable;
            instance.getVertices();
        }
    }

    public void renderFaces() {
    }

    public void renderEdges() {
    }

    public void addDrawable(IDrawable drawable) {
        this.drawables.add(drawable);
    }

    @Override
    public void resize(int width, int height) {
        float aspectRatio = (float)width / (float)height;
        this.camera.setAspectRatio(aspectRatio);
    }

    @Override
    public void dispose() {
        this.drawables.clear();
    }

    @Override
    public long getLastFrame() {
        return 0L;
    }

    @Override
    public CameraController getCameraController() {
        return this.cameraController;
    }

    public Camera getCamera() {
        return this.camera;
    }

    public void setCamera(Camera camera) {
        this.camera = camera;
    }

    public void reset() {
        this.drawables.clear();
        this.camera.setPosition(new Vector3f(5.0f, 2.0f, 5.0f));
        this.camera.lookAt(new Vector3f());
        this.camera.aspectRatio = 1.0f;
        this.camera.Zoom = 45.0f;
    }
}

