package supercad.xml;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

import dressing.config.UserPreference;
import supercad.persistence.databinding.XmlMapper;
import supercad.xml.XmlTag.TAG_TYPE;

public class XmlParser {
	
	private HashMap<Integer, XmlTag> tags = new HashMap<Integer, XmlTag>();
	private XmlTag header;
	
	//return the top level element found in the xml
	public XmlNode parseDoc(String xml) {
		XmlNode document = new XmlNode();
		parse(xml, document);
		return document;
	}
	
	public void parse(String raw, XmlNode parent) {
		String trimmed = raw.trim();
		if(trimmed.length() == 0)
			return;
		String currentTag = "";
		String currentElement = "";
		int depth = 0;
		int index = 0;
		boolean readTag = false;
		do {
			char currentChar = trimmed.charAt(index++);
			currentElement += currentChar;
			if(currentChar == '<')
				readTag = true;
			if(readTag)
				currentTag += currentChar;
			if(currentChar == '>') {
				readTag = false;
				XmlTag tag = new XmlTag(currentTag);
				//currentTag is a header or a comment 
				if(!currentTag.startsWith("<?xml") && !currentTag.startsWith("<!--")) {
					TAG_TYPE type = tag.getType();
					if(type == TAG_TYPE.OPENING) {
						depth++;
					}else {
						if(tag.getType() == TAG_TYPE.CLOSING) {
							depth--;
						}
						//wether the element is root self closing element or a closed element
						if(depth == 0) {
							XmlNode node = new XmlNode();
							node.setRawString(currentElement);
							parseElement(node);
							parent.addChild(node);
							currentElement = "";
						}
					}
				}else {
					currentElement = "";
				}
				currentTag = "";
			}
		}while(index < trimmed.length());
		if(currentElement.length() > 0)
			parent.setValue(currentElement);
	}
	
	
	public  void parseElement(XmlNode node) {
		String trimmed = node.getRawString().trim();
		if(!trimmed.startsWith("<"))
			throw new Error("invalid xml element");
		String startTag = trimmed.substring(0, trimmed.indexOf('>') + 1);
		XmlTag tag = new XmlTag(startTag);
		node.setName(tag.getTagName());
		node.setAttributes(tag.getAttrs());
		if(tag.getType() != TAG_TYPE.SELF_CLOSING) {
			int i = trimmed.indexOf(startTag) + startTag.length();
			trimmed = trimmed.substring(i);
			int index = trimmed.length() - 1;
			do {
				index--;
			}while(trimmed.charAt(index) != '<');
			String rawContent = trimmed.substring(0,index);
			parse(rawContent, node);
		}
	}
	
	
	
	public static void main(String...strings) {
		XmlParser parser = new XmlParser();
		File file = new File("C:\\Users\\nadhe\\OneDrive\\Bureau\\pref.xml");
		try {
			XmlMapper mapper = new XmlMapper();
			mapper.fromXml(new FileInputStream(file), UserPreference.class);
		}catch (Exception e) {
			e.printStackTrace();
		}
	}
}
