package supercad.p2.update;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

import org.frs.supercad.config.ConfigurationManager;

public class UpdateService {

	private String url_cuba ;
	private static final String client_id = "client";
	private static final String client_secret = "secret";
	private static final String header = "Basic Y2xpZW50OnNlY3JldA==";
	private String client_name ;
	private String product_name ;

	public String getAccessToken(String username, String password) {
		try {
			String jsonResponse = getAccessTokenRequest(username, password);
			return extractAccessToken(jsonResponse); // Retourne directement le token
		} catch (Exception e) {
			return "Error: " + e.getMessage();
		}
	}

	public String getAccessTokenRequest(String username, String password) {
		try {
			String authHeader = header;

			Map<String, String> parameters = new HashMap<>();
			parameters.put("client_id", client_id);
			parameters.put("client_secret", client_secret);
			parameters.put("username", username);
			parameters.put("password", password);
			parameters.put("grant_type", "password");

			String formData = parameters.entrySet().stream()
					.map(e -> e.getKey() + "=" + URLEncoder.encode(e.getValue(), StandardCharsets.UTF_8))
					.collect(Collectors.joining("&"));
			url_cuba = ConfigurationManager.getProperty("URL_CUBA") ;
			
			 if (url_cuba == null || url_cuba.isEmpty()) {
		            throw new IllegalStateException("La propriété 'URL_CUBA' est manquante dans le fichier de configuration.");
		        }
			String accessTokenUrl = url_cuba + "app/rest/v2/oauth/token";
			URL url = new URL(accessTokenUrl);
			HttpURLConnection connection = (HttpURLConnection) url.openConnection();

			// Configure la connexion
			connection.setRequestMethod("POST");
			connection.setRequestProperty("Authorization", authHeader);
			connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
			connection.setDoOutput(true);

			// Envoie les données
			try (DataOutputStream wr = new DataOutputStream(connection.getOutputStream())) {
				wr.writeBytes(formData);
				wr.flush();
			}

			// Lit la réponse
			int responseCode = connection.getResponseCode();
			if (responseCode == HttpURLConnection.HTTP_OK) {
				try (BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()))) {
					return in.lines().collect(Collectors.joining());
				}
			} else {
				try (BufferedReader in = new BufferedReader(new InputStreamReader(connection.getErrorStream()))) {
					return "Error: " + in.lines().collect(Collectors.joining());
				}
			}
		} catch (IOException e) {
			return "Exception: " + e.getMessage();
		}
	}

	private String extractAccessToken(String jsonResponse) throws Exception {
		// Si la réponse est déjà le token brut (pas de JSON)
		if (jsonResponse != null && !jsonResponse.startsWith("{") && !jsonResponse.isEmpty()) {
			return jsonResponse;
		}

		// Sinon, extraire du JSON (pour rétrocompatibilité)
		String tokenKey = "\"access_token\":\"";
		int start = jsonResponse.indexOf(tokenKey);
		if (start != -1) {
			start += tokenKey.length();
			int end = jsonResponse.indexOf("\"", start);
			return jsonResponse.substring(start, end);
		}
		throw new Exception("Format de réponse inconnu");
	}

	public boolean isAuthenticationSuccessful(String response) {
		return response != null && !response.startsWith("Error:") && !response.isEmpty()
				&& !response.contains("exception") && !response.contains("invalid");
	}

	public String registerBuild(String token, String buildNumber) {
		try {
			
			client_name = ConfigurationManager.getProperty("CLIENT_NAME") ;
			product_name = ConfigurationManager.getProperty("PRODUCT_NAME") ;
			 if (client_name == null || client_name.isEmpty()) {
		            throw new IllegalStateException("La propriété 'CLIENT_NAME' est manquante dans le fichier de configuration.");
		        }
			 if (product_name == null || product_name.isEmpty()) {
		            throw new IllegalStateException("La propriété 'PRODUCT_NAME' est manquante dans le fichier de configuration.");
		        }
			// Construction des paramètres URL
			String queryString = String.format("nameposte=%s&nameclient=%s&numbuild=%s&nameproduct=%s",
					URLEncoder.encode(InetAddress.getLocalHost().getHostName(), StandardCharsets.UTF_8),
					URLEncoder.encode(client_name, StandardCharsets.UTF_8),
					URLEncoder.encode(buildNumber, StandardCharsets.UTF_8),
					URLEncoder.encode(product_name, StandardCharsets.UTF_8));

			// Construction de l'URL complète
			URL url = new URL(url_cuba
					+ "app/rest/v2/services/interventionfrs_InstalledBuildService/createInstalledBuild?" + queryString);

			System.out.println("URL de la requête: " + url.toString()); // Log pour débogage

			HttpURLConnection connection = (HttpURLConnection) url.openConnection();
			connection.setRequestMethod("GET");
			connection.setRequestProperty("Authorization", "Bearer " + token);
			connection.setRequestProperty("Accept", "application/json"); // Modification importante

			// Vérification du code de réponse
			int responseCode = connection.getResponseCode();
			System.out.println("Code de réponse: " + responseCode);

			if (responseCode == HttpURLConnection.HTTP_OK) {
				try (BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()))) {
					String response = in.lines().collect(Collectors.joining());
					System.out.println("Réponse serveur: " + response);
					return response;
				}
			} else {
				try (BufferedReader in = new BufferedReader(new InputStreamReader(connection.getErrorStream()))) {
					String errorResponse = in.lines().collect(Collectors.joining());
					throw new IOException("Code " + responseCode + ": " + errorResponse);
				}
			}
		} catch (IOException e) {
			System.err.println("Erreur lors de l'enregistrement: " + e.getMessage());
			return "{\"etat\":\"ERROR\",\"message\":\"" + e.getMessage().replace("\"", "\\\"") + "\"}";
		}
	}

	public String checkLastRelease(String token, String currentBuildNumber) {
		try {

			String servicePath = "app/rest/v2/services/interventionfrs_ReadyBuildService/lastBuildClient";

			String queryParams = String.format("?nameclient=%s&numbuild=%s&nameproduct=%s",
					URLEncoder.encode(client_name, StandardCharsets.UTF_8),
					URLEncoder.encode(currentBuildNumber, StandardCharsets.UTF_8),
					URLEncoder.encode(product_name, StandardCharsets.UTF_8));

			URL url = new URL(url_cuba + servicePath + queryParams);
			System.out.println("[LastRelease] URL: " + url.toString());

			HttpURLConnection connection = (HttpURLConnection) url.openConnection();
			connection.setRequestMethod("GET");
			connection.setRequestProperty("Authorization", "Bearer " + token);
			connection.setRequestProperty("Accept", "application/json");
			connection.setConnectTimeout(10000);
			connection.setReadTimeout(10000);

			int responseCode = connection.getResponseCode();
			System.out.println("[LastRelease] Code HTTP: " + responseCode);

			try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()))) {
				String response = reader.lines().collect(Collectors.joining());
				System.out.println("[LastRelease] Réponse: " + response);
				return response;
			}
		} catch (IOException e) {
			System.err.println("[LastRelease] Erreur: " + e.getMessage());
			return String.format("{\"etat\":\"ERROR\",\"message\":\"%s\"}", e.getMessage().replace("\"", "\\\""));
		}
	}

	public String interpretLastReleaseResponse(String jsonResponse, String currentBuild) {
		try {
			// Parsing simple sans librairie externe
			String etat = extractJsonValue(jsonResponse, "etat");
			String code = extractJsonValue(jsonResponse, "code");
			String message = extractJsonValue(jsonResponse, "message");
			String serverBuild = extractJsonValue(jsonResponse, "value");

			if ("OK".equals(etat)) {
				return "MISE À JOUR DISPONIBLE\n" + "Votre version: " + currentBuild + "\n" + "Dernière version: "
						+ serverBuild + "\n" + message;
			} else if ("NOEWBUILD".equals(code)) {
				return "VOUS AVEZ LA DERNIÈRE VERSION\n" + message;
			} else if ("CONFLITBUILD".equals(code)) {
				return "VERSION PLUS RÉCENTE QUE LE SERVEUR!\n" + message;
			} else {
				return "ERREUR: " + message;
			}
		} catch (Exception e) {
			return "ERREUR D'ANALYSE: " + e.getMessage();
		}
	}

	private String extractJsonValue(String json, String key) {
		String pattern = "\"" + key + "\":\"";
		int start = json.indexOf(pattern);
		if (start == -1) {
			pattern = "\"" + key + "\":";
			start = json.indexOf(pattern);
			if (start == -1)
				return "";
			start += pattern.length();
			int end = json.indexOf(",", start);
			if (end == -1)
				end = json.indexOf("}", start);
			return json.substring(start, end).replace("\"", "");
		}
		start += pattern.length();
		int end = json.indexOf("\"", start);
		return end > start ? json.substring(start, end) : "";
	}
}
