package dressing.ui;

import java.util.List;
import java.util.UUID;

import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

import dressing.config.persistence.ResourceManagers;
import dressing.model.ModelProvider;
import dressing.ui.util.EditorWindow;
import dressing.ui.util.ListEditorWindow;
import dressing.ui.util.StringViewerComparator;
import param.Chant;
import param.Country;
import param.Finition;
import param.Fournisseur_fabricant;
import param.Material;
import param.PanelSize;
import param.ParamFactory;

public class PanneauxListWindow extends ListEditorWindow {

	IEventBroker eventBroker;
	public PanneauxListWindow(Shell parentShell, IEventBroker eventBroker) {
		super(parentShell);
		this.eventBroker=eventBroker;
	}

	@Override
	protected Composite createClientArea(Composite parent,int style) {
		Composite clientArea = super.createClientArea(parent, style|SWT.MULTI);
		getShell().setText("Liste des Panneaux");
		return clientArea;
	}
	
	public void createColums(TableViewer tableViewer) {
		ColumnLabelProvider nameLabelProvider=new ColumnLabelProvider() {
			public String getText(Object element) {
				if(element !=null && element instanceof PanelSize ) {
					return ((PanelSize)element).getName();
				}
				return "";
			}
		};
		createColumn(tableViewer, "Nom", true, null, SWT.LEFT, nameLabelProvider, new StringViewerComparator(nameLabelProvider));
		//
		ColumnLabelProvider codeLabelProvider=new ColumnLabelProvider() {
			public String getText(Object element) {
				if(element !=null && element instanceof PanelSize ) {
					return String.valueOf(((PanelSize)element).getWidth());
				}
				return "";
			}
		};
		createColumn(tableViewer, "Longeur", true, null, SWT.LEFT, codeLabelProvider, new StringViewerComparator(codeLabelProvider));
		//
		//
		ColumnLabelProvider mdfLabelProvider=new ColumnLabelProvider() {
			public String getText(Object element) {
				if(element !=null && element instanceof PanelSize ) {
					return String.valueOf(((PanelSize)element).getHeight());
				}
				return "";
			}
		};
		createColumn(tableViewer, "Largeur" , true, null, SWT.CENTER, mdfLabelProvider, new StringViewerComparator(mdfLabelProvider));
		
	}
	
	@Override
	protected void Add() {
		PanelSize panel=ParamFactory.eINSTANCE.createPanelSize();
		panel.setName("");
		PanneauxEditorWindow panelEditorWindow = new PanneauxEditorWindow(shell,panel,EditorWindow.create);
		panelEditorWindow.create();
		int ret=panelEditorWindow.open();
		if(ret==Window.OK) {
			tableViewer.refresh();
		}
	}

	@Override
	protected void Modify() {
		IStructuredSelection selection=tableViewer.getStructuredSelection();
		if(selection!=null  && selection.getFirstElement()!=null && selection.getFirstElement() instanceof PanelSize) {
			PanneauxEditorWindow panelEditorWindow = new PanneauxEditorWindow(shell,(PanelSize) selection.getFirstElement(),EditorWindow.update);
			panelEditorWindow.create();
			int ret=panelEditorWindow.open();
			if(ret==Window.OK) {
				tableViewer.refresh();
			}
		}
	}

	@Override
	protected void delete() {
		boolean ret = MessageDialog.openConfirm(shell, "Confirmation de supression","Voulez vous supprimer les composant sélectionner" );
		if(ret) {
			IStructuredSelection selection=tableViewer.getStructuredSelection();
			if(selection!=null&& !selection.isEmpty()) {
				List selections=selection.toList();
				for(Object obj:selections) {
					if(obj!=null && obj instanceof PanelSize) {
						ResourceManagers.getIntance().getGestion().getPanelsizes().getPanelSizes().remove(obj);
						ResourceManagers.getIntance().saveGestion();
					}
				}
				tableViewer.refresh();
			}
		}
		

	}

	@Override
	protected void view() {
		IStructuredSelection selection=tableViewer.getStructuredSelection();
		if(selection!=null  && selection.getFirstElement()!=null && selection.getFirstElement() instanceof PanelSize) {
			PanneauxEditorWindow panelEditorWindow = new PanneauxEditorWindow(shell,(PanelSize) selection.getFirstElement(),EditorWindow.View);
			panelEditorWindow.create();
			panelEditorWindow.open();
			
		}

	}

	@Override
	public List<?> getInput() {
		return ResourceManagers.getIntance().getGestion().getPanelsizes().getPanelSizes();
	}

	@Override
	protected ViewerFilter createListFilter() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	protected Composite createSearchArea(Composite parent, int style) {
		// TODO Auto-generated method stub
		return null;
	}

}
