package dressing.config;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;

import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.frs.resources.downloder.DownloaderUI;
import org.frs.supercad.config.ConfigurationManager;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

import dressing.config.persistence.ResourceManagers;
import dressing.model.ProjectManager;

public class Activator implements BundleActivator {
	
	private LicenseChecker licenseChecker;
	private BundleContext context;
	private String requiredResource;

	@Override
	public void start(BundleContext context) throws Exception {
		this.context = context;

		//check if ware in dev or prod envirement
		if (System.getProperty("osgi.dev") == null) {
			UnifiedLogger.init();
		}
        
		try {
			licenseChecker = new LicenseChecker() {
				@Override
				public boolean hasValidLicense() throws InvalidKeyException, NoSuchPaddingException,
						NoSuchAlgorithmException, InvalidAlgorithmParameterException, BadPaddingException,
						IllegalBlockSizeException, IOException {

					if (System.getProperty("osgi.dev") != null) {
						return true ;
					}
					
					return super.hasValidLicense();
				}
			};
			if (!licenseChecker.hasValidLicense()) {
				Display.getDefault().syncExec(() -> {
					MessageDialog.openError(Display.getCurrent().getActiveShell(), "Problème License",
							"Votre License n'est pas valide");
					System.exit(1);
				});
				return;
			}
		} catch (Exception e) {
			Display.getDefault().syncExec(() -> {
				MessageDialog.openError(Display.getCurrent().getActiveShell(), "Problème License",
						"Problème lors de lecture license !");
				System.exit(1);
			});
			e.printStackTrace();

		}
		loadRequiredResourceFromConfig();
		if (!checkResource()) {
			DownloaderUI downloaderUI = new DownloaderUI();
			downloaderUI.open();
			while (!checkResource() || !downloaderUI.isDownloadCompleted()) {
				Thread.sleep(1000);
			}
			SwingUtilities.invokeLater(() -> downloaderUI.dispose());
		}

		//load resource here 
		ResourceManagers.getIntance();
		ProjectManager.getInstance();
		UserPreference.getPreference().load();
	}

	@Override
	public void stop(BundleContext context) throws Exception {}

	private void loadRequiredResourceFromConfig() {
		String dataPath = ConfigurationManager.getProperty("DATA_PATH");
		String dataVersion = ConfigurationManager.getProperty("DATA_VERSION");

		if (dataPath != null) {
			if (dataVersion == null || dataVersion.isEmpty()) {
				requiredResource = dataPath;
			} else {
				requiredResource = dataPath + File.separator + dataVersion;
			}

		} else {
			JOptionPane.showMessageDialog(null,
					"Les chemins de ressources ne sont pas définis dans le fichier de configuration.", "Attention",
					JOptionPane.WARNING_MESSAGE);
		}
	}
	
	private boolean checkResource() {
		if (requiredResource == null) return false;
		File resFile = new File(requiredResource);
		return resFile.exists();
	}
	
}
